/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.netty.protocol.Decoders;
import org.apache.uniffle.common.netty.protocol.Encoders;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;

public class SendShuffleDataRequest
extends RequestMessage {
    private String appId;
    private int shuffleId;
    private long requireId;
    private Map<Integer, List<ShuffleBlockInfo>> partitionToBlocks;
    private long timestamp;

    public SendShuffleDataRequest(long requestId, String appId, int shuffleId, long requireId, Map<Integer, List<ShuffleBlockInfo>> partitionToBlocks, long timestamp) {
        super(requestId);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.requireId = requireId;
        this.partitionToBlocks = partitionToBlocks;
        this.timestamp = timestamp;
    }

    @Override
    public Message.Type type() {
        return Message.Type.SEND_SHUFFLE_DATA_REQUEST;
    }

    @Override
    public int encodedLength() {
        int encodeLength = 8 + ByteBufUtils.encodedLength(this.appId) + 4 + 8 + 4;
        for (Map.Entry<Integer, List<ShuffleBlockInfo>> entry : this.partitionToBlocks.entrySet()) {
            encodeLength += 8;
            for (ShuffleBlockInfo sbi : entry.getValue()) {
                encodeLength += Encoders.encodeLengthOfShuffleBlockInfo(sbi);
            }
        }
        return encodeLength + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.getRequestId());
        ByteBufUtils.writeLengthAndString(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeLong(this.requireId);
        this.encodePartitionData(buf);
        buf.writeLong(this.timestamp);
    }

    private static Map<Integer, List<ShuffleBlockInfo>> decodePartitionData(ByteBuf byteBuf) {
        HashMap partitionToBlocks = Maps.newHashMap();
        int lengthOfPartitionData = byteBuf.readInt();
        for (int i = 0; i < lengthOfPartitionData; ++i) {
            int partitionId = byteBuf.readInt();
            int lengthOfShuffleBlocks = byteBuf.readInt();
            ArrayList shuffleBlockInfoList = Lists.newArrayList();
            for (int j = 0; j < lengthOfShuffleBlocks; ++j) {
                shuffleBlockInfoList.add(Decoders.decodeShuffleBlockInfo(byteBuf));
            }
            partitionToBlocks.put(partitionId, shuffleBlockInfoList);
        }
        return partitionToBlocks;
    }

    public static SendShuffleDataRequest decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        long requireId = byteBuf.readLong();
        Map<Integer, List<ShuffleBlockInfo>> partitionToBlocks = SendShuffleDataRequest.decodePartitionData(byteBuf);
        long timestamp = byteBuf.readLong();
        return new SendShuffleDataRequest(requestId, appId, shuffleId, requireId, partitionToBlocks, timestamp);
    }

    private void encodePartitionData(ByteBuf buf) {
        buf.writeInt(this.partitionToBlocks.size());
        for (Map.Entry<Integer, List<ShuffleBlockInfo>> entry : this.partitionToBlocks.entrySet()) {
            buf.writeInt(entry.getKey().intValue());
            buf.writeInt(entry.getValue().size());
            for (ShuffleBlockInfo sbi : entry.getValue()) {
                Encoders.encodeShuffleBlockInfo(sbi, buf);
            }
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public long getRequireId() {
        return this.requireId;
    }

    public void setRequireId(long requireId) {
        this.requireId = requireId;
    }

    public Map<Integer, List<ShuffleBlockInfo>> getPartitionToBlocks() {
        return this.partitionToBlocks;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getOperationType() {
        return "sendShuffleData";
    }
}

