/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Queues;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.metrics.MetricsManager;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RPCMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(RPCMetrics.class);
    protected boolean isRegistered = false;
    protected Map<String, Counter.Child> counterMap = JavaUtils.newConcurrentMap();
    protected Map<String, Gauge.Child> gaugeMap = JavaUtils.newConcurrentMap();
    protected Map<String, Summary.Child> transportTimeSummaryMap = JavaUtils.newConcurrentMap();
    protected Map<String, Summary.Child> processTimeSummaryMap = JavaUtils.newConcurrentMap();
    private static final String THREAD_POOL_CORE_SIZE = "rss.server.summary.metric.thread.pool.core.size";
    private static final int THREAD_POOL_CORE_SIZE_DEFAULT_VALUE = 2;
    private static final String THREAD_POOL_MAX_SIZE = "rss.server.summary.metric.thread.pool.max.size";
    private static final int THREAD_POOL_MAX_SIZE_DEFAULT_VALUE = 20;
    private static final String KEEP_ALIVE_TIME = "rss.server.summary.metric.thread.pool.keep.alive.time";
    private static final int KEEP_ALIVE_TIME_DEFAULT_VALUE = 60;
    private final ExecutorService summaryObservePool;
    protected MetricsManager metricsManager;
    protected String tags;

    public RPCMetrics(RssConf rssConf, String tags) {
        this.tags = tags;
        int coreSize = rssConf.getInteger(THREAD_POOL_CORE_SIZE, 2);
        int maxSize = rssConf.getInteger(THREAD_POOL_MAX_SIZE, 20);
        int keepAliveTime = rssConf.getInteger(KEEP_ALIVE_TIME, 60);
        this.summaryObservePool = new ThreadPoolExecutor(coreSize, maxSize, (long)keepAliveTime, TimeUnit.SECONDS, Queues.newLinkedBlockingQueue(), ThreadUtils.getThreadFactory("SummaryObserveThreadPool"));
        LOG.info("Init summary observe thread pool, core size:{}, max size:{}, keep alive time:{}", new Object[]{coreSize, maxSize, keepAliveTime});
    }

    public abstract void registerMetrics();

    public abstract void registerGeneralMetrics();

    public void register(CollectorRegistry collectorRegistry) {
        if (!this.isRegistered) {
            HashMap<String, String> labels = Maps.newHashMap();
            labels.put("tags", this.tags);
            this.metricsManager = new MetricsManager(collectorRegistry, labels);
            this.registerGeneralMetrics();
            this.registerMetrics();
            this.isRegistered = true;
        }
    }

    public void setGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.set(value);
        }
    }

    public void incGauge(String tag) {
        this.incGauge(tag, 1.0);
    }

    public void incGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.inc(value);
        }
    }

    public void decGauge(String tag) {
        this.decGauge(tag, 1.0);
    }

    public void decGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.dec(value);
        }
    }

    public void incCounter(String metricKey) {
        if (this.isRegistered) {
            Counter.Child counter;
            Gauge.Child gauge = this.gaugeMap.get(metricKey);
            if (gauge != null) {
                gauge.inc();
            }
            if ((counter = this.counterMap.get(metricKey)) != null) {
                counter.inc();
            }
        }
    }

    public void decCounter(String metricKey) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(metricKey)) != null) {
            gauge.dec();
        }
    }

    public void recordTransportTime(String methodName, long transportTimeInMillionSecond) {
        Summary.Child summary = this.transportTimeSummaryMap.get(methodName);
        if (summary != null) {
            this.summaryObservePool.execute(() -> summary.observe((double)transportTimeInMillionSecond / 1000.0));
        }
    }

    public void recordProcessTime(String methodName, long processTimeInMillionSecond) {
        Summary.Child summary = this.processTimeSummaryMap.get(methodName);
        if (summary != null) {
            this.summaryObservePool.execute(() -> summary.observe((double)processTimeInMillionSecond / 1000.0));
        }
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.metricsManager.getCollectorRegistry();
    }

    public Map<String, Counter.Child> getCounterMap() {
        return this.counterMap;
    }

    public Map<String, Gauge.Child> getGaugeMap() {
        return this.gaugeMap;
    }

    public Map<String, Summary.Child> getTransportTimeSummaryMap() {
        return this.transportTimeSummaryMap;
    }

    public Map<String, Summary.Child> getProcessTimeSummaryMap() {
        return this.processTimeSummaryMap;
    }
}

