/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.InvocationContextEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public final class InvocationContext<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final ConcurrentMap<Class<?>, Object> data = new ConcurrentHashMap(4);
    private final ConcurrentMap<Class<? extends InvocationContextEvent>, Collection<Consumer<? extends InvocationContextEvent>>> eventHandlers = new ConcurrentHashMap<Class<? extends InvocationContextEvent>, Collection<Consumer<? extends InvocationContextEvent>>>();

    public InvocationContext(Callable<V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V call() throws Exception {
        return this.delegate.call();
    }

    public <T> void set(Class<T> clazz, T object) {
        this.data.put(clazz, object);
    }

    public <T> void remove(Class<T> clazz) {
        this.data.remove(clazz);
    }

    public boolean has(Class<?> clazz) {
        return this.data.containsKey(clazz);
    }

    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.data.get(clazz));
    }

    public <T> T get(Class<T> clazz, T defaultValue) {
        T value = this.get(clazz);
        return value != null ? value : defaultValue;
    }

    public <E extends InvocationContextEvent> void registerEventHandler(Class<E> eventType, Consumer<E> handler) {
        this.eventHandlers.computeIfAbsent(eventType, ignored -> new ConcurrentLinkedQueue()).add(handler);
    }

    public <E extends InvocationContextEvent> void fireEvent(E event) {
        Collection handlers = (Collection)this.eventHandlers.get(event.getClass());
        if (handlers != null) {
            Iterator iterator = handlers.iterator();
            while (iterator.hasNext()) {
                Consumer handler;
                Consumer consumer = handler = (Consumer)iterator.next();
                consumer.accept(event);
            }
        }
    }
}

