/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.ReplayListener;

class LogBufferManager
extends LogObject {
    private final boolean flushPartialBuffers;
    private boolean haveIOException = false;
    private IOException ioexception = null;
    private final Object bufferManagerLock = new Object();
    private final Object forceManagerLock = new Object();
    private LogFileManager lfm = null;
    final boolean forceRequired;
    private LogBuffer fillBuffer = null;
    private LogBuffer[] freeBuffer = null;
    private LogBuffer[] bufferList = null;
    short nextIndex = 0;
    private long waitForBuffer = 0L;
    private long noRoomInBuffer = 0L;
    private int growPoolCounter = 0;
    int nextFillBSN = 1;
    int nextWriteBSN = 1;
    long prevWriteTOD = 0L;
    int buffersWaitingForce = 0;
    int lastForceBSN = 0;
    private long forceCount = 0L;
    private long writeCount = 0L;
    private int minBuffersForced = Integer.MAX_VALUE;
    private int maxBuffersForced = Integer.MIN_VALUE;
    private long totalForceTime = 0L;
    private long totalWriteTime = 0L;
    private long maxWriteTime = 0L;
    private long totalWaitForWriteLockTime = 0L;
    private long totalTimeBetweenForce = 0L;
    private long minTimeBetweenForce = Long.MAX_VALUE;
    private long maxTimeBetweenForce = Long.MIN_VALUE;
    private long lastForceTOD = 0L;
    private int threadsWaitingForce = 0;
    private int maxThreadsWaitingForce = 0;
    private long totalThreadsWaitingForce = 0L;
    private int threadsWaitingForceThreshold = 0;
    long forceOnTimeout = 0L;
    long forceNoWaitingThreads = 0L;
    long forceHalfOfBuffers = 0L;
    long forceMaxWaitingThreads = 0L;
    long forceOnFileSwitch = 0L;
    final FlushManager flushManager;
    private static final String flushManagerName = "FlushManager";
    private LogBuffer[] forceQueue = null;
    private int fqPut = 0;
    private int fqGet = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogBufferManager(Configuration config) {
        super(config);
        this.threadsWaitingForceThreshold = config.getThreadsWaitingForceThreshold();
        this.forceRequired = config.getLogFileMode().equals("rw");
        this.flushPartialBuffers = config.isFlushPartialBuffers();
        this.flushManager = new FlushManager(flushManagerName);
        this.flushManager.setDaemon(true);
        this.flushManager.start();
    }

    final long elapsedTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void force(boolean timeout) throws IOException, InterruptedException {
        LogBuffer logBuffer = null;
        long startWait = System.currentTimeMillis();
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.totalWaitForWriteLockTime += this.elapsedTime(startWait);
            logBuffer = this.forceQueue[this.fqGet];
            this.forceQueue[this.fqGet] = null;
            this.fqGet = (this.fqGet + 1) % this.forceQueue.length;
            if (this.haveIOException) {
                Object object2 = logBuffer.waitingThreadsLock;
                synchronized (object2) {
                    ++logBuffer.waitingThreads;
                }
            }
            try {
                if (!$assertionsDisabled && logBuffer.bsn != this.nextWriteBSN) {
                    throw new AssertionError((Object)("BSN error expecting " + this.nextWriteBSN + " found " + logBuffer.bsn));
                }
                if (!$assertionsDisabled && logBuffer.tod <= this.prevWriteTOD) {
                    throw new AssertionError((Object)("TOD error at BSN: " + logBuffer.bsn));
                }
                long startWrite = System.currentTimeMillis();
                logBuffer.write();
                long writeTime = this.elapsedTime(startWrite);
                this.totalWriteTime += writeTime;
                if (writeTime > this.maxWriteTime) {
                    this.maxWriteTime = writeTime;
                }
                ++this.writeCount;
                this.nextWriteBSN = logBuffer.bsn + 1;
            }
            catch (IOException ioe) {
                this.ioexception = new IOException("LogBufferManager.force(): writing " + logBuffer.lf.file.getName() + "[" + ioe.getMessage() + "]");
                this.ioexception.setStackTrace(ioe.getStackTrace());
                this.haveIOException = true;
            }
            this.threadsWaitingForce += logBuffer.getWaitingThreads();
            if (this.threadsWaitingForce > this.maxThreadsWaitingForce) {
                this.maxThreadsWaitingForce = this.threadsWaitingForce;
            }
            int forcebsn = this.nextWriteBSN - 1;
            boolean doforce = true;
            if (this.haveIOException) {
                doforce = false;
            } else if (timeout) {
                ++this.forceOnTimeout;
            } else if (forcebsn - this.lastForceBSN > this.freeBuffer.length / 2) {
                ++this.forceHalfOfBuffers;
            } else if (this.threadsWaitingForce > this.threadsWaitingForceThreshold) {
                ++this.forceMaxWaitingThreads;
            } else if (logBuffer.forceNow) {
                ++this.forceOnFileSwitch;
            } else if (this.fqGet == this.fqPut) {
                ++this.forceNoWaitingThreads;
            } else {
                doforce = false;
            }
            if (doforce) {
                ++this.forceCount;
                long startForce = System.currentTimeMillis();
                try {
                    logBuffer.lf.force(false);
                }
                catch (IOException ioe) {
                    this.ioexception = new IOException("LogBufferManager.force(): error attempting to force " + logBuffer.lf.file.getName() + "[" + ioe.getMessage() + "]");
                    this.ioexception.setStackTrace(ioe.getStackTrace());
                    this.haveIOException = true;
                    logBuffer.ioexception = ioe;
                }
                this.totalForceTime += this.elapsedTime(startForce);
                if (this.lastForceTOD > 0L) {
                    long timeBetweenForce = startForce - this.lastForceTOD;
                    this.totalTimeBetweenForce += timeBetweenForce;
                    this.minTimeBetweenForce = Math.min(this.minTimeBetweenForce, timeBetweenForce);
                    if (!timeout) {
                        this.maxTimeBetweenForce = Math.max(this.maxTimeBetweenForce, timeBetweenForce);
                    }
                }
                this.lastForceTOD = System.currentTimeMillis();
                if (this.lastForceBSN > 0) {
                    int buffersForced = forcebsn - this.lastForceBSN;
                    this.maxBuffersForced = Math.max(this.maxBuffersForced, buffersForced);
                    this.minBuffersForced = Math.min(this.minBuffersForced, buffersForced);
                }
                this.totalThreadsWaitingForce += (long)this.threadsWaitingForce;
                this.threadsWaitingForce = 0;
                this.lastForceBSN = forcebsn;
            }
            if (doforce || this.haveIOException) {
                this.forceManagerLock.notifyAll();
            }
            while (!this.haveIOException && this.lastForceBSN < logBuffer.bsn) {
                this.forceManagerLock.wait();
            }
        }
        object = logBuffer;
        synchronized (object) {
            if (logBuffer.iostatus == 1) {
                logBuffer.iostatus = 2;
            }
            if (this.haveIOException) {
                logBuffer.iostatus = 3;
                logBuffer.ioexception = this.ioexception;
            }
            logBuffer.notifyAll();
        }
        this.releaseBuffer(logBuffer);
        if (this.haveIOException) {
            throw this.ioexception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(LogBuffer logBuffer) throws IOException, InterruptedException {
        try {
            logBuffer.sync();
        }
        finally {
            this.releaseBuffer(logBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffer(LogBuffer buffer) {
        if (buffer.release() == 0) {
            Object object = this.bufferManagerLock;
            synchronized (object) {
                this.freeBuffer[buffer.index] = buffer;
                this.bufferManagerLock.notifyAll();
                --this.buffersWaitingForce;
                if (!$assertionsDisabled && this.buffersWaitingForce < 0) {
                    throw new AssertionError((Object)("buffersWaitingForce (" + this.buffersWaitingForce + ") < 0"));
                }
            }
        }
    }

    private LogBuffer getFillBuffer() throws LogFileOverflowException {
        if (this.fillBuffer == null) {
            int fbl = this.freeBuffer.length;
            for (int i = 0; this.fillBuffer == null && i < fbl; ++i) {
                this.nextIndex = (short)(this.nextIndex % fbl);
                if (this.freeBuffer[this.nextIndex] != null) {
                    LogBuffer b = this.freeBuffer[this.nextIndex];
                    this.freeBuffer[this.nextIndex] = null;
                    try {
                        this.fillBuffer = b.init(this.nextFillBSN, this.lfm);
                    }
                    catch (LogFileOverflowException e) {
                        this.freeBuffer[this.nextIndex] = b;
                        throw e;
                    }
                    ++this.nextFillBSN;
                }
                this.nextIndex = (short)(this.nextIndex + 1);
            }
        }
        return this.fillBuffer;
    }

    LogBuffer getLogBuffer(int index) throws ClassNotFoundException {
        LogBuffer lb = null;
        Class<?> lbcls = this.getClass().getClassLoader().loadClass(this.config.getBufferClassName());
        try {
            Constructor<?> lbCtor = lbcls.getDeclaredConstructor(Configuration.class);
            lb = (LogBuffer)lbCtor.newInstance(this.config);
            lb.index = index;
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException(e.toString());
        }
        return lb;
    }

    void fqAdd(LogBuffer buffer) {
        this.fillBuffer = null;
        try {
            this.forceQueue[this.fqPut] = buffer;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw e;
        }
        this.fqPut = (this.fqPut + 1) % this.forceQueue.length;
        ++this.buffersWaitingForce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long put(short type, byte[][] data, boolean sync) throws LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        long token = 0L;
        LogBuffer currentBuffer = null;
        boolean forceNow = false;
        do {
            Object object = this.bufferManagerLock;
            synchronized (object) {
                while ((currentBuffer = this.getFillBuffer()) == null) {
                    ++this.waitForBuffer;
                    this.bufferManagerLock.wait();
                }
                token = currentBuffer.put(type, data, sync);
                if (sync && this.buffersWaitingForce == 0) {
                    forceNow = this.flushPartialBuffers;
                }
                if (token == 0L || forceNow) {
                    this.fqAdd(currentBuffer);
                }
            }
            if (token == 0L) {
                ++this.noRoomInBuffer;
                this.force(false);
                continue;
            }
            if (forceNow) {
                this.force(true);
                this.releaseBuffer(currentBuffer);
                continue;
            }
            if (!sync) continue;
            this.sync(currentBuffer);
        } while (token == 0L);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCurrentBuffer() throws IOException {
        LogBuffer buffer = null;
        Object object = this.bufferManagerLock;
        synchronized (object) {
            if (this.fillBuffer != null) {
                buffer = this.fillBuffer;
                this.fqAdd(buffer);
            }
        }
        if (buffer != null) {
            try {
                this.force(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void replay(ReplayListener listener, long mark, boolean replayCtrlRecords) throws LogConfigurationException, InvalidLogKeyException {
        int markBSN;
        int bsn = this.bsnFromMark(mark);
        if (mark < 0L || bsn == 0 && mark != 0L) {
            throw new InvalidLogKeyException(Long.toHexString(mark));
        }
        LogBuffer buffer = null;
        try {
            buffer = this.getLogBuffer(-1);
        }
        catch (ClassNotFoundException e) {
            throw new LogConfigurationException(e.toString());
        }
        LogRecord record = listener.getLogRecord();
        record.buffer = buffer;
        try {
            this.forceCurrentBuffer();
            this.lfm.read(buffer, bsn);
        }
        catch (IOException e) {
            String msg = "Error reading " + buffer.lf.file + " @ position [" + buffer.lf.position + "]";
            listener.onError(new LogException(msg + e.toString()));
            return;
        }
        catch (InvalidLogBufferException e) {
            listener.onError(new LogException(e.toString()));
            return;
        }
        if (buffer.bsn == -1) {
            if (mark == 0L || mark == this.lfm.getHighMark()) {
                record.type = (short)19983;
                listener.onRecord(record);
                return;
            }
            String msg = "The mark [" + Long.toHexString(mark) + "] requested for replay was not found in the log. " + "activeMark is [" + Long.toHexString(this.lfm.activeMark) + "]";
            throw new InvalidLogKeyException(msg);
        }
        int n = markBSN = mark == 0L ? buffer.bsn : this.bsnFromMark(mark);
        if (markBSN != buffer.bsn) {
            InvalidLogBufferException lbe = new InvalidLogBufferException("block read [" + buffer.bsn + "] not block requested: " + markBSN);
            listener.onError(lbe);
            return;
        }
        try {
            record.get(buffer);
            if (mark > 0L && mark > this.markFromBsn(markBSN, 0)) {
                while (record.key < mark) {
                    record.get(buffer);
                }
                if (record.key != mark) {
                    String msg = "The initial mark [" + Long.toHexString(mark) + "] requested for replay was not found in the log.";
                    throw new InvalidLogKeyException(msg);
                }
            }
        }
        catch (InvalidLogBufferException e) {
            listener.onError(new LogException(e.toString()));
            return;
        }
        long nrecs = 0L;
        int nextBSN = 0;
        while (true) {
            if (record.isEOB()) {
                nextBSN = buffer.bsn + 1;
                try {
                    this.lfm.read(buffer, nextBSN);
                }
                catch (IOException e) {
                    listener.onError(new LogException(e.toString()));
                    return;
                }
                catch (InvalidLogBufferException e) {
                    listener.onError(new LogException(e.toString()));
                    return;
                }
                if (buffer.bsn == -1 || buffer.bsn < nextBSN) {
                    record.type = (short)19983;
                    listener.onRecord(record);
                    return;
                }
            } else if (!record.isCTRL() || replayCtrlRecords) {
                listener.onRecord(record);
            }
            ++nrecs;
            try {
                record.get(buffer);
            }
            catch (InvalidLogBufferException e) {
                listener.onError(e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws ClassNotFoundException {
        int bufferPoolSize = this.config.getMinBuffers();
        this.freeBuffer = new LogBuffer[bufferPoolSize];
        this.bufferList = new LogBuffer[bufferPoolSize];
        for (int i = 0; i < bufferPoolSize; i = (int)((short)(i + 1))) {
            this.freeBuffer[i] = this.getLogBuffer(i);
            this.bufferList[i] = this.freeBuffer[i];
        }
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.forceQueue = new LogBuffer[bufferPoolSize + 1];
            this.fqPut = 0;
            this.fqGet = 0;
        }
        if (this.flushManager != null) {
            this.flushManager.isClosed = false;
        }
    }

    void close() {
        if (this.flushManager != null) {
            this.flushManager.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(LogFileManager lfm, int bsn) {
        if (!$assertionsDisabled && lfm == null) {
            throw new AssertionError((Object)"LogFileManager parameter is null");
        }
        this.lfm = lfm;
        this.nextFillBSN = bsn + 1;
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.nextWriteBSN = this.nextFillBSN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAll() throws IOException {
        LogBuffer buffer = null;
        try {
            Object object = this.bufferManagerLock;
            synchronized (object) {
                if (this.fillBuffer != null) {
                    buffer = this.fillBuffer;
                    this.fqAdd(buffer);
                }
            }
            if (buffer != null) {
                this.force(true);
            }
            for (int i = 0; i < this.freeBuffer.length; ++i) {
                Object object2 = this.bufferManagerLock;
                synchronized (object2) {
                    while (this.freeBuffer[i] == null) {
                        this.bufferManagerLock.wait(100L);
                    }
                    continue;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String doubleToString(double val, int decimalPlaces) {
        String s = "" + val;
        int dp = s.indexOf(46) + 1;
        if (s.length() > dp + decimalPlaces) {
            s = s.substring(0, dp + decimalPlaces);
        }
        return s;
    }

    String getStats() {
        String avgThreadsWaitingForce = this.doubleToString((double)this.totalThreadsWaitingForce / (double)this.forceCount, 2);
        String avgForceTime = this.doubleToString((double)this.totalForceTime / (double)this.forceCount, 2);
        String avgTimeBetweenForce = this.doubleToString((double)this.totalTimeBetweenForce / (double)this.forceCount, 2);
        String avgBuffersPerForce = this.doubleToString((double)this.writeCount / (double)this.forceCount, 2);
        String avgWriteTime = this.doubleToString((double)this.totalWriteTime / (double)this.writeCount, 2);
        String avgWaitForWriteLockTime = this.doubleToString((double)this.totalWaitForWriteLockTime / (double)this.writeCount, 2);
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<LogBufferManager  class='" + name + "'>" + "\n  <bufferSize value='" + this.config.getBufferSize() * 1024 + "'>Buffer Size (in bytes)</bufferSize>" + "\n  <poolsize    value='" + this.freeBuffer.length + "'>Number of buffers in the pool</poolsize>" + "\n  <initialPoolSize value='" + this.config.getMinBuffers() + "'>Initial number of buffers in the pool</initialPoolSize>" + "\n  <growPoolCounter value='" + this.growPoolCounter + "'>Number of times buffer pool was grown</growPoolCounter>" + "\n  <bufferwait  value='" + this.getWaitForBuffer() + "'>Wait for available buffer</bufferwait>" + "\n  <bufferfull  value='" + this.noRoomInBuffer + "'>Buffer full</bufferfull>" + "\n  <nextfillbsn value='" + this.nextFillBSN + "'></nextfillbsn>" + "\n  <writeStats>" + "\n    <writeCount  value='" + this.writeCount + "'>Number of channel.write() calls</writeCount>" + "\n    <totalWriteTime   value='" + this.totalWriteTime + "'>Total time (ms) spent in channel.write</totalWriteTime>" + "\n    <avgWriteTime value='" + avgWriteTime + "'>Average channel.write() time (ms)</avgWriteTime>" + "\n    <maxWriteTime value='" + this.maxWriteTime + "'>Maximum channel.write() time (ms)</maxWriteTime>" + "\n    <totalWaitForWriteLockTime   value='" + this.totalWaitForWriteLockTime + "'>Total time (ms) spent waiting for forceManagerLock to issue a write</totalWaitForWriteLockTime>" + "\n    <avgWaitForWriteLockTime   value='" + avgWaitForWriteLockTime + "'>Average time (ms) spent waiting for forceManagerLock to issue a write</avgWaitForWriteLockTime>" + "\n  </writeStats>" + "\n  <forceStats>" + "\n    <forceCount  value='" + this.forceCount + "'>Number of channel.force() calls</forceCount>" + "\n    <totalForceTime   value='" + this.totalForceTime + "'>Total time (ms) spent in channel.force</totalForceTime>" + "\n    <avgForceTime value='" + avgForceTime + "'>Average channel.force() time (ms)</avgForceTime>" + "\n    <totalTimeBetweenForce value='" + this.totalTimeBetweenForce + "'>Total time (ms) between calls to channel.force()</totalTimeBetweenForce>" + "\n    <minTimeBetweenForce value='" + this.minTimeBetweenForce + "'>Minimum time (ms) between calls to channel.force()</minTimeBetweenForce>" + "\n    <maxTimeBetweenForce value='" + this.maxTimeBetweenForce + "'>Maximum time (ms) between calls to channel.force()</maxTimeBetweenForce>" + "\n    <avgTimeBetweenForce value='" + avgTimeBetweenForce + "'>Average time (ms) between calls to channel.force()</avgTimeBetweenForce>" + "\n    <avgBuffersPerForce value='" + avgBuffersPerForce + "'>Average number of buffers per force</avgBuffersPerForce>" + "\n    <minBuffersForced value='" + this.minBuffersForced + "'>Minimum number of buffers forced</minBuffersForced>" + "\n    <maxBuffersForced value='" + this.maxBuffersForced + "'>Maximum number of buffers forced</maxBuffersForced>" + "\n    <maxThreadsWaitingForce value='" + this.maxThreadsWaitingForce + "'>maximum threads waiting</maxThreadsWaitingForce>" + "\n    <avgThreadsWaitingForce value='" + avgThreadsWaitingForce + "'>Avg threads waiting force</avgThreadsWaitingForce>" + "\n  </forceStats>" + "\n  <forceReasons>" + "\n    <forceOnTimeout value='" + this.forceOnTimeout + "'></forceOnTimeout>" + "\n    <forceNoWaitingThreads value='" + this.forceNoWaitingThreads + "'>force because no other threads waiting on force</forceNoWaitingThreads>" + "\n    <forceHalfOfBuffers value='" + this.forceHalfOfBuffers + "'>force due to 1/2 of buffers waiting</forceHalfOfBuffers>" + "\n    <forceMaxWaitingThreads value='" + this.forceMaxWaitingThreads + "'>force due to max waiting threads</forceMaxWaitingThreads>" + "\n    <forceOnFileSwitch value='" + this.forceOnFileSwitch + "'>force last block prior to switching to next file</forceOnFileSwitch>" + "\n  </forceReasons>" + "\n  <LogBufferPool>" + "\n");
        for (int i = 0; i < this.freeBuffer.length; ++i) {
            if (this.freeBuffer[i] == null) continue;
            stats.append(this.freeBuffer[i].getStats());
        }
        stats.append("\n</LogBufferPool>\n</LogBufferManager>\n");
        return stats.toString();
    }

    int bsnFromMark(long mark) {
        return (int)(mark >> 24);
    }

    long markFromBsn(int bsn, int offset) {
        return (long)bsn << 24 | (long)offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getWaitForBuffer() {
        Object object = this.bufferManagerLock;
        synchronized (object) {
            return this.waitForBuffer;
        }
    }

    static /* synthetic */ LogBuffer[] access$1602(LogBufferManager x0, LogBuffer[] x1) {
        x0.bufferList = x1;
        return x1;
    }

    static /* synthetic */ LogBuffer[] access$002(LogBufferManager x0, LogBuffer[] x1) {
        x0.freeBuffer = x1;
        return x1;
    }

    static /* synthetic */ LogBuffer[] access$2002(LogBufferManager x0, LogBuffer[] x1) {
        x0.forceQueue = x1;
        return x1;
    }

    static {
        $assertionsDisabled = !LogBufferManager.class.desiredAssertionStatus();
    }

    class FlushManager
    extends Thread {
        boolean isClosed;

        FlushManager(String name) {
            super(name);
            this.isClosed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogBuffer buffer = null;
            LogBufferManager parent = LogBufferManager.this;
            int flushSleepTime = LogBufferManager.this.config.getFlushSleepTime();
            long waitForBuffer = parent.getWaitForBuffer();
            while (!FlushManager.interrupted()) {
                try {
                    FlushManager.sleep(flushSleepTime);
                    if (this.isClosed) continue;
                    long bufferWaits = parent.getWaitForBuffer() - waitForBuffer;
                    int maxBuffers = LogBufferManager.this.config.getMaxBuffers();
                    int increment = LogBufferManager.this.freeBuffer.length / 2;
                    if (maxBuffers > 0) {
                        maxBuffers = Math.max(maxBuffers, LogBufferManager.this.freeBuffer.length);
                        increment = Math.min(increment, maxBuffers - LogBufferManager.this.freeBuffer.length);
                    }
                    if (increment > 0 && bufferWaits > (long)increment) {
                        LogBuffer[] fb = new LogBuffer[LogBufferManager.this.freeBuffer.length + increment];
                        LogBuffer[] bl = new LogBuffer[fb.length];
                        ++LogBufferManager.this.growPoolCounter;
                        boolean haveNewArray = true;
                        for (int i = LogBufferManager.this.freeBuffer.length; i < fb.length; ++i) {
                            try {
                                fb[i] = LogBufferManager.this.getLogBuffer(i);
                                bl[i] = fb[i];
                                continue;
                            }
                            catch (ClassNotFoundException e) {
                                haveNewArray = false;
                                break;
                            }
                        }
                        if (haveNewArray) {
                            LogBuffer[] fq = new LogBuffer[fb.length + 1];
                            Object object = LogBufferManager.this.bufferManagerLock;
                            synchronized (object) {
                                int i;
                                for (i = 0; i < LogBufferManager.this.bufferList.length; ++i) {
                                    bl[i] = LogBufferManager.this.bufferList[i];
                                }
                                LogBufferManager.access$1602(LogBufferManager.this, bl);
                                for (i = 0; i < LogBufferManager.this.freeBuffer.length; ++i) {
                                    fb[i] = LogBufferManager.this.freeBuffer[i];
                                }
                                LogBufferManager.access$002(LogBufferManager.this, fb);
                                Object object2 = LogBufferManager.this.forceManagerLock;
                                synchronized (object2) {
                                    int fqx = 0;
                                    while (LogBufferManager.this.fqGet != LogBufferManager.this.fqPut) {
                                        fq[fqx++] = LogBufferManager.this.forceQueue[LogBufferManager.this.fqGet++];
                                        LogBufferManager.this.fqGet %= LogBufferManager.this.forceQueue.length;
                                    }
                                    LogBufferManager.access$2002(LogBufferManager.this, fq);
                                    LogBufferManager.this.fqGet = 0;
                                    LogBufferManager.this.fqPut = fqx % LogBufferManager.this.forceQueue.length;
                                }
                            }
                        }
                    }
                    waitForBuffer = parent.getWaitForBuffer();
                    Object object = LogBufferManager.this.bufferManagerLock;
                    synchronized (object) {
                        buffer = LogBufferManager.this.fillBuffer;
                        if (buffer != null && buffer.shouldForce()) {
                            LogBufferManager.this.fqAdd(buffer);
                        } else {
                            buffer = null;
                        }
                    }
                    if (buffer == null) continue;
                    ++parent.forceOnTimeout;
                    LogBufferManager.this.force(true);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (IOException e) {
                    System.err.println("FlushManager: IOException in force(true)");
                    continue;
                }
                break;
            }
            return;
        }
    }

    public class WriteStats
    implements WriteStatsMBean {
        public final long getWriteCount() {
            return LogBufferManager.this.writeCount;
        }

        public final double getAverageWriteTime() {
            return (double)LogBufferManager.this.totalWriteTime / (double)LogBufferManager.this.writeCount;
        }

        public final double getMaximumWriteTime() {
            return (double)LogBufferManager.this.maxWriteTime / 1000.0;
        }

        public final double getAverageWaitForWriteLockTime() {
            return (double)LogBufferManager.this.totalWaitForWriteLockTime / (double)LogBufferManager.this.writeCount;
        }

        public final long getWaitForBuffer() {
            LogBufferManager parent = LogBufferManager.this;
            return parent.getWaitForBuffer();
        }
    }

    public static interface WriteStatsMBean {
        public long getWriteCount();

        public double getAverageWriteTime();

        public double getMaximumWriteTime();

        public double getAverageWaitForWriteLockTime();

        public long getWaitForBuffer();
    }

    public class ForceStats
    implements ForceStatsMBean {
        public final double getAverageThreadsWaitingForce() {
            return (double)LogBufferManager.this.totalThreadsWaitingForce / (double)LogBufferManager.this.forceCount;
        }

        public final long getForceCount() {
            return LogBufferManager.this.forceCount;
        }

        public final double getAverageForceTime() {
            return (double)LogBufferManager.this.totalForceTime / (double)LogBufferManager.this.forceCount;
        }

        public final int getMinTimeBetweenForce() {
            return (int)LogBufferManager.this.minTimeBetweenForce;
        }

        public final int getMaxTimeBetweenForce() {
            return (int)LogBufferManager.this.maxTimeBetweenForce;
        }

        public final double getAverageTimeBetweenForce() {
            return (double)LogBufferManager.this.totalTimeBetweenForce / (double)LogBufferManager.this.forceCount;
        }

        public final double getAverageBuffersPerForce() {
            return (double)LogBufferManager.this.writeCount / (double)LogBufferManager.this.forceCount;
        }

        public final int getMinBuffersForced() {
            return LogBufferManager.this.minBuffersForced;
        }

        public final int getMaxBuffersForced() {
            return LogBufferManager.this.maxBuffersForced;
        }

        public final int getMaxThreadsWaitingForce() {
            return LogBufferManager.this.maxThreadsWaitingForce;
        }
    }

    public static interface ForceStatsMBean {
        public double getAverageThreadsWaitingForce();

        public long getForceCount();

        public double getAverageForceTime();

        public int getMinTimeBetweenForce();

        public int getMaxTimeBetweenForce();

        public double getAverageTimeBetweenForce();

        public double getAverageBuffersPerForce();

        public int getMinBuffersForced();

        public int getMaxBuffersForced();

        public int getMaxThreadsWaitingForce();
    }

    public class BufferPoolStats
    implements BufferPoolStatsMBean {
        public final int getBufferPoolCurrentSize() {
            return LogBufferManager.this.freeBuffer.length;
        }

        public final int getBufferPoolInitialSize() {
            return LogBufferManager.this.config.getMinBuffers();
        }

        public final int getBufferPoolGrowCount() {
            return LogBufferManager.this.growPoolCounter;
        }
    }

    public static interface BufferPoolStatsMBean {
        public int getBufferPoolCurrentSize();

        public int getBufferPoolInitialSize();

        public int getBufferPoolGrowCount();
    }
}

