/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.enterprise.identitystore.openid;

import jakarta.security.enterprise.identitystore.openid.Claims;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public interface JwtClaims
extends Claims {
    public static final JwtClaims NONE = new JwtClaims(){

        @Override
        public Optional<String> getStringClaim(String name) {
            return Optional.empty();
        }

        @Override
        public Optional<Instant> getNumericDateClaim(String name) {
            return Optional.empty();
        }

        @Override
        public List<String> getArrayStringClaim(String name) {
            return Collections.emptyList();
        }

        @Override
        public OptionalInt getIntClaim(String name) {
            return OptionalInt.empty();
        }

        @Override
        public OptionalLong getLongClaim(String name) {
            return OptionalLong.empty();
        }

        @Override
        public OptionalDouble getDoubleClaim(String name) {
            return OptionalDouble.empty();
        }

        @Override
        public Optional<Claims> getNested(String name) {
            return Optional.empty();
        }
    };

    default public Optional<String> getIssuer() {
        return this.getStringClaim("iss");
    }

    default public Optional<String> getSubject() {
        return this.getStringClaim("sub");
    }

    default public List<String> getAudience() {
        return this.getArrayStringClaim("aud");
    }

    default public Optional<Instant> getExpirationTime() {
        return this.getNumericDateClaim("exp");
    }

    default public boolean isExpired(Clock clock, boolean required, Duration skew) {
        return this.getExpirationTime().map(exp -> clock.millis() - exp.toEpochMilli() > skew.toMillis()).orElse(required);
    }

    default public Optional<Instant> getNotBeforeTime() {
        return this.getNumericDateClaim("nbf");
    }

    default public boolean isBeforeValidity(Clock clock, boolean required, Duration skew) {
        return this.getNotBeforeTime().map(nbf -> nbf.toEpochMilli() - clock.millis() > skew.toMillis()).orElse(required);
    }

    default public boolean isValid() {
        Duration skew = Duration.ofMinutes(1L);
        return !this.isExpired(Clock.systemUTC(), true, skew) && !this.isBeforeValidity(Clock.systemUTC(), false, skew);
    }

    default public Optional<Instant> getIssuedAt() {
        return this.getNumericDateClaim("iat");
    }

    default public Optional<String> getJwtId() {
        return this.getStringClaim("jti");
    }
}

