/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TransformSerializer;

public class GraphBinaryWriter {
    private final TypeSerializerRegistry registry;
    private static final byte VALUE_FLAG_NULL = 1;
    private static final byte VALUE_FLAG_NONE = 0;
    public static final byte VERSION_BYTE = -127;
    private static final byte[] unspecifiedNullBytes = new byte[]{DataType.UNSPECIFIED_NULL.getCodeByte(), 1};
    private static final byte[] customTypeCodeBytes = new byte[]{DataType.CUSTOM.getCodeByte()};

    public GraphBinaryWriter() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryWriter(TypeSerializerRegistry registry) {
        this.registry = registry;
    }

    public <T> void writeValue(T value, Buffer buffer, boolean nullable) throws IOException {
        if (value == null) {
            if (!nullable) {
                throw new IOException("Unexpected null value when nullable is false");
            }
            this.writeValueFlagNull(buffer);
            return;
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        serializer.writeValue(value, buffer, this, nullable);
    }

    public <T> void write(T value, Buffer buffer) throws IOException {
        if (value == null) {
            buffer.writeBytes(unspecifiedNullBytes);
            return;
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        if (serializer instanceof CustomTypeSerializer) {
            CustomTypeSerializer customTypeSerializer = (CustomTypeSerializer)serializer;
            buffer.writeBytes(customTypeCodeBytes);
            this.writeValue(customTypeSerializer.getTypeName(), buffer, false);
            customTypeSerializer.write(value, buffer, this);
            return;
        }
        if (serializer instanceof TransformSerializer) {
            TransformSerializer transformSerializer = (TransformSerializer)serializer;
            this.write(transformSerializer.transform(value), buffer);
            return;
        }
        buffer.writeBytes(serializer.getDataType().getDataTypeBuffer());
        serializer.write(value, buffer, this);
    }

    public <T> void writeFullyQualifiedNull(Class<T> objectClass, Buffer buffer, Object information) throws IOException {
        TypeSerializer<Object> serializer = this.registry.getSerializer(objectClass);
        serializer.write(null, buffer, this);
    }

    public void writeValueFlagNull(Buffer buffer) {
        buffer.writeByte(1);
    }

    public void writeValueFlagNone(Buffer buffer) {
        buffer.writeByte(0);
    }
}

