/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalEnumParser;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolver;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ArgumentVisitor
extends DefaultGremlinBaseVisitor<Object> {
    private final VariableResolver resolver;
    private final GremlinAntlrToJava antlr;

    public ArgumentVisitor(VariableResolver resolver, GremlinAntlrToJava antlr) {
        this.resolver = resolver;
        this.antlr = antlr;
    }

    public boolean parseBoolean(GremlinParser.BooleanArgumentContext ctx) {
        return (Boolean)this.visitBooleanArgument(ctx);
    }

    public Number parseNumber(GremlinParser.IntegerArgumentContext ctx) {
        return (Number)this.visitIntegerArgument(ctx);
    }

    public Number parseNumber(GremlinParser.FloatArgumentContext ctx) {
        return (Number)this.visitFloatArgument(ctx);
    }

    public String parseString(GremlinParser.StringArgumentContext ctx) {
        return (String)this.visitStringArgument(ctx);
    }

    public Date parseDate(GremlinParser.DateArgumentContext ctx) {
        return (Date)this.visitDateArgument(ctx);
    }

    public Object parseObject(GremlinParser.GenericLiteralArgumentContext ctx) {
        return this.visitGenericLiteralArgument(ctx);
    }

    public Direction parseDirection(GremlinParser.TraversalDirectionArgumentContext ctx) {
        return (Direction)((Object)this.visitTraversalDirectionArgument(ctx));
    }

    public Vertex parseVertex(GremlinParser.StructureVertexArgumentContext ctx) {
        return (Vertex)this.visitStructureVertexArgument(ctx);
    }

    public Order parseOrder(GremlinParser.TraversalOrderArgumentContext ctx) {
        return (Order)this.visitTraversalOrderArgument(ctx);
    }

    public Scope parseScope(GremlinParser.TraversalScopeArgumentContext ctx) {
        return (Scope)((Object)this.visitTraversalScopeArgument(ctx));
    }

    public T parseT(GremlinParser.TraversalTokenArgumentContext ctx) {
        return (T)this.visitTraversalTokenArgument(ctx);
    }

    public VertexProperty.Cardinality parseCardinality(GremlinParser.TraversalCardinalityArgumentContext ctx) {
        return (VertexProperty.Cardinality)((Object)this.visitTraversalCardinalityArgument(ctx));
    }

    public Merge parseMerge(GremlinParser.TraversalMergeArgumentContext ctx) {
        return (Merge)((Object)this.visitTraversalMergeArgument(ctx));
    }

    public Pop parsePop(GremlinParser.TraversalPopArgumentContext ctx) {
        return (Pop)((Object)this.visitTraversalPopArgument(ctx));
    }

    public DT parseDT(GremlinParser.TraversalDTArgumentContext ctx) {
        return (DT)((Object)this.visitTraversalDTArgument(ctx));
    }

    public Column parseColumn(GremlinParser.TraversalColumnArgumentContext ctx) {
        return (Column)this.visitTraversalColumnArgument(ctx);
    }

    public Function parseFunction(GremlinParser.TraversalFunctionArgumentContext ctx) {
        return (Function)this.visitTraversalFunctionArgument(ctx);
    }

    public Comparator parseComparator(GremlinParser.TraversalComparatorArgumentContext ctx) {
        return (Comparator)this.visitTraversalComparatorArgument(ctx);
    }

    public Map parseMap(GremlinParser.GenericLiteralMapArgumentContext ctx) {
        return (Map)this.visitGenericLiteralMapArgument(ctx);
    }

    public Map parseMap(GremlinParser.GenericLiteralMapNullableArgumentContext ctx) {
        return (Map)this.visitGenericLiteralMapNullableArgument(ctx);
    }

    public Object[] parseObjectVarargs(GremlinParser.GenericLiteralListArgumentContext ctx) {
        if (ctx.genericLiteralList() != null) {
            return this.antlr.genericVisitor.parseObjectList(ctx.genericLiteralList());
        }
        Object l = this.visitVariable(ctx.variable());
        if (null == l) {
            return null;
        }
        if (l.getClass().isArray()) {
            int length = Array.getLength(l);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Array.get(l, i);
            }
            return result;
        }
        if (l instanceof Iterable) {
            return IteratorUtils.list(((Iterable)l).iterator()).toArray();
        }
        return new Object[]{l};
    }

    public String parseString(GremlinParser.StringNullableArgumentContext ctx) {
        return (String)this.visitStringNullableArgument(ctx);
    }

    @Override
    public Object visitBooleanArgument(GremlinParser.BooleanArgumentContext ctx) {
        if (ctx.booleanLiteral() != null) {
            return this.antlr.genericVisitor.parseBoolean(ctx.booleanLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitIntegerArgument(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.integerLiteral() != null) {
            return this.antlr.genericVisitor.parseIntegral(ctx.integerLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitFloatArgument(GremlinParser.FloatArgumentContext ctx) {
        if (ctx.floatLiteral() != null) {
            return this.antlr.genericVisitor.parseFloating(ctx.floatLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringArgument(GremlinParser.StringArgumentContext ctx) {
        if (ctx.stringLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringNullableArgument(GremlinParser.StringNullableArgumentContext ctx) {
        if (ctx.stringNullableLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringNullableLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitDateArgument(GremlinParser.DateArgumentContext ctx) {
        if (ctx.dateLiteral() != null) {
            return this.antlr.genericVisitor.parseDate(ctx.dateLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralArgument(GremlinParser.GenericLiteralArgumentContext ctx) {
        if (ctx.genericLiteral() != null) {
            return this.antlr.genericVisitor.visitGenericLiteral(ctx.genericLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralListArgument(GremlinParser.GenericLiteralListArgumentContext ctx) {
        if (ctx.genericLiteralList() != null) {
            return this.antlr.genericVisitor.visitChildren((RuleNode)ctx.genericLiteralList());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalDirectionArgument(GremlinParser.TraversalDirectionArgumentContext ctx) {
        if (ctx.traversalDirection() != null) {
            return TraversalEnumParser.parseTraversalDirectionFromContext(ctx.traversalDirection());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStructureVertexArgument(GremlinParser.StructureVertexArgumentContext ctx) {
        if (ctx.structureVertex() != null) {
            return this.antlr.structureVisitor.visitStructureVertex(ctx.structureVertex());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalOrderArgument(GremlinParser.TraversalOrderArgumentContext ctx) {
        if (ctx.traversalOrder() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Order.class, ctx.traversalOrder());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalScopeArgument(GremlinParser.TraversalScopeArgumentContext ctx) {
        if (ctx.traversalScope() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Scope.class, ctx.traversalScope());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalTokenArgument(GremlinParser.TraversalTokenArgumentContext ctx) {
        if (ctx.traversalToken() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(T.class, ctx.traversalToken());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalCardinalityArgument(GremlinParser.TraversalCardinalityArgumentContext ctx) {
        if (ctx.traversalCardinality() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(VertexProperty.Cardinality.class, ctx.traversalCardinality());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalMergeArgument(GremlinParser.TraversalMergeArgumentContext ctx) {
        if (ctx.traversalMerge() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Merge.class, ctx.traversalMerge());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalPopArgument(GremlinParser.TraversalPopArgumentContext ctx) {
        if (ctx.traversalPop() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Pop.class, ctx.traversalPop());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalDTArgument(GremlinParser.TraversalDTArgumentContext ctx) {
        if (ctx.traversalDT() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(DT.class, ctx.traversalDT());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalColumnArgument(GremlinParser.TraversalColumnArgumentContext ctx) {
        if (ctx.traversalColumn() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Column.class, ctx.traversalColumn());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalComparatorArgument(GremlinParser.TraversalComparatorArgumentContext ctx) {
        if (ctx.traversalComparator() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Order.class, ctx.traversalComparator().traversalOrder());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalFunctionArgument(GremlinParser.TraversalFunctionArgumentContext ctx) {
        if (ctx.traversalFunction() != null) {
            GremlinParser.TraversalFunctionContext tfc = ctx.traversalFunction();
            if (tfc.traversalToken() != null) {
                return TraversalEnumParser.parseTraversalEnumFromContext(T.class, tfc.traversalToken());
            }
            if (tfc.traversalColumn() != null) {
                return TraversalEnumParser.parseTraversalEnumFromContext(Column.class, tfc.traversalColumn());
            }
            throw new GremlinParserException("Unrecognized enum for traversal function");
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalBiFunctionArgument(GremlinParser.TraversalBiFunctionArgumentContext ctx) {
        if (ctx.traversalBiFunction() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Operator.class, ctx.traversalBiFunction().traversalOperator());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralMapArgument(GremlinParser.GenericLiteralMapArgumentContext ctx) {
        if (ctx.genericLiteralMap() != null) {
            return this.antlr.genericVisitor.visitGenericLiteralMap(ctx.genericLiteralMap());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralMapNullableArgument(GremlinParser.GenericLiteralMapNullableArgumentContext ctx) {
        if (ctx.nullLiteral() != null) {
            return null;
        }
        if (ctx.genericLiteralMap() != null) {
            return this.antlr.genericVisitor.visitGenericLiteralMap(ctx.genericLiteralMap());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitTraversalSackMethodArgument(GremlinParser.TraversalSackMethodArgumentContext ctx) {
        if (ctx.traversalSackMethod() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(SackFunctions.Barrier.class, ctx.traversalSackMethod());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitVariable(GremlinParser.VariableContext ctx) {
        return this.resolver.apply(ctx.getText(), ctx);
    }
}

