/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.OoxmlUtils;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.type.PaperSizeEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.util.Base64Util;

public class XlsxSheetHelper
extends BaseHelper {
    private int rowIndex;
    private FileBufferedWriter colsWriter = new FileBufferedWriter();
    private FileBufferedWriter mergedCellsWriter = new FileBufferedWriter();
    private FileBufferedWriter hyperlinksWriter = new FileBufferedWriter();
    private XlsxSheetRelsHelper sheetRelsHelper;
    private List<Integer> rowBreaks = new ArrayList<Integer>();
    private final boolean collapseRowSpan;
    private final Integer fitWidth;
    private final Integer fitHeight;
    private final Boolean autoFitPageHeight;
    private final boolean defaultAutoFitRow;

    public XlsxSheetHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxSheetRelsHelper sheetRelsHelper, XlsReportConfiguration configuration) {
        super(jasperReportsContext, writer);
        this.sheetRelsHelper = sheetRelsHelper;
        this.collapseRowSpan = configuration.isCollapseRowSpan();
        this.fitWidth = configuration.getFitWidth();
        this.fitHeight = configuration.getFitHeight();
        this.autoFitPageHeight = configuration.isAutoFitPageHeight();
        this.defaultAutoFitRow = configuration.isAutoFitRow();
    }

    public void exportHeader(boolean showGridlines, int scale, int rowFreezeIndex, int columnFreezeIndex, int maxColumnFreezeIndex, JasperPrint jasperPrint, Color tabColor) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<sheetPr>\n");
        if (tabColor != null) {
            this.write("<tabColor rgb=\"FF" + JRColorUtil.getColorHexa(tabColor) + "\"/>\n");
        }
        this.write("<outlinePr summaryBelow=\"0\"/>\n");
        if (!(scale >= 10 && scale <= 400 || this.fitWidth == null && this.fitHeight == null && Boolean.TRUE != this.autoFitPageHeight)) {
            this.write("<pageSetUpPr fitToPage=\"1\"/>");
        }
        this.write("</sheetPr><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"");
        if (!showGridlines) {
            this.write(" showGridLines=\"0\"");
        }
        if (rowFreezeIndex > 0 || columnFreezeIndex > 0) {
            this.write(">\n<pane" + (columnFreezeIndex > 0 ? " xSplit=\"" + columnFreezeIndex + "\"" : "") + (rowFreezeIndex > 0 ? " ySplit=\"" + rowFreezeIndex + "\"" : ""));
            String columnFreezeName = columnFreezeIndex < 0 ? "A" : JRXlsAbstractExporter.getColumIndexName(columnFreezeIndex, maxColumnFreezeIndex);
            this.write(" topLeftCell=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            String activePane = (rowFreezeIndex > 0 ? "bottom" : "top") + (columnFreezeIndex > 0 ? "Right" : "Left");
            this.write(" activePane=\"" + activePane + "\" state=\"frozen\"/>\n");
            this.write("<selection pane=\"" + activePane + "\"");
            this.write(" activeCell=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            this.write(" sqref=\"" + columnFreezeName + (rowFreezeIndex + 1) + "\"");
            this.write("/>\n");
            this.write("</sheetView>\n</sheetViews>\n");
        } else {
            this.write("/></sheetViews>\n");
        }
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportFooter(int index, PrintPageFormat jasperPrint, boolean isIgnorePageMargins, String autoFilter, Integer scale, Integer firstPageNumber, boolean firstPageNotSet, Integer sheetPageCount, JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings, String password) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        this.write("</sheetData>\n");
        if (password != null && password.trim().length() > 0) {
            byte[] salt = OoxmlUtils.getSalt();
            int spinCount = 100;
            byte[] passwordHash = OoxmlUtils.sha512(password, salt, spinCount);
            this.write("<sheetProtection algorithmName=\"SHA-512\" hashValue=\"");
            this.write(Base64Util.encode(passwordHash, false));
            this.write("\" saltValue=\"");
            this.write(Base64Util.encode(salt, false));
            this.write("\" spinCount=\"" + spinCount + "\" sheet=\"1\" objects=\"1\" scenarios=\"1\"/>\n");
        }
        if (autoFilter != null) {
            this.write("<autoFilter ref=\"" + autoFilter + "\"/>\n");
        }
        if (!this.mergedCellsWriter.isEmpty()) {
            this.write("<mergeCells>\n");
            this.mergedCellsWriter.writeData(this.writer);
            this.write("</mergeCells>\n");
        }
        if (!this.hyperlinksWriter.isEmpty()) {
            this.write("<hyperlinks>\n");
            this.hyperlinksWriter.writeData(this.writer);
            this.write("</hyperlinks>\n");
        }
        this.write("<pageMargins left=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getLeftMargin().intValue())));
        this.write("\" right=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getRightMargin().intValue())));
        this.write("\" top=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getTopMargin().intValue())));
        this.write("\" bottom=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getBottomMargin().intValue())));
        this.write("0");
        this.write("\" header=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getHeaderMargin().intValue())));
        this.write("\" footer=\"");
        this.write(String.valueOf(LengthUtil.inchFloor4Dec(printSettings.getFooterMargin().intValue())));
        this.write("\"/>\n");
        this.write("<pageSetup");
        if (jasperPrint.getOrientation() != null) {
            this.write(" orientation=\"" + jasperPrint.getOrientation().getName().toLowerCase() + "\"");
        }
        if (scale != null && scale > 9 && scale < 401) {
            this.write(" scale=\"" + scale + "\"");
        } else {
            Integer sheetFitHeight;
            if (this.fitWidth != null && this.fitWidth != 1) {
                this.write(" fitToWidth=\"" + this.fitWidth + "\"");
            }
            Integer n = this.fitHeight == null ? (Boolean.TRUE == this.autoFitPageHeight ? sheetPageCount : null) : (sheetFitHeight = this.fitHeight);
            if (sheetFitHeight != null && sheetFitHeight != 1) {
                this.write(" fitToHeight=\"" + sheetFitHeight + "\"");
            }
        }
        PaperSizeEnum pSize = OoxmlUtils.getSuitablePaperSize(printSettings);
        String paperSize = pSize == PaperSizeEnum.UNDEFINED ? "" : " paperSize=\"" + pSize.getOoxmlValue() + "\"";
        this.write(paperSize);
        if (firstPageNumber != null && firstPageNumber > 0) {
            this.write(" firstPageNumber=\"" + firstPageNumber + "\"");
            this.write(" useFirstPageNumber=\"1\"/>\n");
        } else {
            this.write("/>\n");
        }
        if (this.hasHeaderOrFooter(printSettings)) {
            this.write("<headerFooter>");
            if (this.hasHeader(printSettings)) {
                this.write("<oddHeader>");
                if (printSettings.getHeaderLeft() != null && !printSettings.getHeaderLeft().trim().isEmpty()) {
                    this.write("&amp;L");
                    this.write(JRStringUtil.xmlEncode(printSettings.getHeaderLeft()));
                }
                if (printSettings.getHeaderCenter() != null && !printSettings.getHeaderCenter().trim().isEmpty()) {
                    this.write("&amp;C");
                    this.write(JRStringUtil.xmlEncode(printSettings.getHeaderCenter()));
                }
                if (printSettings.getHeaderRight() != null && !printSettings.getHeaderRight().trim().isEmpty()) {
                    this.write("&amp;R");
                    this.write(JRStringUtil.xmlEncode(printSettings.getHeaderRight()));
                }
                this.write("</oddHeader>");
            }
            if (this.hasFooter(printSettings)) {
                this.write("<oddFooter>");
                if (printSettings.getFooterLeft() != null && !printSettings.getFooterLeft().trim().isEmpty()) {
                    this.write("&amp;L");
                    this.write(JRStringUtil.xmlEncode(printSettings.getFooterLeft()));
                }
                if (printSettings.getFooterCenter() != null && !printSettings.getFooterCenter().trim().isEmpty()) {
                    this.write("&amp;C");
                    this.write(JRStringUtil.xmlEncode(printSettings.getFooterCenter()));
                }
                if (printSettings.getFooterRight() != null && !printSettings.getFooterRight().trim().isEmpty()) {
                    this.write("&amp;R");
                    this.write(JRStringUtil.xmlEncode(printSettings.getFooterRight()));
                }
                this.write("</oddFooter>");
            }
            this.write("</headerFooter>\n");
        } else if (!firstPageNotSet) {
            this.write("<headerFooter><oddFooter>&amp;CPage &amp;P</oddFooter></headerFooter>\n");
        }
        if (this.rowBreaks.size() > 0) {
            this.write("<rowBreaks count=\"" + this.rowBreaks.size() + "\" manualBreakCount=\"" + this.rowBreaks.size() + "\">");
            for (Integer rowBreakIndex : this.rowBreaks) {
                this.write("<brk id=\"" + (rowBreakIndex + 1) + "\" man=\"1\"/>");
            }
            this.write("</rowBreaks>\n");
        }
        this.write("<drawing r:id=\"rIdDr" + index + "\"/>");
        this.write("</worksheet>");
    }

    private boolean hasHeaderOrFooter(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings) {
        return this.hasHeader(printSettings) || this.hasFooter(printSettings);
    }

    private boolean hasHeader(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings) {
        return printSettings.getHeaderLeft() != null && !printSettings.getHeaderLeft().trim().isEmpty() || printSettings.getHeaderCenter() != null && !printSettings.getHeaderCenter().trim().isEmpty() || printSettings.getHeaderRight() != null && !printSettings.getHeaderRight().trim().isEmpty();
    }

    private boolean hasFooter(JRXlsAbstractExporter.SheetInfo.SheetPrintSettings printSettings) {
        return printSettings.getFooterLeft() != null && !printSettings.getFooterLeft().trim().isEmpty() || printSettings.getFooterCenter() != null && !printSettings.getFooterCenter().trim().isEmpty() || printSettings.getFooterRight() != null && !printSettings.getFooterRight().trim().isEmpty();
    }

    public void exportColumn(int colIndex, int colWidth, boolean autoFit) {
        try {
            this.colsWriter.write("<col min=\"" + (colIndex + 1) + "\" max=\"" + (colIndex + 1) + "\" customWidth=\"1\" width=\"" + 3.0f * (float)colWidth / 18.0f + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void exportRow(int rowHeight, Cut yCut, XlsRowLevelInfo levelInfo) {
        boolean isAutoFit = yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") ? (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") : this.defaultAutoFitRow;
        this.exportRow(rowHeight, isAutoFit, levelInfo);
    }

    public void exportRow(int rowHeight, boolean isAutoFit, XlsRowLevelInfo levelInfo) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        this.write("<row r=\"" + this.rowIndex + "\"" + (isAutoFit ? " customHeight=\"0\" bestFit=\"1\"" : " customHeight=\"1\"") + " ht=\"" + (isAutoFit ? 0 : rowHeight) + "\"");
        if (levelInfo != null && levelInfo.getLevelMap().size() > 0) {
            this.write(" outlineLevel=\"" + levelInfo.getLevelMap().size() + "\"");
        }
        this.write(">\n");
    }

    public void exportMergedCells(int row, int col, int maxColumnIndex, int rowSpan, int colSpan) {
        int n = rowSpan = this.collapseRowSpan ? 1 : rowSpan;
        if (rowSpan > 1 || colSpan > 1) {
            String ref = JRXlsAbstractExporter.getColumIndexName(col, maxColumnIndex) + (row + 1) + ":" + JRXlsAbstractExporter.getColumIndexName(col + colSpan - 1, maxColumnIndex) + (row + rowSpan);
            try {
                this.mergedCellsWriter.write("<mergeCell ref=\"" + ref + "\"/>\n");
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public void exportHyperlink(int row, int col, int maxColumnIndex, String href, boolean isLocal) {
        String ref = JRXlsAbstractExporter.getColumIndexName(col, maxColumnIndex) + (row + 1);
        try {
            if (isLocal) {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" location=\"" + this.getDefinedName(href) + "\"/>\n");
            } else {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" r:id=\"rIdLnk" + this.sheetRelsHelper.getHyperlink(href) + "\"/>\n");
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void addRowBreak(int rowIndex) {
        this.rowBreaks.add(rowIndex);
    }

    public String getDefinedName(String name) {
        if (name != null) {
            String definedName = name.replaceAll("\\W", "");
            if (!definedName.isEmpty() && Character.isDigit(definedName.charAt(0))) {
                definedName = "_" + definedName;
            }
            return definedName;
        }
        return null;
    }
}

