/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;
    @Autowired
    private AccessTokenService accessTokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection token) {
        Long userId = JWTUtil.getUserId(token.toString());
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        Set<String> permissionSet = this.userService.getPermissions(userId, null);
        simpleAuthorizationInfo.setStringPermissions(permissionSet);
        return simpleAuthorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String credential = (String)authenticationToken.getCredentials();
        String username = JWTUtil.getUserName(credential);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AuthenticationException("the authorization token is invalid");
        }
        User user = this.userService.findByName(username);
        if (user == null || !JWTUtil.verify(credential, username, user.getSalt())) {
            throw new AuthenticationException("the authorization token verification failed.");
        }
        AuthenticationType authType = JWTUtil.getAuthType(credential);
        if (authType == AuthenticationType.OPENAPI) {
            AccessToken accessToken = this.accessTokenService.getByUserId(user.getUserId());
            if (accessToken == null || !accessToken.getToken().equals(WebUtils.encryptToken(credential))) {
                throw new AuthenticationException("the openapi authorization token is invalid");
            }
            if (AccessToken.STATUS_DISABLE.equals(accessToken.getFinalStatus())) {
                throw new AuthenticationException("the openapi authorization token has been disabled, please contact the administrator");
            }
            SecurityUtils.getSubject().getSession().setAttribute((Object)"is_api_token", (Object)true);
        }
        return new SimpleAuthenticationInfo((Object)credential, (Object)credential, "streampark_shiro_realm");
    }
}

