/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Broker<V> {
    private final ConcurrentMap<String, BlockingQueue<V>> mediations = new ConcurrentHashMap<String, BlockingQueue<V>>();

    public void handIn(String key, V obj) {
        if (!this.retrieveSharedQueue(key).offer(obj)) {
            throw new RuntimeException("Could not register the given element, broker slot is already occupied.");
        }
    }

    public V getAndRemove(String key) {
        try {
            V objToShare = this.retrieveSharedQueue(key).take();
            this.mediations.remove(key);
            return objToShare;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        this.mediations.remove(key);
    }

    public V get(String key) {
        try {
            BlockingQueue<V> queue = this.retrieveSharedQueue(key);
            V objToShare = queue.take();
            if (!queue.offer(objToShare)) {
                throw new RuntimeException("Error: Concurrent modification of the broker slot for key '" + key + "'.");
            }
            return objToShare;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private BlockingQueue<V> retrieveSharedQueue(String key) {
        ArrayBlockingQueue queue = (ArrayBlockingQueue)this.mediations.get(key);
        if (queue == null) {
            queue = new ArrayBlockingQueue(1);
            ArrayBlockingQueue commonQueue = this.mediations.putIfAbsent(key, queue);
            return commonQueue != null ? commonQueue : queue;
        }
        return queue;
    }
}

