/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FLINK_CLUSTER_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/cluster"})
public class FlinkClusterController {
    private static final Logger log = LoggerFactory.getLogger(FlinkClusterController.class);
    @Autowired
    private FlinkClusterService flinkClusterService;

    @Operation(summary="List flink clusters")
    @PostMapping(value={"list"})
    public RestResponse list() {
        List<FlinkCluster> flinkClusters = this.flinkClusterService.listCluster();
        return RestResponse.success(flinkClusters);
    }

    @Operation(summary="Get flink cluster remote address")
    @PostMapping(value={"remoteUrl"})
    public RestResponse remoteUrl(Long id) {
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(id);
        return RestResponse.success(cluster.getAddress());
    }

    @Operation(summary="Check the cluster status")
    @PostMapping(value={"check"})
    public RestResponse check(FlinkCluster cluster) {
        ResponseResult checkResult = this.flinkClusterService.check(cluster);
        return RestResponse.success(checkResult);
    }

    @Operation(summary="Create flink cluster")
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"cluster:create"})
    public RestResponse create(FlinkCluster cluster) {
        Boolean success = this.flinkClusterService.create(cluster);
        return RestResponse.success(success);
    }

    @Operation(summary="Update flink cluster")
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"cluster:update"})
    public RestResponse update(FlinkCluster cluster) {
        this.flinkClusterService.update(cluster);
        return RestResponse.success();
    }

    @Operation(summary="Get flink cluster")
    @PostMapping(value={"get"})
    public RestResponse get(Long id) throws InternalException {
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(id);
        return RestResponse.success(cluster);
    }

    @Operation(summary="Start flink cluster")
    @PostMapping(value={"start"})
    public RestResponse start(Long id) {
        this.flinkClusterService.start(id);
        return RestResponse.success();
    }

    @Operation(summary="Shutdown flink cluster")
    @PostMapping(value={"shutdown"})
    public RestResponse shutdown(Long id) {
        this.flinkClusterService.shutdown(id);
        return RestResponse.success();
    }

    @Operation(summary="Delete flink cluster")
    @PostMapping(value={"delete"})
    public RestResponse delete(Long id) {
        this.flinkClusterService.delete(id);
        return RestResponse.success();
    }
}

