/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;

public class CollectCoordinationResponse
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    private static final TypeSerializer<String> versionSerializer = StringSerializer.INSTANCE;
    private static final TypeSerializer<Long> offsetSerializer = LongSerializer.INSTANCE;
    private static final ListSerializer<byte[]> bufferSerializer = new ListSerializer((TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
    private final String version;
    private final long lastCheckpointedOffset;
    private final List<byte[]> serializedResults;

    public CollectCoordinationResponse(String version, long lastCheckpointedOffset, List<byte[]> serializedResults) {
        this.version = version;
        this.lastCheckpointedOffset = lastCheckpointedOffset;
        this.serializedResults = serializedResults;
    }

    public CollectCoordinationResponse(DataInputView inView) throws IOException {
        this.version = (String)versionSerializer.deserialize(inView);
        this.lastCheckpointedOffset = (Long)offsetSerializer.deserialize(inView);
        this.serializedResults = bufferSerializer.deserialize(inView);
    }

    public String getVersion() {
        return this.version;
    }

    public long getLastCheckpointedOffset() {
        return this.lastCheckpointedOffset;
    }

    public <T> List<T> getResults(TypeSerializer<T> elementSerializer) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (byte[] serializedResult : this.serializedResults) {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedResult);
            DataInputViewStreamWrapper wrapper = new DataInputViewStreamWrapper((InputStream)bais);
            results.add(elementSerializer.deserialize((DataInputView)wrapper));
        }
        return results;
    }

    public void serialize(DataOutputView outView) throws IOException {
        versionSerializer.serialize((Object)this.version, outView);
        offsetSerializer.serialize((Object)this.lastCheckpointedOffset, outView);
        bufferSerializer.serialize(this.serializedResults, outView);
    }
}

