/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.types.variant.VariantUtil;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4aAC\u0006!\u0002\u001bQ\u0002\"C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011)\u0011%I\u0003A!A!\u0002\u0013Qs\u0006C\u00051\u0001\t\u0005\t\u0015!\u00032u!)1\b\u0001C\u0001y!1\u0011\t\u0001Q\u0001\n\tCa\u0001\u0013\u0001!\u0002\u0013I\u0005\"B)\u0001\t\u0003\u0012\u0006b\u00032\u0001!\u0003\r\t\u0011!C\u0005G>B1b\u001a\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003iu\tIQ*\u00199SK\u0006$WM\u001d\u0006\u0003\u00195\tq\u0001]1scV,GO\u0003\u0002\u000f\u001f\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0001\u0012#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0007\t\u00039ui\u0011aC\u0005\u0003=-\u0011A\u0003U1scV,GOV1sS\u0006tGOU3bI\u0016\u0014\u0018AB:dQ\u0016l\u0017\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u00059a/\u0019:jC:$(BA\u0013\u0014\u0003\u0015!\u0018\u0010]3t\u0013\t9#EA\u0007WCJL\u0017M\u001c;TG\",W.Y\u0005\u0003?u\t!\u0002^1sO\u0016$H+\u001f9f!\tYS&D\u0001-\u0015\t)\u0013#\u0003\u0002/Y\t9Q*\u00199UsB,\u0017BA\u0015\u001e\u0003!\u0019\u0017m\u001d;Be\u001e\u001c\bC\u0001\u001a9\u001b\u0005\u0019$BA\u00125\u0015\t)d'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001c\u0012\u0003!\u0019\u0017\r^1msN$\u0018BA\u001d4\u0005=1\u0016M]5b]R\u001c\u0015m\u001d;Be\u001e\u001c\u0018B\u0001\u0019\u001e\u0003\u0019a\u0014N\\5u}Q!QHP A!\ta\u0002\u0001C\u0003 \t\u0001\u0007\u0001\u0005C\u0003*\t\u0001\u0007!\u0006C\u00031\t\u0001\u0007\u0011'\u0001\u0007wC2,XMU3bI\u0016\u00148\u000fE\u0002D\rni\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0013g\"\u0014X\r\u001a3fI\u001aKW\r\u001c3OC6,7\u000fE\u0002D\r*\u0003\"aS(\u000e\u00031S!!J'\u000b\u00059\u001b\u0012AB;og\u00064W-\u0003\u0002Q\u0019\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u001bI,\u0017\r\u001a$s_6$\u0016\u0010]3e)\r\u0019f\u000b\u0018\t\u0003\u0007RK!!\u0016#\u0003\u0007\u0005s\u0017\u0010C\u0003X\u000f\u0001\u0007\u0001,A\u0002s_^\u0004\"!\u0017.\u000e\u0003YJ!a\u0017\u001c\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006;\u001e\u0001\rAX\u0001\u0011i>\u0004H*\u001a<fY6+G/\u00193bi\u0006\u00042a\u0011$`!\t\u0019\u0005-\u0003\u0002b\t\n!!)\u001f;f\u0003A\u0019X\u000f]3sIQ\f'oZ3u)f\u0004X-F\u0001e!\tYS-\u0003\u0002gY\tAA)\u0019;b)f\u0004X-\u0001\btkB,'\u000fJ2bgR\f%oZ:\u0016\u0003E\u0002")
public final class MapReader
extends ParquetVariantReader {
    private final ParquetVariantReader[] valueReaders;
    private final UTF8String[] shreddedFieldNames;

    private /* synthetic */ DataType super$targetType() {
        return super.targetType();
    }

    private /* synthetic */ VariantCastArgs super$castArgs() {
        return super.castArgs();
    }

    @Override
    public Object readFromTyped(InternalRow row, byte[] topLevelMetadata) {
        Object[] valueArray;
        UTF8String[] keyArray;
        block7: {
            int i;
            if (super.schema().objectSchema == null) {
                return this.invalidCast(row, topLevelMetadata);
            }
            InternalRow obj = row.getStruct(super.schema().typedIdx, super.schema().objectSchema.length);
            int numShreddedFields = this.valueReaders.length;
            Variant unshreddedObject = null;
            if (super.schema().variantIdx >= 0 && !row.isNullAt(super.schema().variantIdx)) {
                unshreddedObject = new Variant(row.getBinary(super.schema().variantIdx), topLevelMetadata);
                VariantUtil.Type type = unshreddedObject.getType();
                VariantUtil.Type type2 = VariantUtil.Type.OBJECT;
                if (type == null ? type2 != null : !type.equals(type2)) {
                    throw QueryExecutionErrors$.MODULE$.malformedVariant();
                }
            }
            int numUnshreddedFields = unshreddedObject != null ? unshreddedObject.objectSize() : 0;
            keyArray = new UTF8String[numShreddedFields + numUnshreddedFields];
            valueArray = new Object[numShreddedFields + numUnshreddedFields];
            int mapLength = 0;
            for (i = 0; i < numShreddedFields; ++i) {
                if (obj.isNullAt(i)) {
                    throw QueryExecutionErrors$.MODULE$.malformedVariant();
                }
                VariantSchema fieldSchema = super.schema().objectSchema[i].schema;
                InternalRow fieldInput = obj.getStruct(i, fieldSchema.numFields);
                if ((fieldSchema.typedIdx < 0 || fieldInput.isNullAt(fieldSchema.typedIdx)) && (fieldSchema.variantIdx < 0 || fieldInput.isNullAt(fieldSchema.variantIdx))) continue;
                keyArray[mapLength] = this.shreddedFieldNames[i];
                valueArray[mapLength] = this.valueReaders[i].read(fieldInput, topLevelMetadata);
                ++mapLength;
            }
            for (i = 0; i < numUnshreddedFields; ++i) {
                Variant.ObjectField field = unshreddedObject.getFieldAtIndex(i);
                if (super.schema().objectSchemaMap.containsKey(field.key)) {
                    throw QueryExecutionErrors$.MODULE$.malformedVariant();
                }
                keyArray[mapLength] = UTF8String.fromString((String)field.key);
                valueArray[mapLength] = VariantGet$.MODULE$.cast(field.value, ((MapType)super.targetType()).valueType(), super.castArgs());
                ++mapLength;
            }
            if (mapLength >= keyArray.length) break block7;
            keyArray = (UTF8String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])keyArray), 0, mapLength);
            valueArray = (Object[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.genericArrayOps((Object)valueArray), 0, mapLength);
        }
        return ArrayBasedMapData$.MODULE$.apply((Object)keyArray, (Object)valueArray);
    }

    public MapReader(VariantSchema schema, MapType targetType, VariantCastArgs castArgs) {
        super(schema, (DataType)targetType, castArgs);
        this.valueReaders = super.schema().objectSchema != null ? (ParquetVariantReader[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])super.schema().objectSchema), (Function1 & Serializable)f -> ParquetVariantReader$.MODULE$.apply(f.schema, ((MapType)this.super$targetType()).valueType(), this.super$castArgs(), ParquetVariantReader$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(ParquetVariantReader.class)) : null;
        this.shreddedFieldNames = super.schema().objectSchema != null ? (UTF8String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])super.schema().objectSchema), (Function1 & Serializable)f -> UTF8String.fromString((String)f.fieldName), ClassTag$.MODULE$.apply(UTF8String.class)) : null;
    }
}

