/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.spark.launcher.CommandBuilderUtils;

abstract class AbstractCommandBuilder {
    boolean verbose;
    String appName;
    String appResource;
    String deployMode;
    String javaHome;
    String mainClass;
    String master;
    String remote;
    protected String propertiesFile;
    protected List<String> extraPropertiesFiles = new ArrayList<String>();
    protected boolean loadSparkDefaults;
    final List<String> appArgs;
    final List<String> jars;
    final List<String> files;
    final List<String> pyFiles;
    final Map<String, String> childEnv;
    final Map<String, String> conf;
    private Map<String, String> effectiveConfig;
    protected boolean isRemote = System.getenv().containsKey("SPARK_REMOTE");
    protected boolean isBeeLine = false;

    AbstractCommandBuilder() {
        this.appArgs = new ArrayList<String>();
        this.childEnv = new HashMap<String, String>();
        this.conf = new HashMap<String, String>();
        this.files = new ArrayList<String>();
        this.jars = new ArrayList<String>();
        this.pyFiles = new ArrayList<String>();
    }

    abstract List<String> buildCommand(Map<String, String> var1) throws IOException, IllegalArgumentException;

    List<String> buildJavaCommand(String extraClassPath) throws IOException {
        File javaOpts;
        ArrayList<String> cmd = new ArrayList<String>();
        String firstJavaHome = CommandBuilderUtils.firstNonEmpty(this.javaHome, this.childEnv.get("JAVA_HOME"), System.getenv("JAVA_HOME"), System.getProperty("java.home"));
        if (firstJavaHome != null) {
            cmd.add(CommandBuilderUtils.join(File.separator, firstJavaHome, "bin", "java"));
        }
        if ((javaOpts = new File(CommandBuilderUtils.join(File.separator, this.getConfDir(), "java-opts"))).isFile()) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(javaOpts), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.addOptionString(cmd, line);
                }
            }
        }
        cmd.add("-cp");
        cmd.add(CommandBuilderUtils.join(File.pathSeparator, this.buildClassPath(extraClassPath)));
        return cmd;
    }

    void addOptionString(List<String> cmd, String options) {
        if (!CommandBuilderUtils.isEmpty(options)) {
            cmd.addAll(CommandBuilderUtils.parseOptionString(options));
        }
    }

    List<String> buildClassPath(String appClassPath) throws IOException {
        String sparkHome = this.getSparkHome();
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        this.addToClassPath(cp, appClassPath);
        this.addToClassPath(cp, this.getConfDir());
        boolean prependClasses = !CommandBuilderUtils.isEmpty(this.getenv("SPARK_PREPEND_CLASSES"));
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        boolean isTestingSql = "1".equals(this.getenv("SPARK_SQL_TESTING"));
        String jarsDir = CommandBuilderUtils.findJarsDir(this.getSparkHome(), this.getScalaVersion(), !isTesting && !isTestingSql);
        if (prependClasses || isTesting) {
            String scala = this.getScalaVersion();
            List<String> projects = Arrays.asList("common/kvstore", "common/network-common", "common/network-shuffle", "common/network-yarn", "common/sketch", "common/tags", "common/unsafe", "sql/connect/common", "sql/connect/server", "core", "examples", "graphx", "launcher", "mllib", "repl", "resource-managers/yarn", "sql/catalyst", "sql/core", "sql/hive", "sql/hive-thriftserver", "streaming");
            if (prependClasses) {
                if (!isTesting) {
                    System.err.println("NOTE: SPARK_PREPEND_CLASSES is set, placing locally compiled Spark classes ahead of assembly.");
                }
                boolean shouldPrePendSparkHive = isTesting || isTestingSql || this.isJarAvailable(jarsDir, "spark-hive_");
                boolean shouldPrePendSparkHiveThriftServer = isTesting || isTestingSql || shouldPrePendSparkHive && this.isJarAvailable(jarsDir, "spark-hive-thriftserver_");
                for (String project : projects) {
                    if (project.equals("sql/connect/server") || project.equals("sql/connect/common") || this.isRemote && "1".equals(this.getenv("SPARK_SCALA_SHELL")) && project.equals("sql/core") || this.isBeeLine && "1".equals(this.getenv("SPARK_CONNECT_BEELINE")) && project.equals("sql/core") || !shouldPrePendSparkHive && project.equals("sql/hive") || !shouldPrePendSparkHiveThriftServer && project.equals("sql/hive-thriftserver")) continue;
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/classes", sparkHome, project, scala));
                }
            }
            if (isTesting) {
                for (String project : projects) {
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/test-classes", sparkHome, project, scala));
                }
            }
            this.addToClassPath(cp, String.format("%s/core/target/jars/*", sparkHome));
            this.addToClassPath(cp, String.format("%s/mllib/target/jars/*", sparkHome));
        }
        if (jarsDir != null) {
            for (File f : new File(jarsDir).listFiles()) {
                if (!f.getName().startsWith("slf4j-api-")) continue;
                this.addToClassPath(cp, f.toString());
            }
            if (this.isRemote || this.isBeeLine && "1".equals(this.getenv("SPARK_CONNECT_BEELINE"))) {
                for (File f : new File(jarsDir).listFiles()) {
                    if (f.isDirectory() && f.getName().equals("connect-repl")) {
                        this.addToClassPath(cp, CommandBuilderUtils.join(File.separator, f.toString(), "*"));
                        continue;
                    }
                    if (f.getName().startsWith("spark-sql_") || f.getName().startsWith("spark-connect_") || f.getName().startsWith("spark-sql-api_") || f.getName().startsWith("spark-connect-common_")) continue;
                    this.addToClassPath(cp, f.toString());
                }
            } else {
                this.addToClassPath(cp, CommandBuilderUtils.join(File.separator, jarsDir, "*"));
            }
        }
        this.addToClassPath(cp, this.getenv("HADOOP_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("YARN_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("SPARK_DIST_CLASSPATH"));
        return new ArrayList<String>(cp);
    }

    /*
     * WARNING - void declaration
     */
    private void addToClassPath(Set<String> cp, String entries) {
        String[] split;
        if (CommandBuilderUtils.isEmpty(entries)) {
            return;
        }
        for (String string : split = entries.split(Pattern.quote(File.pathSeparator))) {
            void var7_7;
            if (CommandBuilderUtils.isEmpty(string)) continue;
            if (new File(string).isDirectory() && !string.endsWith(File.separator)) {
                String string2 = string + File.separator;
            }
            cp.add((String)var7_7);
        }
    }

    private boolean isJarAvailable(String jarsDir, String jarNamePrefix) {
        if (jarsDir != null) {
            for (File f : new File(jarsDir).listFiles()) {
                if (!f.getName().startsWith(jarNamePrefix)) continue;
                return true;
            }
        }
        return false;
    }

    String getScalaVersion() {
        String scala = this.getenv("SPARK_SCALA_VERSION");
        if (scala != null) {
            return scala;
        }
        String sparkHome = this.getSparkHome();
        File scala213 = new File(sparkHome, "launcher/target/scala-2.13");
        CommandBuilderUtils.checkState(scala213.isDirectory(), "Cannot find any build directories.", new Object[0]);
        return "2.13";
    }

    String getSparkHome() {
        String path = this.getenv("SPARK_HOME");
        if (path == null && "1".equals(this.getenv("SPARK_TESTING"))) {
            path = System.getProperty("spark.test.home");
        }
        CommandBuilderUtils.checkState(path != null, "Spark home not found; set it explicitly or use the SPARK_HOME environment variable.", new Object[0]);
        return path;
    }

    String getenv(String key) {
        return CommandBuilderUtils.firstNonEmpty(this.childEnv.get(key), System.getenv(key));
    }

    void setPropertiesFile(String path) {
        this.effectiveConfig = null;
        this.propertiesFile = path;
    }

    Map<String, String> getEffectiveConfig() throws IOException {
        if (this.effectiveConfig == null) {
            this.effectiveConfig = new HashMap<String, String>(this.conf);
            Properties p = this.loadPropertiesFile();
            p.stringPropertyNames().forEach(key -> this.effectiveConfig.computeIfAbsent((String)key, p::getProperty));
            this.effectiveConfig.putIfAbsent("spark.driver.defaultExtraClassPath", "");
        }
        return this.effectiveConfig;
    }

    private Properties loadPropertiesFile() throws IOException {
        Properties props = new Properties();
        if (this.propertiesFile != null) {
            File propsFile = new File(this.propertiesFile);
            CommandBuilderUtils.checkArgument(propsFile.isFile(), "Invalid properties file '%s'.", this.propertiesFile);
            props = this.loadPropertiesFile(propsFile);
        }
        for (String extraFile : this.extraPropertiesFiles) {
            File extraPropsFile = new File(extraFile);
            CommandBuilderUtils.checkArgument(extraPropsFile.isFile(), "Invalid properties file '%s'.", extraFile);
            Properties extraProps = this.loadPropertiesFile(extraPropsFile);
            for (Map.Entry<Object, Object> entry : extraProps.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
        Properties defaultsProps = new Properties();
        if (this.propertiesFile == null || this.loadSparkDefaults) {
            defaultsProps = this.loadPropertiesFile(new File(this.getConfDir(), "spark-defaults.conf"));
        }
        for (Map.Entry<Object, Object> entry : defaultsProps.entrySet()) {
            if (props.containsKey(entry.getKey())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    private Properties loadPropertiesFile(File propsFile) throws IOException {
        Properties props = new Properties();
        if (propsFile != null && propsFile.isFile()) {
            try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8);){
                props.load(isr);
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    e.setValue(e.getValue().toString().trim());
                }
            }
        }
        return props;
    }

    private String getConfDir() {
        String confDir = this.getenv("SPARK_CONF_DIR");
        return confDir != null ? confDir : CommandBuilderUtils.join(File.separator, this.getSparkHome(), "conf");
    }
}

