/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.optimizer.NormalizeFloatingNumbers$;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n      > SELECT _FUNC_(map('a', 1, 'b', 2), map('b', 3, 'c', 4), (k, v1, v2) -> coalesce(v1, 0) + coalesce(v2, 0));\n       {\"a\":1,\"b\":5,\"c\":4}\n  ", since="3.0.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001\u0002 @\u00012C\u0001B\u001d\u0001\u0003\u0016\u0004%\ta\u001d\u0005\ti\u0002\u0011\t\u0012)A\u0005\u001b\"AQ\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003N\u0011!9\bA!f\u0001\n\u0003\u0019\b\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011B'\t\u000be\u0004A\u0011\u0001>\t\u000b}\u0004A\u0011A:\t\u0019\u0005\u0005\u0001\u0001%A\t\b\u0004&I!a\u0001\t\u0015\u0005u\u0001\u0001#b\u0001\n\u0003\ty\u0002\u0003\u0006\u0002*\u0001A)\u0019!C\u0001\u0003?A!\"!\f\u0001\u0011\u000b\u0007I\u0011AA\u0018\u00111\t\u0019\u0004\u0001I\u0001\u0012\u000f\u0007K\u0011BA\u0002\u0011)\t)\u0004\u0001EC\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003s\u0001\u0001R1A\u0005\u0002\u0005}\u0001BCA\u001f\u0001!\u0015\r\u0011\"\u0001\u00020!Q\u0011\u0011\t\u0001\t\u0006\u0004%\t!a\b\t\u0015\u0005\u0015\u0003\u0001#b\u0001\n\u0003\t9\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u0011Q\u000e\u0001\u0005B\u0005e\u0003bBA8\u0001\u0011\u0005\u00131\r\u0005\b\u0003c\u0002A\u0011IA\u0010\u0011\u001d\t\u0019\b\u0001C)\u0003kBq!a$\u0001\t\u0003\n\t\nC\u0004\u0002 \u0002!\t%!%\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"a\u0011\u0011\u0017\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u00024\"Q\u0011Q\u0018\u0001\t\u0006\u0004%\t!a0\t\u0015\u0005\r\u0007\u0001#b\u0001\n\u0003\ty\f\u0003\u0006\u0002H\u0002A)\u0019!C\u0001\u0003\u007fC!\"a3\u0001\u0011\u000b\u0007I\u0011BAg\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqA!\u0005\u0001\t\u0013\u0011\u0019\u0002\u0003\u0006\u0003$\u0001A)\u0019!C\u0005\u0005KAqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u00036\u0001!IAa\u000e\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!9!1\u000b\u0001\u0005B\tU\u0003B\u0002B4\u0001\u0011\u00053\u000f\u0003\u0004\u0003j\u0001!\te\u001d\u0005\u0007\u0005W\u0002A\u0011I:\t\u000f\t5\u0004\u0001\"\u0015\u0003p!I!Q\u0010\u0001\u0002\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u000f\u0003\u0011\u0013!C\u0001\u0005\u0013C\u0011Ba(\u0001#\u0003%\tA!#\t\u0013\t\u0005\u0006!%A\u0005\u0002\t%\u0005\"\u0003BR\u0001\u0005\u0005I\u0011\tBS\u0011%\u0011)\fAA\u0001\n\u0003\u00119\fC\u0005\u0003:\u0002\t\t\u0011\"\u0001\u0003<\"I!\u0011\u0019\u0001\u0002\u0002\u0013\u0005#1\u0019\u0005\n\u0005\u001b\u0004\u0011\u0011!C\u0001\u0005\u001fD\u0011Ba5\u0001\u0003\u0003%\tE!6\t\u0013\te\u0007!!A\u0005B\tmw!\u0003B\u0000\u007f\u0005\u0005\t\u0012AB\u0001\r!qt(!A\t\u0002\r\r\u0001BB=9\t\u0003\u0019Y\u0002C\u0005\u0004\u001ea\n\t\u0011\"\u0012\u0004 !I1\u0011\u0005\u001d\u0002\u0002\u0013\u000551\u0005\u0005\n\u0007WA\u0014\u0011!CA\u0007[A\u0011ba\u000e9\u0003\u0003%Ia!\u000f\u0003\u00155\u000b\u0007OW5q/&$\bN\u0003\u0002A\u0003\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00115)\u0001\u0005dCR\fG._:u\u0015\t!U)A\u0002tc2T!AR$\u0002\u000bM\u0004\u0018M]6\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0002\u0001'\u001d\u0001Q*\u0015+[A\u001a\u0004\"AT(\u000e\u0003}J!\u0001U \u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002O%&\u00111k\u0010\u0002\u0014\u0011&<\u0007.\u001a:Pe\u0012,'OR;oGRLwN\u001c\t\u0003+bk\u0011A\u0016\u0006\u0003/~\nqaY8eK\u001e,g.\u0003\u0002Z-\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000eE\u0002\\=6k\u0011\u0001\u0018\u0006\u0003;\u0006\u000bQ\u0001\u001e:fKNL!a\u0018/\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\b!J|G-^2u!\t9wN\u0004\u0002i[:\u0011\u0011\u000e\\\u0007\u0002U*\u00111nS\u0001\u0007yI|w\u000e\u001e \n\u0003\rL!A\u001c2\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003]\n\fA\u0001\\3giV\tQ*A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\tMVt7\r^5p]\u0006Ia-\u001e8di&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmdXP \t\u0003\u001d\u0002AQA]\u0004A\u00025CQ!^\u0004A\u00025CQa^\u0004A\u00025\u000bqBZ;oGRLwN\u001c$pe\u00163\u0018\r\\\u0001\u0005q\u0012\u0012t'\u0006\u0002\u0002\u0006AI\u0011-a\u0002\u0002\f\u0005-\u0011qC\u0005\u0004\u0003\u0013\u0011'A\u0002+va2,7\u0007\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbQ\u0001\u0006if\u0004Xm]\u0005\u0005\u0003+\tyA\u0001\u0005ECR\fG+\u001f9f!\r\t\u0017\u0011D\u0005\u0004\u00037\u0011'a\u0002\"p_2,\u0017M\\\u0001\fY\u00164GoS3z)f\u0004X-\u0006\u0002\u0002\f!\u001a!\"a\t\u0011\u0007\u0005\f)#C\u0002\u0002(\t\u0014\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001b1,g\r\u001e,bYV,G+\u001f9fQ\rY\u00111E\u0001\u0016Y\u00164GOV1mk\u0016\u001cuN\u001c;bS:\u001ch*\u001e7m+\t\t9\u0002K\u0002\r\u0003G\tA\u0001\u001f\u00133q\u0005a!/[4ii.+\u0017\u0010V=qK\"\u001aa\"a\t\u0002\u001dILw\r\u001b;WC2,X\rV=qK\"\u001aq\"a\t\u0002-ILw\r\u001b;WC2,XmQ8oi\u0006Lgn\u001d(vY2D3\u0001EA\u0012\u0003\u001dYW-\u001f+za\u0016D3!EA\u0012\u0003!y'\u000fZ3sS:<WCAA%!\u00159\u00171JA(\u0013\r\ti%\u001d\u0002\t\u001fJ$WM]5oOB\u0019\u0011-!\u0015\n\u0007\u0005M#MA\u0002B]fD3AEA\u0012\u0003%\t'oZ;nK:$8/\u0006\u0002\u0002\\A!q-!\u0018N\u0013\r\ty&\u001d\u0002\u0004'\u0016\f\u0018!D1sOVlWM\u001c;UsB,7/\u0006\u0002\u0002fA)q-!\u0018\u0002hA!\u0011QBA5\u0013\u0011\tY'a\u0004\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017!\u00034v]\u000e$\u0018n\u001c8t\u000351WO\\2uS>tG+\u001f9fg\u0006AA-\u0019;b)f\u0004X-\u0001\u0007cS:$\u0017J\u001c;fe:\fG\u000eF\u0002|\u0003oBq!!\u001f\u0019\u0001\u0004\tY(A\u0001g!!\t\u0017QP'\u0002\u0002\u0006%\u0015bAA@E\nIa)\u001e8di&|gN\r\t\u0006O\u0006u\u00131\u0011\t\bC\u0006\u0015\u00151BA\f\u0013\r\t9I\u0019\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00079\u000bY)C\u0002\u0002\u000e~\u0012a\u0002T1nE\u0012\fg)\u001e8di&|g.\u0001\fdQ\u0016\u001c7.\u0011:hk6,g\u000e\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI*Q\u0001\tC:\fG._:jg&!\u0011QTAL\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001c\u0018\u0001B3wC2$B!a\u0014\u0002&\"I\u0011qU\u000e\u0011\u0002\u0003\u0007\u0011\u0011V\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003W\u000bi+D\u0001B\u0013\r\ty+\u0011\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0003yIIJTCAA[!%\t\u0017qAA\\\u0003o\u000b9\fE\u0002O\u0003sK1!a/@\u0005Mq\u0015-\\3e\u0019\u0006l'\rZ1WCJL\u0017M\u00197f\u0003\u0019YW-\u001f,beV\u0011\u0011q\u0017\u0015\u0004;\u0005\r\u0012!\u0003<bYV,\u0017GV1sQ\rq\u00121E\u0001\nm\u0006dW/\u001a\u001aWCJD3aHA\u0012\u0003]9W\r^&fsN<\u0016\u000e\u001e5WC2,X-\u00138eKb,7/\u0006\u0002\u0002PBI\u0011-! \u0002R\u0006E\u0017Q\u001c\t\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q[!\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\f)NA\u0005BeJ\f\u0017\u0010R1uCB1\u0011q\\Au\u0003[l!!!9\u000b\t\u0005\r\u0018Q]\u0001\b[V$\u0018M\u00197f\u0015\r\t9OY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAv\u0003C\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\bC\u0006\u0015\u0015qJAx!\u0015\t\u0017\u0011_A{\u0013\r\t\u0019P\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006C\u0006]\u00181`\u0005\u0004\u0003s\u0014'AB(qi&|g\u000eE\u0002b\u0003{L1!a@c\u0005\rIe\u000e\u001e\u0015\u0004A\u0005\r\u0012aF1tg\u0016\u0014HoU5{K>3\u0017I\u001d:bs\n+hMZ3s)\u0011\u00119A!\u0004\u0011\u0007\u0005\u0014I!C\u0002\u0003\f\t\u0014A!\u00168ji\"9!qB\u0011A\u0002\u0005m\u0018\u0001B:ju\u0016\f\u0001eZ3u\u0017\u0016L8oV5uQ&sG-\u001a=fg\u001a\u000b7\u000f^+tS:<7kY1mCR1!Q\u0003B\u000e\u0005?\u0001\u0002\"a8\u0003\u0018\u0005=\u0013q^\u0005\u0005\u00053\t\tOA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\u0005\b\u0005;\u0011\u0003\u0019AAi\u0003\u0015YW-_:2\u0011\u001d\u0011\tC\ta\u0001\u0003#\fQa[3zgJ\n!B\\8s[\u0006d\u0017N_3s+\t\u00119\u0003E\u0004b\u0005S\ty%a\u0014\n\u0007\t-\"MA\u0005Gk:\u001cG/[8oc\u0005ar-\u001a;LKf\u001cx+\u001b;i\u0013:$W\r_3t\r\u0006\u001cH/Q:KCZ\fGC\u0002B\u000b\u0005c\u0011\u0019\u0004C\u0004\u0003\u001e\u0011\u0002\r!!5\t\u000f\t\u0005B\u00051\u0001\u0002R\u0006ar-\u001a;LKf\u001cx+\u001b;i\u0013:$W\r_3t\u0005J,H/\u001a$pe\u000e,GC\u0002B\u001d\u0005\u007f\u0011\t\u0005\u0005\u0004\u0002`\nm\u0012Q^\u0005\u0005\u0005{\t\tOA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bb\u0002B\u000fK\u0001\u0007\u0011\u0011\u001b\u0005\b\u0005C)\u0003\u0019AAi\u00031qW\u000f\u001c7TC\u001a,WI^1m)!\tyEa\u0012\u0003L\t=\u0003b\u0002B%M\u0001\u0007\u0011\u0011V\u0001\tS:\u0004X\u000f\u001e*po\"9!Q\n\u0014A\u0002\u0005=\u0013A\u0002<bYV,\u0017\u0007C\u0004\u0003R\u0019\u0002\r!a\u0014\u0002\rY\fG.^33\u0003!qw\u000eZ3OC6,WC\u0001B,!\u0011\u0011IF!\u0019\u000f\t\tm#Q\f\t\u0003S\nL1Aa\u0018c\u0003\u0019\u0001&/\u001a3fM&!!1\rB3\u0005\u0019\u0019FO]5oO*\u0019!q\f2\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004|\u0005c\u0012)H!\u001f\t\r\tM4\u00061\u0001N\u0003!qWm\u001e$jeN$\bB\u0002B<W\u0001\u0007Q*A\u0005oK^\u001cVmY8oI\"1!1P\u0016A\u00025\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004|\u0005\u0003\u0013\u0019I!\"\t\u000fId\u0003\u0013!a\u0001\u001b\"9Q\u000f\fI\u0001\u0002\u0004i\u0005bB<-!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YIK\u0002N\u0005\u001b[#Aa$\u0011\t\tE%1T\u0007\u0003\u0005'SAA!&\u0003\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053\u0013\u0017AC1o]>$\u0018\r^5p]&!!Q\u0014BJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BT!\u0011\u0011IKa-\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000bA\u0001\\1oO*\u0011!\u0011W\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003d\t-\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAA~\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0014\u0003>\"I!q\u0018\u001a\u0002\u0002\u0003\u0007\u00111`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0007C\u0002Bd\u0005\u0013\fy%\u0004\u0002\u0002f&!!1ZAs\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]!\u0011\u001b\u0005\n\u0005\u007f#\u0014\u0011!a\u0001\u0003\u001f\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\u0015Bl\u0011%\u0011y,NA\u0001\u0002\u0004\tY0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003/\u0011i\u000eC\u0005\u0003@Z\n\t\u00111\u0001\u0002P!\u001a\u0002A!9\u0003h\n%(Q\u001eBx\u0005g\u0014)P!?\u0003|B\u0019aJa9\n\u0007\t\u0015xHA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t-\u0018Aa;\u000bA\u0001\u0002\u0003\u0005\t\u0011`\rVs5i\u0018\u0015nCB\fD\u0006I7baJb\u0003EZ;oGRLwN\\\u0015![\u0001jUM]4fg\u0002\"xo\u001c\u0011hSZ,g\u000eI7baN\u0004\u0013N\u001c;pA\u0005\u00043/\u001b8hY\u0016\u0004S.\u00199!Ef\u0004\u0013\r\u001d9ms&twM\u0003\u0011!A\u0001\u0002\u0003EZ;oGRLwN\u001c\u0011u_\u0002\"\b.\u001a\u0011qC&\u0014\be\u001c4!m\u0006dW/Z:!o&$\b\u000e\t;iK\u0002\u001a\u0018-\\3!W\u0016Lh\u0006\t$pe\u0002ZW-_:!_:d\u0017\u0010\t9sKN,g\u000e^3eA%t\u0007e\u001c8fA5\f\u0007\u000f\f\u0006!A\u0001\u0002\u0003\u0005\t(V\u00192\u0003s/\u001b7mA\t,\u0007\u0005]1tg\u0016$\u0007%Y:!i\",\u0007E^1mk\u0016\u0004cm\u001c:!i\",\u0007%\\5tg&tw\rI6fs:\u0002\u0013J\u001a\u0011b]\u0002Jg\u000e];uA5\f\u0007\u000fI2p]R\f\u0017N\\:!IV\u0004H.[2bi\u0016$'\u0002\t\u0011!A\u0001\u00023.Z=tY\u0001zg\u000e\\=!i\",\u0007EZ5sgR\u0004SM\u001c;ss\u0002zg\r\t;iK\u0002\"W\u000f\u001d7jG\u0006$X\r\u001a\u0011lKf\u0004\u0013n\u001d\u0011qCN\u001cX\r\u001a\u0011j]R|\u0007\u0005\u001e5fA1\fWN\u00193bA\u0019,hn\u0019;j_:t#\u0002\t\u0011!A\u0005AQ\r_1na2,7/\t\u0002\u0003r\u0006\u0011iC\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBD\u0013\u0007\f\u0011(C\u001eb\u0003E\r\u0017!O\t<\u0013\u0006\f\u0011nCBD\u0013\u0007\f\u0011(q\u001eb\u0003E\r\u0017!Oe<\u0013\u0006\f\u0011)W2\u0002c/\r\u0017!mJJ\u0003%\f !G>t7-\u0019;)mFb\u0003E\u001e\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u000230\r\u001e#Cb\u0014CF\r\u001e#Ef\u0014SP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014\u0006\f\u0011nCBDsEY\u0014-AMb\u0003eJ2(Y\u0001\"\u0014\u0006\f\u0011)W2\u0002c/\r\u0017!mJJ\u0003%\f !G>\fG.Z:dK\"2\u0018\u0007\f\u00111S\u0001Z\u0003eY8bY\u0016\u001c8-\u001a\u0015we1\u0002\u0003'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'EO\u001b-E\r\u0014#\bN?\u000bA\u0001\nQa]5oG\u0016\f#Aa>\u0002\u000bMr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tu\u0018\u0001\u00047b[\n$\u0017m\u00184v]\u000e\u001c\u0018AC'bajK\u0007oV5uQB\u0011a\nO\n\u0006q\r\u00151\u0011\u0003\t\t\u0007\u000f\u0019i!T'Nw6\u00111\u0011\u0002\u0006\u0004\u0007\u0017\u0011\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007\u001f\u0019IAA\tBEN$(/Y2u\rVt7\r^5p]N\u0002Baa\u0005\u0004\u001a5\u00111Q\u0003\u0006\u0005\u0007/\u0011y+\u0001\u0002j_&\u0019\u0001o!\u0006\u0015\u0005\r\u0005\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u001d\u0016!B1qa2LHcB>\u0004&\r\u001d2\u0011\u0006\u0005\u0006en\u0002\r!\u0014\u0005\u0006kn\u0002\r!\u0014\u0005\u0006on\u0002\r!T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yca\r\u0011\u000b\u0005\f9p!\r\u0011\r\u0005\f9!T'N\u0011!\u0019)\u0004PA\u0001\u0002\u0004Y\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u001111\b\t\u0005\u0005S\u001bi$\u0003\u0003\u0004@\t-&AB(cU\u0016\u001cG\u000f")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
Serializable {
    private Tuple3<DataType, DataType, Object> x$27;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$28;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private Function1<Object, Object> normalizer;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith x$0) {
        return MapZipWith$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((this.bitmap$trans$0 & 0x1000) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x2000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x2000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((this.bitmap$trans$0 & 0x2000) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$27$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                this.x$27 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$27;
    }

    private /* synthetic */ Tuple3 x$27() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$27$lzycompute();
        }
        return this.x$27;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$27()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.leftKeyType$lzycompute();
        }
        return this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$27()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.leftValueType$lzycompute();
        }
        return this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$27()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.leftValueContainsNull$lzycompute();
        }
        return this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$28$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                this.x$28 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$28;
    }

    private /* synthetic */ Tuple3 x$28() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.x$28$lzycompute();
        }
        return this.x$28;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$28()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.rightKeyType$lzycompute();
        }
        return this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$28()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.rightValueType$lzycompute();
        }
        return this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$28()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.rightValueContainsNull$lzycompute();
        }
        return this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.keyType$lzycompute();
        }
        return this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        .colon.colon arguments = new .colon.colon((Object)new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            if (DataTypeUtils$.MODULE$.sameType(this.leftKeyType(), this.rightKeyType())) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), this.prettyName());
            }
            return new TypeCheckResult.DataTypeMismatch("MAP_ZIP_WITH_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.leftKeyType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.rightKeyType()))}))));
        }
        return typeCheckResult;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value1 = this.left().eval(input);
        if (value1 == null) {
            return null;
        }
        Object value2 = this.right().eval(input);
        if (value2 == null) {
            return null;
        }
        return this.nullSafeEval(input, value1, value2);
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        NamedExpression value1Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        value2Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                this.x$29 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$29;
    }

    private /* synthetic */ Tuple3 x$29() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$29$lzycompute();
        }
        return this.x$29;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$29()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.keyVar$lzycompute();
        }
        return this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$29()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        if ((this.bitmap$trans$0 & 0x200) == 0) {
            return this.value1Var$lzycompute();
        }
        return this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$29()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        if ((this.bitmap$trans$0 & 0x400) == 0) {
            return this.value2Var$lzycompute();
        }
        return this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) && SQLConf$.MODULE$.get().mapZipWithUsesJavaCollections() ? (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesFastAsJava((ArrayData)keys1, (ArrayData)keys2) : (TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesFastUsingScala((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2));
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        if ((this.bitmap$trans$0 & 0x800) == 0) {
            return this.getKeysWithValueIndexes$lzycompute();
        }
        return this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.mapSizeExceedArraySizeWhenZipMapError(size);
        }
    }

    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFastUsingScala(ArrayData keys1, ArrayData keys2) {
        LinkedHashMap hashMap = new LinkedHashMap();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFastUsingScala$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$30 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFastUsingScala$2(this, hashMap, x$30);
            return BoxedUnit.UNIT;
        });
        return hashMap;
    }

    private Function1<Object, Object> normalizer$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                DataType dataType = this.keyType();
                this.normalizer = FloatType$.MODULE$.equals(dataType) ? NormalizeFloatingNumbers$.MODULE$.FLOAT_NORMALIZER() : (DoubleType$.MODULE$.equals(dataType) ? NormalizeFloatingNumbers$.MODULE$.DOUBLE_NORMALIZER() : x -> Predef$.MODULE$.identity(x));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.normalizer;
    }

    private Function1<Object, Object> normalizer() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.normalizer$lzycompute();
        }
        return this.normalizer;
    }

    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFastAsJava(ArrayData keys1, ArrayData keys2) {
        java.util.LinkedHashMap hashMap = new java.util.LinkedHashMap();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFastAsJava$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$31 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFastAsJava$2(this, hashMap, x$31);
            return BoxedUnit.UNIT;
        });
        return (LinkedHashMap)LinkedHashMap$.MODULE$.apply(CollectionConverters$.MODULE$.MapHasAsScala(hashMap).asScala().toSeq());
    }

    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$3))).foreach((Function1 & Serializable)x$33 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$33);
            return BoxedUnit.UNIT;
        });
        return arrayBuffer;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$4))).foreach((Function1 & Serializable)x$36 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$36);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String nodeName() {
        return "map_zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public MapZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.function();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "function";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFastUsingScala$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFastUsingScala$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$30) {
        Tuple2 tuple2 = x$30;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFastAsJava$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFastAsJava$2(MapZipWith $this, java.util.LinkedHashMap hashMap$2, Tuple2 x$31) {
        Tuple2 tuple2 = x$31;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                Object key = $this.normalizer().apply(array.get(i, $this.keyType()));
                Option option = Option$.MODULE$.apply(hashMap$2.get(key));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    hashMap$2.put(key, indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$33) {
        Tuple2 tuple2 = x$33;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Object bufferKey2 = tuple23._1();
                    Option[] indexes2 = (Option[])tuple23._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$4) {
        Object object;
        Option[] optionArray;
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null && (optionArray = (Option[])tuple2._2()) != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$36) {
        Tuple2 tuple2 = x$36;
        if (tuple2 != null) {
            Object object;
            Object key = tuple2._1();
            Option[] optionArray = (Option[])tuple2._2();
            if (optionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                Option index1 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                Option index2 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                Object v1 = index1.map((Function1 & Serializable)x$34 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$34), $this.leftValueType())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Object v2 = index2.map((Function1 & Serializable)x$35 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$35), $this.rightValueType())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                $this.keyVar().value().set(key);
                $this.value1Var().value().set(v1);
                $this.value2Var().value().set(v2);
                keys$1.update(i$1.elem, key);
                Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
                values$1.update(i$1.elem, v);
                ++i$1.elem;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
        Statics.releaseFence();
    }
}

