/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.pipelines.common.DatasetType;
import org.apache.spark.sql.pipelines.graph.GraphElementTypeUtils$;
import org.apache.spark.sql.pipelines.graph.GraphErrors$;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.util.SchemaMergingUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SchemaInferenceUtils$ {
    public static final SchemaInferenceUtils$ MODULE$ = new SchemaInferenceUtils$();

    public StructType inferSchemaFromFlows(Seq<ResolvedFlow> flows, Option<StructType> userSpecifiedSchema) {
        if (flows.isEmpty()) {
            return (StructType)userSpecifiedSchema.getOrElse((Function0 & Serializable)() -> new StructType());
        }
        Predef$.MODULE$.require(flows.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtils$.$anonfun$inferSchemaFromFlows$2(flows, x$1))), (Function0 & Serializable)() -> "Expected all flows to have the same destination");
        StructType inferredSchema = (StructType)((IterableOnceOps)flows.map((Function1 & Serializable)x$2 -> x$2.schema())).fold((Object)new StructType(), (Function2 & Serializable)(schemaSoFar, schema) -> {
            StructType structType;
            try {
                structType = SchemaMergingUtils$.MODULE$.mergeSchemas((StructType)schemaSoFar, (StructType)schema);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw GraphErrors$.MODULE$.unableToInferSchemaError(((ResolutionCompletedFlow)flows.head()).destinationIdentifier(), (StructType)schemaSoFar, (StructType)schema, (Option<Throwable>)Option$.MODULE$.apply((Object)throwable2));
                }
                throw throwable;
            }
            return structType;
        });
        TableIdentifier identifier = ((ResolutionCompletedFlow)flows.head()).destinationIdentifier();
        DatasetType datasetType = GraphElementTypeUtils$.MODULE$.getDatasetTypeForMaterializedViewOrStreamingTable(flows);
        return this.mergeInferredAndUserSchemasIfNeeded(identifier, datasetType, inferredSchema, userSpecifiedSchema);
    }

    private StructType mergeInferredAndUserSchemasIfNeeded(TableIdentifier tableIdentifier, DatasetType datasetType, StructType inferredSchema, Option<StructType> userSpecifiedSchema) {
        Option<StructType> option = userSpecifiedSchema;
        if (option instanceof Some) {
            StructType structType;
            Some some = (Some)option;
            StructType userSpecifiedSchema2 = (StructType)some.value();
            try {
                structType = SchemaMergingUtils$.MODULE$.mergeSchemas(userSpecifiedSchema2, inferredSchema);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw GraphErrors$.MODULE$.incompatibleUserSpecifiedAndInferredSchemasError(tableIdentifier, datasetType, userSpecifiedSchema2, inferredSchema, (Option<Throwable>)Option$.MODULE$.apply((Object)throwable2));
                }
                throw throwable;
            }
            return structType;
        }
        if (None$.MODULE$.equals(option)) {
            return inferredSchema;
        }
        throw new MatchError(option);
    }

    public Seq<TableChange> diffSchemas(StructType currentSchema, StructType targetSchema) {
        ArrayBuffer changes = ArrayBuffer$.MODULE$.empty();
        Map currentFields = SchemaInferenceUtils$.getFieldMap$1(currentSchema);
        Map targetFields = SchemaInferenceUtils$.getFieldMap$1(targetSchema);
        scala.collection.immutable.Set columnsToAdd = (scala.collection.immutable.Set)targetFields.keySet().diff((Set)currentFields.keySet());
        columnsToAdd.foreach((Function1 & Serializable)columnName -> {
            StructField field = (StructField)targetFields.apply(columnName);
            return (ArrayBuffer)changes.$plus$eq((Object)TableChange.addColumn((String[])((String[])((Object[])new String[]{columnName})), (DataType)field.dataType(), (boolean)field.nullable(), (String)((String)field.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        });
        scala.collection.immutable.Set columnsToDelete = (scala.collection.immutable.Set)currentFields.keySet().diff((Set)targetFields.keySet());
        columnsToDelete.foreach((Function1 & Serializable)columnName -> (ArrayBuffer)changes.$plus$eq((Object)TableChange.deleteColumn((String[])((String[])((Object[])new String[]{columnName})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))));
        scala.collection.immutable.Set commonColumns = (scala.collection.immutable.Set)currentFields.keySet().intersect((Set)targetFields.keySet());
        commonColumns.foreach((Function1 & Serializable)columnName -> {
            StructField currentField = (StructField)currentFields.apply(columnName);
            StructField targetField = (StructField)targetFields.apply(columnName);
            DataType dataType = currentField.dataType();
            DataType dataType2 = targetField.dataType();
            Object object = (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) ? changes.$plus$eq((Object)TableChange.updateColumnType((String[])((String[])((Object[])new String[]{columnName})), (DataType)targetField.dataType())) : BoxedUnit.UNIT;
            Object object2 = currentField.nullable() != targetField.nullable() ? changes.$plus$eq((Object)TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{columnName})), (boolean)targetField.nullable())) : BoxedUnit.UNIT;
            String currentComment = (String)currentField.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String targetComment = (String)targetField.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String string = currentComment;
            String string2 = targetComment;
            if (string == null ? string2 != null : !string.equals(string2)) {
                return changes.$plus$eq((Object)TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{columnName})), (String)targetComment));
            }
            return BoxedUnit.UNIT;
        });
        return changes.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$inferSchemaFromFlows$2(Seq flows$1, ResolvedFlow x$1) {
        TableIdentifier tableIdentifier = x$1.destinationIdentifier();
        TableIdentifier tableIdentifier2 = ((ResolutionCompletedFlow)flows$1.head()).destinationIdentifier();
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    private static final Map getFieldMap$1(StructType schema) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private SchemaInferenceUtils$() {
    }
}

