/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.compression;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.util.BufferUtil;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.IteratingCallback;
import org.sparkproject.jetty.util.IteratingNestedCallback;

public abstract class EncoderSink
implements Content.Sink {
    private final Content.Sink sink;

    protected EncoderSink(Content.Sink sink) {
        this.sink = sink;
    }

    @Override
    public void write(boolean last, ByteBuffer content, Callback callback) {
        if (content != null || last) {
            new EncodeBufferCallback(last, content, last ? Callback.from(callback, this::release) : callback).iterate();
        } else {
            callback.succeeded();
        }
    }

    protected abstract WriteRecord encode(boolean var1, ByteBuffer var2);

    protected void release() {
    }

    private class EncodeBufferCallback
    extends IteratingNestedCallback {
        private static final Logger LOG = LoggerFactory.getLogger(EncodeBufferCallback.class);
        private final AtomicReference<State> state;
        private final ByteBuffer content;
        private final boolean last;

        public EncodeBufferCallback(boolean last, ByteBuffer content, Callback callback) {
            super(callback);
            this.state = new AtomicReference<State>(State.INITIAL);
            this.content = content == null ? BufferUtil.EMPTY_BUFFER : content;
            this.last = last;
        }

        @Override
        protected IteratingCallback.Action process() {
            boolean hasRemaining;
            if (this.state.get() == State.FINISHED) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            WriteRecord writeRecord = EncoderSink.this.encode(this.last, this.content);
            if (writeRecord != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("process() - write() {}", (Object)writeRecord);
                }
                this.state.compareAndSet(State.INITIAL, State.COMPRESSING);
                this.write(writeRecord);
                return IteratingCallback.Action.SCHEDULED;
            }
            boolean bl = hasRemaining = this.content != null && this.content.hasRemaining();
            if (LOG.isDebugEnabled()) {
                LOG.debug("process() - hasRemaining={}", (Object)hasRemaining);
            }
            return hasRemaining ? IteratingCallback.Action.SCHEDULED : IteratingCallback.Action.SUCCEEDED;
        }

        private void write(WriteRecord writeRecord) {
            Callback callback = this;
            if (writeRecord.last) {
                this.state.set(State.FINISHING);
                callback = Callback.from(this::finished, callback);
            }
            if (writeRecord.callback != null) {
                callback = Callback.combine(callback, writeRecord.callback);
            }
            EncoderSink.this.sink.write(writeRecord.last, writeRecord.output, callback);
        }

        protected void finished() {
            this.state.set(State.FINISHED);
        }

        @Override
        public String toString() {
            return String.format("%s[content=%s,last=%b]", super.toString(), BufferUtil.toDetailString(this.content), this.last);
        }

        private static enum State {
            INITIAL,
            COMPRESSING,
            FINISHING,
            FINISHED;

        }
    }

    public record WriteRecord(boolean last, ByteBuffer output, Callback callback) {
    }
}

