/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.RpcTimeout$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BuildFrom;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tug!\u0002\u001a4\u0001UZ\u0004\u0002\u0003%\u0001\u0005\u0003\u0007I\u0011\u0001&\t\u0011E\u0003!\u00111A\u0005\u0002IC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Ka\u0013\u0005\t3\u0002\u0011\t\u0019!C\u0001\u0015\"A!\f\u0001BA\u0002\u0013\u00051\f\u0003\u0005^\u0001\t\u0005\t\u0015)\u0003L\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u000b\u001d\u0004A\u0011\u00015\t\u000f=\u0004!\u0019!C\u0001a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004w\u0001\u0001\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u0011Q\u001c\u0001\u0005\u0002\u0005m\bb\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u00036\u0001!\tAa\u000e\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B)\u0001\u0011\u0005!1\u000b\u0005\b\u00057\u0002A\u0011\u0001B/\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005WBqA!\u001f\u0001\t\u0003\u0011Y\bC\u0004\u0003\u0006\u0002!\tAa\"\t\u0013\t]\u0005!%A\u0005\u0002\u0005\u0015\u0005b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005W\u0003A\u0011\u0001BW\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005c;\u0001B!04\u0011\u0003)$q\u0018\u0004\beMB\t!\u000eBa\u0011\u00199G\u0006\"\u0001\u0003D\"I!Q\u0019\u0017C\u0002\u0013\u0005!q\u0019\u0005\t\u0005/d\u0003\u0015!\u0003\u0003J\"I!\u0011\u001c\u0017C\u0002\u0013\u0005!q\u0019\u0005\t\u00057d\u0003\u0015!\u0003\u0003J\n\u0011\"\t\\8dW6\u000bg.Y4fe6\u000b7\u000f^3s\u0015\t!T'A\u0004ti>\u0014\u0018mZ3\u000b\u0005Y:\u0014!B:qCJ\\'B\u0001\u001d:\u0003\u0019\t\u0007/Y2iK*\t!(A\u0002pe\u001e\u001c2\u0001\u0001\u001fC!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fMB\u00111IR\u0007\u0002\t*\u0011Q)N\u0001\tS:$XM\u001d8bY&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h\u00039!'/\u001b<fe\u0016sG\r]8j]R\u001c\u0001!F\u0001L!\tau*D\u0001N\u0015\tqU'A\u0002sa\u000eL!\u0001U'\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006\u0011BM]5wKJ,e\u000e\u001a9pS:$x\fJ3r)\t\u0019f\u000b\u0005\u0002>)&\u0011QK\u0010\u0002\u0005+:LG\u000fC\u0004X\u0005\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'A\bee&4XM]#oIB|\u0017N\u001c;!\u0003]!'/\u001b<fe\"+\u0017M\u001d;cK\u0006$XI\u001c3Q_&tG/A\u000eee&4XM\u001d%fCJ$(-Z1u\u000b:$\u0007k\\5oi~#S-\u001d\u000b\u0003'rCqaV\u0003\u0002\u0002\u0003\u00071*\u0001\ree&4XM\u001d%fCJ$(-Z1u\u000b:$\u0007k\\5oi\u0002\nAaY8oMB\u0011\u0001-Y\u0007\u0002k%\u0011!-\u000e\u0002\n'B\f'o[\"p]\u001a\f\u0001\"[:Ee&4XM\u001d\t\u0003{\u0015L!A\u001a \u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R![6m[:\u0004\"A\u001b\u0001\u000e\u0003MBQ\u0001S\u0005A\u0002-CQ!W\u0005A\u0002-CQAX\u0005A\u0002}CQaY\u0005A\u0002\u0011\fq\u0001^5nK>,H/F\u0001r!\ta%/\u0003\u0002t\u001b\nQ!\u000b]2US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\nqc^1ji\ncwnY6SK6|g/\u00197US6,w.\u001e;\u00021]\f\u0017\u000e\u001e\"m_\u000e\\'+Z7pm\u0006dG+[7f_V$\b%\u0001\bsK6|g/Z#yK\u000e,Ho\u001c:\u0015\u0005MK\b\"\u0002>\u000f\u0001\u0004Y\u0018AB3yK\u000eLE\rE\u0002}\u0003\u000fq1!`A\u0002!\tqh(D\u0001\u0000\u0015\r\t\t!S\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015a(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bq\u0014!\u00073fG>lW.[:tS>t'\t\\8dW6\u000bg.Y4feN$2aUA\t\u0011\u001d\t\u0019b\u0004a\u0001\u0003+\t1\"\u001a=fGV$xN]%egB)\u0011qCA\u0011w:!\u0011\u0011DA\u000f\u001d\rq\u00181D\u0005\u0002\u007f%\u0019\u0011q\u0004 \u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005\r\u0019V-\u001d\u0006\u0004\u0003?q\u0014\u0001H4fiJ+\u0007\u000f\\5dCR,\u0017J\u001c4p\r>\u0014(\u000b\u0012#CY>\u001c7n\u001d\u000b\u0005\u0003W\tY\u0005\u0005\u0004\u0002\u0018\u0005\u0005\u0012Q\u0006\t\u0005\u0003_\t)E\u0004\u0003\u00022\u0005\u0005c\u0002BA\u001a\u0003\u007fqA!!\u000e\u0002>9!\u0011qGA\u001e\u001d\rq\u0018\u0011H\u0005\u0002u%\u0011\u0001(O\u0005\u0003m]J!\u0001N\u001b\n\u0007\u0005\r3'\u0001\u000bCY>\u001c7.T1oC\u001e,'/T3tg\u0006<Wm]\u0005\u0005\u0003\u000f\nIE\u0001\bSKBd\u0017nY1uK\ncwnY6\u000b\u0007\u0005\r3\u0007C\u0004\u0002NA\u0001\r!a\u0014\u0002\u001d\tdwnY6NC:\fw-\u001a:JIB\u0019!.!\u0015\n\u0007\u0005M3G\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u0002'I,Wn\u001c<f\u000bb,7-\u001e;pe\u0006\u001b\u0018P\\2\u0015\u0007M\u000bI\u0006C\u0003{#\u0001\u000710\u0001\u000bsK\u001eL7\u000f^3s\u00052|7m['b]\u0006<WM\u001d\u000b\u000f\u0003\u001f\ny&a\u0019\u0002n\u0005]\u00141PA@\u0011\u001d\t\tG\u0005a\u0001\u0003\u001f\n!!\u001b3\t\u000f\u0005\u0015$\u00031\u0001\u0002h\u0005IAn\\2bY\u0012K'o\u001d\t\u0005{\u0005%40C\u0002\u0002ly\u0012Q!\u0011:sCfDq!a\u001c\u0013\u0001\u0004\t\t(\u0001\tnCb|e\u000eS3ba6+WnU5{KB\u0019Q(a\u001d\n\u0007\u0005UdH\u0001\u0003M_:<\u0007bBA=%\u0001\u0007\u0011\u0011O\u0001\u0012[\u0006DxJ\u001a4IK\u0006\u0004X*Z7TSj,\u0007BBA?%\u0001\u00071*A\bti>\u0014\u0018mZ3F]\u0012\u0004x.\u001b8u\u0011!\t\tI\u0005I\u0001\u0002\u0004!\u0017\u0001D5t%\u0016\u0014VmZ5ti\u0016\u0014\u0018A\b:fO&\u001cH/\u001a:CY>\u001c7.T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t9IK\u0002e\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+s\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010kB$\u0017\r^3CY>\u001c7.\u00138g_RYA-a(\u0002\"\u0006-\u0016QWA]\u0011\u001d\ti\u0005\u0006a\u0001\u0003\u001fBq!a)\u0015\u0001\u0004\t)+A\u0004cY>\u001c7.\u00133\u0011\u0007)\f9+C\u0002\u0002*N\u0012qA\u00117pG.LE\rC\u0004\u0002.R\u0001\r!a,\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0007)\f\t,C\u0002\u00024N\u0012Ab\u0015;pe\u0006<W\rT3wK2Dq!a.\u0015\u0001\u0004\t\t(A\u0004nK6\u001c\u0016N_3\t\u000f\u0005mF\u00031\u0001\u0002r\u0005AA-[:l'&TX-\u0001\fva\u0012\fG/\u001a*E\t\ncwnY6UCN\\\u0017J\u001c4p)\u0015\u0019\u0016\u0011YAe\u0011\u001d\t\u0019+\u0006a\u0001\u0003\u0007\u00042A[Ac\u0013\r\t9m\r\u0002\u000b%\u0012#%\t\\8dW&#\u0007bBAf+\u0001\u0007\u0011\u0011O\u0001\u0007i\u0006\u001c8.\u00133\u00021U\u0004H-\u0019;f%\u0012#%\t\\8dWZK7/\u001b2jY&$\u0018\u0010F\u0003T\u0003#\f\u0019\u000eC\u0004\u0002LZ\u0001\r!!\u001d\t\r\u0005Ug\u00031\u0001e\u0003\u001d1\u0018n]5cY\u0016\f\u0011#[:S\t\u0012\u0013En\\2l-&\u001c\u0018N\u00197f)\r!\u00171\u001c\u0005\b\u0003G;\u0002\u0019AAb\u000319W\r\u001e'pG\u0006$\u0018n\u001c8t)\u0011\t\t/a9\u0011\r\u0005]\u0011\u0011EA(\u0011\u001d\t\u0019\u000b\u0007a\u0001\u0003K\u000bQcZ3u\u0019>\u001c\u0017\r^5p]N\fe\u000eZ*uCR,8\u000f\u0006\u0004\u0002j\u0006U\u0018q\u001f\t\u0006{\u0005-\u0018q^\u0005\u0004\u0003[t$AB(qi&|g\u000e\u0005\u0003\u00020\u0005E\u0018\u0002BAz\u0003\u0013\u0012qC\u00117pG.dunY1uS>t7/\u00118e'R\fG/^:\t\u000f\u0005\r\u0016\u00041\u0001\u0002&\"1\u0011\u0011`\rA\u0002m\fQB]3rk\u0016\u001cH/\u001a:I_N$H\u0003BA\u007f\u0005\u0007\u0001b!a\u0006\u0002\u0000\u0006\u0005\u0018\u0002\u0002B\u0001\u0003K\u0011!\"\u00138eKb,GmU3r\u0011\u001d\u0011)A\u0007a\u0001\u0005\u000f\t\u0001B\u00197pG.LEm\u001d\t\u0006{\u0005%\u0014QU\u0001\tG>tG/Y5ogR\u0019AM!\u0004\t\u000f\u0005\r6\u00041\u0001\u0002&\u0006Aq-\u001a;QK\u0016\u00148\u000f\u0006\u0003\u0002b\nM\u0001bBA'9\u0001\u0007\u0011qJ\u0001\u001eO\u0016$8\u000b[;gM2,\u0007+^:i\u001b\u0016\u0014x-\u001a:M_\u000e\fG/[8ogR1\u0011\u0011\u001dB\r\u0005GAqAa\u0007\u001e\u0001\u0004\u0011i\"\u0001\tok6lUM]4feNtU-\u001a3fIB\u0019QHa\b\n\u0007\t\u0005bHA\u0002J]RDqA!\n\u001e\u0001\u0004\u00119#A\u0007i_N$8\u000fV8GS2$XM\u001d\t\u0005y\n%20\u0003\u0003\u0003,\u0005-!aA*fi\u0006y\"/Z7pm\u0016\u001c\u0006.\u001e4gY\u0016\u0004Vo\u001d5NKJ<WM\u001d'pG\u0006$\u0018n\u001c8\u0015\u0007M\u0013\t\u0004\u0003\u0004\u00034y\u0001\ra_\u0001\u0005Q>\u001cH/\u0001\fhKR,\u00050Z2vi>\u0014XI\u001c3q_&tGOU3g)\u0011\u0011IDa\u000f\u0011\tu\nYo\u0013\u0005\u0007\u0005{y\u0002\u0019A>\u0002\u0015\u0015DXmY;u_JLE-A\u0006sK6|g/\u001a\"m_\u000e\\GcA*\u0003D!9\u00111\u0015\u0011A\u0002\u0005\u0015\u0016!\u0003:f[>4XM\u00153e)\u0015\u0019&\u0011\nB'\u0011\u001d\u0011Y%\ta\u0001\u0005;\tQA\u001d3e\u0013\u0012DaAa\u0014\"\u0001\u0004!\u0017\u0001\u00032m_\u000e\\\u0017N\\4\u0002\u001bI,Wn\u001c<f'\",hM\u001a7f)\u0015\u0019&Q\u000bB-\u0011\u001d\u00119F\ta\u0001\u0005;\t\u0011b\u001d5vM\u001adW-\u00133\t\r\t=#\u00051\u0001e\u0003=\u0011X-\\8wK\n\u0013x.\u00193dCN$HcB*\u0003`\t\r$q\r\u0005\b\u0005C\u001a\u0003\u0019AA9\u0003-\u0011'o\\1eG\u0006\u001cH/\u00133\t\r\t\u00154\u00051\u0001e\u0003A\u0011X-\\8wK\u001a\u0013x.\\'bgR,'\u000f\u0003\u0004\u0003P\r\u0002\r\u0001Z\u0001\u0010O\u0016$X*Z7pef\u001cF/\u0019;vgV\u0011!Q\u000e\t\by\n=\u0014q\nB:\u0013\u0011\u0011\t(a\u0003\u0003\u00075\u000b\u0007\u000fE\u0004>\u0005k\n\t(!\u001d\n\u0007\t]dH\u0001\u0004UkBdWMM\u0001\u0011O\u0016$8\u000b^8sC\u001e,7\u000b^1ukN,\"A! \u0011\u000bu\nIGa \u0011\u0007)\u0014\t)C\u0002\u0003\u0004N\u0012Qb\u0015;pe\u0006<Wm\u0015;biV\u001c\u0018AD4fi\ncwnY6Ti\u0006$Xo\u001d\u000b\u0007\u0005\u0013\u0013\tJa%\u0011\u000fq\u0014y'a\u0014\u0003\fB\u0019!N!$\n\u0007\t=5GA\u0006CY>\u001c7n\u0015;biV\u001c\bbBARM\u0001\u0007\u0011Q\u0015\u0005\t\u0005+3\u0003\u0013!a\u0001I\u0006\u0019\u0012m]6Ti>\u0014\u0018mZ3F]\u0012\u0004x.\u001b8ug\u0006Ar-\u001a;CY>\u001c7n\u0015;biV\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002'\u001d,G/T1uG\"Lgn\u001a\"m_\u000e\\\u0017\nZ:\u0015\r\tu%q\u0014BU!\u0019\t9\"!\t\u0002&\"9!\u0011\u0015\u0015A\u0002\t\r\u0016A\u00024jYR,'\u000f\u0005\u0004>\u0005K\u000b)\u000bZ\u0005\u0004\u0005Os$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0019\u0011)\n\u000ba\u0001I\u0006!1\u000f^8q)\u0005\u0019\u0016\u0001\u0002;fY2$2a\u0015BZ\u0011\u001d\u0011)L\u000ba\u0001\u0005o\u000bq!\\3tg\u0006<W\rE\u0002>\u0005sK1Aa/?\u0005\r\te._\u0001\u0013\u00052|7m['b]\u0006<WM]'bgR,'\u000f\u0005\u0002kYM\u0011A\u0006\u0010\u000b\u0003\u0005\u007f\u000bA\u0003\u0012*J-\u0016\u0013v,\u0012(E!>Ke\nV0O\u00036+UC\u0001Be!\u0011\u0011YM!6\u000e\u0005\t5'\u0002\u0002Bh\u0005#\fA\u0001\\1oO*\u0011!1[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\n\t5\u0017!\u0006#S\u0013Z+%kX#O\tB{\u0015J\u0014+`\u001d\u0006kU\tI\u0001\u001f\tJKe+\u0012*`\u0011\u0016\u000b%\u000b\u0016\"F\u0003R{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u000bq\u0004\u0012*J-\u0016\u0013v\fS#B%R\u0013U)\u0011+`\u000b:#\u0005kT%O)~s\u0015)T#!\u0001")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private RpcEndpointRef driverHeartbeatEndPoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private final RpcTimeout waitBlockRemovalTimeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_HEARTBEAT_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_HEARTBEAT_ENDPOINT_NAME();
    }

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcEndpointRef driverHeartbeatEndPoint() {
        return this.driverHeartbeatEndPoint;
    }

    public void driverHeartbeatEndPoint_$eq(RpcEndpointRef x$1) {
        this.driverHeartbeatEndPoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    private RpcTimeout waitBlockRemovalTimeout() {
        return this.waitBlockRemovalTimeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " successfully in removeExecutor"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXECUTOR_ID, execId)}))));
    }

    public void decommissionBlockManagers(Seq<String> executorIds) {
        this.driverEndpoint().ask(new BlockManagerMessages.DecommissionBlockManagers(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public Seq<BlockManagerMessages.ReplicateBlock> getReplicateInfoForRDDBlocks(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetReplicateInfoForRDDBlocks(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removal of executor ", " requested"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXECUTOR_ID, execId)}))));
    }

    public BlockManagerId registerBlockManager(BlockManagerId id, String[] localDirs, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef storageEndpoint, boolean isReRegister) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Registering BlockManager ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_MANAGER_ID, id)}))));
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(id, localDirs, maxOnHeapMemSize, maxOffHeapMemSize, storageEndpoint, isReRegister), ClassTag$.MODULE$.apply(BlockManagerId.class));
        String string = updatedId.executorId();
        String string2 = BlockManagerId$.MODULE$.INVALID_EXECUTOR_ID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.assert(isReRegister, (Function0 & Serializable)() -> "Got invalid executor id from non re-register case");
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-register BlockManager ", " failed"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_MANAGER_ID, id)}))));
        } else {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Registered BlockManager ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_MANAGER_ID, updatedId)}))));
        }
        return updatedId;
    }

    public boolean registerBlockManager$default$6() {
        return false;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Updated info of block " + blockId);
        return res;
    }

    public void updateRDDBlockTaskInfo(RDDBlockId blockId, long taskId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.UpdateRDDBlockTaskInfo(blockId, taskId), ClassTag$.MODULE$.Unit());
    }

    public void updateRDDBlockVisibility(long taskId, boolean visible) {
        this.driverEndpoint().ask(new BlockManagerMessages.UpdateRDDBlockVisibility(taskId, visible), ClassTag$.MODULE$.Unit());
    }

    public boolean isRDDBlockVisible(RDDBlockId blockId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.GetRDDBlockVisibility(blockId), ClassTag$.MODULE$.Boolean()));
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId, String requesterHost) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId, requesterHost), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return this.getLocations(blockId).nonEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Seq<BlockManagerId> getShufflePushMergerLocations(int numMergersNeeded, Set<String> hostsToFilter) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetShufflePushMergerLocations(numMergersNeeded, hostsToFilter), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeShufflePushMergerLocation(String host) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Request to remove shuffle push merger location ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.HOST, host)}))));
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveShufflePushMergerLocation(host), ClassTag$.MODULE$.Unit());
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
        future.failed().foreach((Function1 & Serializable)e -> {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove RDD ", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.RDD_ID, BoxesRunTime.boxToInteger((int)rddId$1))})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.ERROR, e.getMessage())})))), e);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.waitBlockRemovalTimeout().awaitResult(future);
            return;
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
        future.failed().foreach((Function1 & Serializable)e -> {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove shuffle ", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.SHUFFLE_ID, BoxesRunTime.boxToInteger((int)shuffleId$1))})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.ERROR, e.getMessage())})))), e);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.waitBlockRemovalTimeout().awaitResult(future);
            return;
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
        future.failed().foreach((Function1 & Serializable)e -> {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove broadcast ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.BROADCAST_ID, BoxesRunTime.boxToLong((long)broadcastId$1))})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with removeFromMaster = ", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.REMOVE_FROM_MASTER, BoxesRunTime.boxToBoolean((boolean)removeFromMaster$1))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.ERROR, e.getMessage())})))), e);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.waitBlockRemovalTimeout().awaitResult(future);
            return;
        }
    }

    public scala.collection.immutable.Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        if (this.driverEndpoint() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        if (this.driverEndpoint() == null) {
            return (StorageStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StorageStatus.class));
        }
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public scala.collection.immutable.Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askStorageEndpoints) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askStorageEndpoints);
        scala.collection.immutable.Map response = (scala.collection.immutable.Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class));
        Tuple2 tuple2 = response.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable blockManagerIds = (Iterable)tuple2._1();
        Iterable futures = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Iterable blockManagerIds2 = (Iterable)tuple22._1();
        Iterable futures2 = (Iterable)tuple22._2();
        BuildFrom cbf = (BuildFrom)Predef$.MODULE$.implicitly((Object)BuildFrom$.MODULE$.buildFromIterableOps());
        Iterable blockStatus = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((IterableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw SparkCoreErrors$.MODULE$.blockStatusQueryReturnedNullError(blockId);
        }
        return ((IterableOnceOps)((IterableOps)blockManagerIds2.zip((IterableOnce)blockStatus)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                Option status = (Option)tuple2._2();
                return status.map((Function1 & Serializable)s -> new Tuple2((Object)blockManagerId, s));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askStorageEndpoints) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askStorageEndpoints);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public void stop() {
        if (this.driverEndpoint() != null && this.isDriver) {
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            if (BoxesRunTime.unboxToBoolean(this.driverHeartbeatEndPoint().askSync(BlockManagerMessages$StopBlockManagerMaster$.MODULE$, ClassTag$.MODULE$.Boolean()))) {
                this.driverHeartbeatEndPoint_$eq(null);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop BlockManagerMasterHeartbeatEndpoint");
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "BlockManagerMaster stopped");
            return;
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw SparkCoreErrors$.MODULE$.unexpectedBlockManagerMasterEndpointResultError();
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, RpcEndpointRef driverHeartbeatEndPoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.driverHeartbeatEndPoint = driverHeartbeatEndPoint;
        this.isDriver = isDriver;
        Logging.$init$((Logging)this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
        this.waitBlockRemovalTimeout = RpcTimeout$.MODULE$.apply(conf, package$.MODULE$.CLEANER_REFERENCE_TRACKING_BLOCKING_TIMEOUT().key(), "120s");
    }
}

