/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStructInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class FilterStructColumnInList
extends FilterStringColumnInList
implements IStructInExpr {
    private static final long serialVersionUID = 1L;
    private VectorExpression[] structExpressions;
    private ColumnVector.Type[] fieldVectorColumnTypes;
    private int[] structColumnMap;
    private int scratchBytesColumn;
    private transient ByteStream.Output buffer;
    private transient BinarySortableSerializeWrite binarySortableSerializeWrite;

    public FilterStructColumnInList() {
        super(-1);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int logicalSize = batch.size;
        if (logicalSize == 0) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = new ByteStream.Output();
            this.binarySortableSerializeWrite = new BinarySortableSerializeWrite(this.structColumnMap.length);
        }
        for (VectorExpression ve : this.structExpressions) {
            ve.evaluate(batch);
        }
        BytesColumnVector scratchBytesColumnVector = (BytesColumnVector)batch.cols[this.scratchBytesColumn];
        try {
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            for (int logical = 0; logical < logicalSize; ++logical) {
                int batchIndex = selectedInUse ? selected[logical] : logical;
                this.binarySortableSerializeWrite.set(this.buffer);
                block10: for (int f = 0; f < this.structColumnMap.length; ++f) {
                    int adjustedIndex;
                    int fieldColumn = this.structColumnMap[f];
                    ColumnVector colVec = batch.cols[fieldColumn];
                    int n = adjustedIndex = colVec.isRepeating ? 0 : batchIndex;
                    if (colVec.noNulls || !colVec.isNull[adjustedIndex]) {
                        switch (this.fieldVectorColumnTypes[f]) {
                            case BYTES: {
                                BytesColumnVector bytesColVec = (BytesColumnVector)colVec;
                                byte[] bytes = bytesColVec.vector[adjustedIndex];
                                int start = bytesColVec.start[adjustedIndex];
                                int length = bytesColVec.length[adjustedIndex];
                                this.binarySortableSerializeWrite.writeString(bytes, start, length);
                                continue block10;
                            }
                            case LONG: {
                                this.binarySortableSerializeWrite.writeLong(((LongColumnVector)colVec).vector[adjustedIndex]);
                                continue block10;
                            }
                            case DOUBLE: {
                                this.binarySortableSerializeWrite.writeDouble(((DoubleColumnVector)colVec).vector[adjustedIndex]);
                                continue block10;
                            }
                            case DECIMAL: {
                                DecimalColumnVector decColVector = (DecimalColumnVector)colVec;
                                this.binarySortableSerializeWrite.writeHiveDecimal(decColVector.vector[adjustedIndex], (int)decColVector.scale);
                                continue block10;
                            }
                            default: {
                                throw new RuntimeException("Unexpected vector column type " + this.fieldVectorColumnTypes[f].name());
                            }
                        }
                    }
                    this.binarySortableSerializeWrite.writeNull();
                }
                scratchBytesColumnVector.setVal(batchIndex, this.buffer.getData(), 0, this.buffer.getLength());
            }
            super.evaluate(batch);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setScratchBytesColumn(int scratchBytesColumn) {
        super.setInputColumn(scratchBytesColumn);
        this.scratchBytesColumn = scratchBytesColumn;
    }

    @Override
    public void setStructColumnExprs(VectorizationContext vContext, List<ExprNodeDesc> structColumnExprs, ColumnVector.Type[] fieldVectorColumnTypes) throws HiveException {
        this.structExpressions = vContext.getVectorExpressions(structColumnExprs);
        this.structColumnMap = new int[this.structExpressions.length];
        for (int i = 0; i < this.structColumnMap.length; ++i) {
            VectorExpression ve = this.structExpressions[i];
            this.structColumnMap[i] = ve.getOutputColumn();
        }
        this.fieldVectorColumnTypes = fieldVectorColumnTypes;
    }

    @Override
    public String vectorExpressionParameters() {
        return "structExpressions " + Arrays.toString(this.structExpressions) + ", fieldVectorColumnTypes " + Arrays.toString(this.fieldVectorColumnTypes) + ", structColumnMap " + Arrays.toString(this.structColumnMap);
    }
}

