/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Stable;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimeFormatter;
import org.apache.spark.sql.catalyst.util.TimeFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.UDTUtils$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Geography;
import org.apache.spark.sql.types.Geometry;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.JArray;
import org.json4s.JBool$;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JLong;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\rms!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002+\u0002\t\u0003)\u0006\"\u0002,\u0002\t\u00039\u0006bBA\u0004\u0003\u0011\u000511\u0001\u0005\b\u0007\u001f\tA\u0011AB\t\u0011\u001d\u0019)\"\u0001C\u0001\u0007/Aqaa\t\u0002\t\u0003\u0019)\u0003C\u0005\u0004B\u0005\u0011\r\u0011\"\u0001\u0004D!91QI\u0001!\u0002\u0013a\u0007\"CB$\u0003\u0005\u0005I\u0011BB%\r\u001d!\u0015\b%A\u0002\u00025DQ\u0001]\u0006\u0005\u0002EDQ!^\u0006\u0005\u0002YDQA_\u0006\u0007\u0002YDQa_\u0006\u0005\u0002qDq!a\u0002\f\t\u0003\tI\u0001C\u0004\u0002\u0010-1\t!!\u0005\t\u000f\u0005U1\u0002\"\u0001\u0002\u0018!9\u0011\u0011E\u0006\u0005\u0002\u0005\r\u0002bBA\u0014\u0017\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003gYA\u0011AA\u001b\u0011\u001d\tyd\u0003C\u0001\u0003\u0003Bq!!\u0012\f\t\u0003\t9\u0005C\u0004\u0002R-!\t!a\u0015\t\u000f\u0005u3\u0002\"\u0001\u0002`!9\u0011\u0011N\u0006\u0005\u0002\u0005-\u0004bBA@\u0017\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003#[A\u0011AAJ\u0011\u001d\tij\u0003C\u0001\u0003?Cq!!+\f\t\u0003\tY\u000bC\u0004\u0002:.!\t!a/\t\u000f\u0005-7\u0002\"\u0001\u0002N\"9\u0011q[\u0006\u0005\u0002\u0005e\u0007bBAr\u0017\u0011\u0005\u0011Q\u001d\u0005\b\u0003{\\A\u0011AA\u0000\u0011\u001d\u0011)b\u0003C\u0001\u0005/AqA!\u000e\f\t\u0003\u00119\u0004C\u0004\u0003J-!\tAa\u0013\t\u000f\t=3\u0002\"\u0001\u0003R!9!qJ\u0006\u0005\u0002\tm\u0003b\u0002B4\u0017\u0011\u0005!\u0011\u000e\u0005\b\u0005_ZA\u0011\u0001B9\u0011\u001d\u0011\u0019i\u0003C!\u0005\u000bCqAa\"\f\r\u0003\u0011I\tC\u0004\u0003\f.!\tA!$\t\u000f\t=5\u0002\"\u0011\u0003\u0012\"9!qS\u0006\u0005B\te\u0005b\u0002BN\u0017\u0011\u0005!Q\u0014\u0005\b\u0005?[A\u0011\u0001BQ\u0011\u001d\u0011yj\u0003C\u0001\u0005GCqAa(\f\t\u0003\u0011I\u000bC\u0004\u00036.!IAa.\t\u000f\t%7\u0002\"\u0001\u0003\"\"9!\u0011\\\u0006\u0005\u0002\t\u0005\u0006\u0002\u0003Bo\u0017\u0011\u0005\u0011Ha8\u0002\u0007I{wO\u0003\u0002;w\u0005\u00191/\u001d7\u000b\u0005qj\u0014!B:qCJ\\'B\u0001 @\u0003\u0019\t\u0007/Y2iK*\t\u0001)A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002D\u00035\t\u0011HA\u0002S_^\u001c2!\u0001$M!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fMB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0003S>T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012AQ\u0001\u000bk:\f\u0007\u000f\u001d7z'\u0016\fHC\u0001-k!\r9\u0015lW\u0005\u00035\"\u0013AaU8nKB\u0019A\fZ4\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011B\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002d\u0011\u00069\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003G\"\u0003\"a\u00125\n\u0005%D%aA!os\")1n\u0001a\u0001Y\u0006\u0019!o\\<\u0011\u0005\r[1cA\u0006G]B\u0011Al\\\u0005\u0003'\u001a\fa\u0001J5oSR$C#\u0001:\u0011\u0005\u001d\u001b\u0018B\u0001;I\u0005\u0011)f.\u001b;\u0002\tML'0Z\u000b\u0002oB\u0011q\t_\u0005\u0003s\"\u00131!\u00138u\u0003\u0019aWM\\4uQ\u000611o\u00195f[\u0006,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0011(A\u0003usB,7/C\u0002\u0002\u0006}\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003\u0015\t\u0007\u000f\u001d7z)\r9\u00171\u0002\u0005\u0007\u0003\u001b\u0001\u0002\u0019A<\u0002\u0003%\f1aZ3u)\r9\u00171\u0003\u0005\u0007\u0003\u001b\t\u0002\u0019A<\u0002\u0011%\u001ch*\u001e7m\u0003R$B!!\u0007\u0002 A\u0019q)a\u0007\n\u0007\u0005u\u0001JA\u0004C_>dW-\u00198\t\r\u00055!\u00031\u0001x\u0003)9W\r\u001e\"p_2,\u0017M\u001c\u000b\u0005\u00033\t)\u0003\u0003\u0004\u0002\u000eM\u0001\ra^\u0001\bO\u0016$()\u001f;f)\u0011\tY#!\r\u0011\u0007\u001d\u000bi#C\u0002\u00020!\u0013AAQ=uK\"1\u0011Q\u0002\u000bA\u0002]\f\u0001bZ3u'\"|'\u000f\u001e\u000b\u0005\u0003o\ti\u0004E\u0002H\u0003sI1!a\u000fI\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019\ti!\u0006a\u0001o\u00061q-\u001a;J]R$2a^A\"\u0011\u0019\tiA\u0006a\u0001o\u00069q-\u001a;M_:<G\u0003BA%\u0003\u001f\u00022aRA&\u0013\r\ti\u0005\u0013\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u000e]\u0001\ra^\u0001\tO\u0016$h\t\\8biR!\u0011QKA.!\r9\u0015qK\u0005\u0004\u00033B%!\u0002$m_\u0006$\bBBA\u00071\u0001\u0007q/A\u0005hKR$u.\u001e2mKR!\u0011\u0011MA4!\r9\u00151M\u0005\u0004\u0003KB%A\u0002#pk\ndW\r\u0003\u0004\u0002\u000ee\u0001\ra^\u0001\nO\u0016$8\u000b\u001e:j]\u001e$B!!\u001c\u0002~A!\u0011qNA<\u001d\u0011\t\t(a\u001d\u0011\u0005yC\u0015bAA;\u0011\u00061\u0001K]3eK\u001aLA!!\u001f\u0002|\t11\u000b\u001e:j]\u001eT1!!\u001eI\u0011\u0019\tiA\u0007a\u0001o\u0006Qq-\u001a;EK\u000eLW.\u00197\u0015\t\u0005\r\u0015q\u0012\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012)\u0002\t5\fG\u000f[\u0005\u0005\u0003\u001b\u000b9I\u0001\u0006CS\u001e$UmY5nC2Da!!\u0004\u001c\u0001\u00049\u0018aC4fi\u001e+w.\\3uef$B!!&\u0002\u001cB\u0019a0a&\n\u0007\u0005euP\u0001\u0005HK>lW\r\u001e:z\u0011\u0019\ti\u0001\ba\u0001o\u0006aq-\u001a;HK><'/\u00199isR!\u0011\u0011UAT!\rq\u00181U\u0005\u0004\u0003K{(!C$f_\u001e\u0014\u0018\r\u001d5z\u0011\u0019\ti!\ba\u0001o\u00069q-\u001a;ECR,G\u0003BAW\u0003o\u0003B!a,\u000246\u0011\u0011\u0011\u0017\u0006\u0003uAKA!!.\u00022\n!A)\u0019;f\u0011\u0019\tiA\ba\u0001o\u0006aq-\u001a;M_\u000e\fG\u000eR1uKR!\u0011QXAe!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb!\u0006!A/[7f\u0013\u0011\t9-!1\u0003\u00131{7-\u00197ECR,\u0007BBA\u0007?\u0001\u0007q/\u0001\u0007hKR$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0002P\u0006U\u0007\u0003BAX\u0003#LA!a5\u00022\nIA+[7fgR\fW\u000e\u001d\u0005\u0007\u0003\u001b\u0001\u0003\u0019A<\u0002\u0015\u001d,G/\u00138ti\u0006tG\u000f\u0006\u0003\u0002\\\u0006\u0005\b\u0003BA`\u0003;LA!a8\u0002B\n9\u0011J\\:uC:$\bBBA\u0007C\u0001\u0007q/\u0001\u0004hKR\u001cV-]\u000b\u0005\u0003O\fy\u000f\u0006\u0003\u0002j\u0006m\b\u0003\u0002/e\u0003W\u0004B!!<\u0002p2\u0001AaBAyE\t\u0007\u00111\u001f\u0002\u0002)F\u0019\u0011Q_4\u0011\u0007\u001d\u000b90C\u0002\u0002z\"\u0013qAT8uQ&tw\r\u0003\u0004\u0002\u000e\t\u0002\ra^\u0001\bO\u0016$H*[:u+\u0011\u0011\tA!\u0005\u0015\t\t\r!1\u0003\t\u0007\u0005\u000b\u0011YAa\u0004\u000e\u0005\t\u001d!b\u0001B\u0005!\u0006!Q\u000f^5m\u0013\u0011\u0011iAa\u0002\u0003\t1K7\u000f\u001e\t\u0005\u0003[\u0014\t\u0002B\u0004\u0002r\u000e\u0012\r!a=\t\r\u000551\u00051\u0001x\u0003\u00199W\r^'baV1!\u0011\u0004B\u0015\u0005_!BAa\u0007\u00034AA!Q\u0004B\u0012\u0005O\u0011i#\u0004\u0002\u0003 )\u0019!\u0011\u0005%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003&\t}!aA'baB!\u0011Q\u001eB\u0015\t\u001d\u0011Y\u0003\nb\u0001\u0003g\u0014\u0011a\u0013\t\u0005\u0003[\u0014y\u0003B\u0004\u00032\u0011\u0012\r!a=\u0003\u0003YCa!!\u0004%\u0001\u00049\u0018AC4fi*\u000bg/Y'baV1!\u0011\bB!\u0005\u000b\"BAa\u000f\u0003HAA!Q\u0001B\u001f\u0005\u007f\u0011\u0019%\u0003\u0003\u0003&\t\u001d\u0001\u0003BAw\u0005\u0003\"qAa\u000b&\u0005\u0004\t\u0019\u0010\u0005\u0003\u0002n\n\u0015Ca\u0002B\u0019K\t\u0007\u00111\u001f\u0005\u0007\u0003\u001b)\u0003\u0019A<\u0002\u0013\u001d,Go\u0015;sk\u000e$Hc\u00017\u0003N!1\u0011Q\u0002\u0014A\u0002]\fQaZ3u\u0003N,BAa\u0015\u0003XQ!!Q\u000bB-!\u0011\tiOa\u0016\u0005\u000f\u0005ExE1\u0001\u0002t\"1\u0011QB\u0014A\u0002],BA!\u0018\u0003bQ!!q\fB2!\u0011\tiO!\u0019\u0005\u000f\u0005E\bF1\u0001\u0002t\"9!Q\r\u0015A\u0002\u00055\u0014!\u00034jK2$g*Y7f\u0003)1\u0017.\u001a7e\u0013:$W\r\u001f\u000b\u0004o\n-\u0004b\u0002B7S\u0001\u0007\u0011QN\u0001\u0005]\u0006lW-\u0001\u0007hKR4\u0016\r\\;fg6\u000b\u0007/\u0006\u0003\u0003t\tmD\u0003\u0002B;\u0005{\u0002\u0002\"a\u001c\u0003x\u00055$\u0011P\u0005\u0005\u0005K\tY\b\u0005\u0003\u0002n\nmDaBAyU\t\u0007\u00111\u001f\u0005\b\u0005\u007fR\u0003\u0019\u0001BA\u0003)1\u0017.\u001a7e\u001d\u0006lWm\u001d\t\u00059\u0012\fi'\u0001\u0005u_N#(/\u001b8h)\t\ti'\u0001\u0003d_BLH#\u00017\u0002\u000f\u0005t\u0017PT;mYV\u0011\u0011\u0011D\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e!1\u0013\u0005\u0007\u0005+s\u0003\u0019A4\u0002\u0003=\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002o\u0006)Ao\\*fcV\t1,\u0001\u0005nWN#(/\u001b8h+\t\ti\u0007\u0006\u0003\u0002n\t\u0015\u0006b\u0002BTe\u0001\u0007\u0011QN\u0001\u0004g\u0016\u0004H\u0003CA7\u0005W\u0013yK!-\t\u000f\t56\u00071\u0001\u0002n\u0005)1\u000f^1si\"9!qU\u001aA\u0002\u00055\u0004b\u0002BZg\u0001\u0007\u0011QN\u0001\u0004K:$\u0017aC4fi\u0006s\u0017PV1m\u0003N,BA!/\u0003>R!!1\u0018Bd!\u0011\tiO!0\u0005\u000f\u0005EHG1\u0001\u0003@F!\u0011Q\u001fBa!\r9%1Y\u0005\u0004\u0005\u000bD%AB!osZ\u000bG\u000e\u0003\u0004\u0002\u000eQ\u0002\ra^\u0001\u0005UN|g\u000eK\u00026\u0005\u001b\u0004BAa4\u0003V6\u0011!\u0011\u001b\u0006\u0004\u0005'\\\u0014AC1o]>$\u0018\r^5p]&!!q\u001bBi\u0005!)fn\u001d;bE2,\u0017A\u00039sKR$\u0018PS:p]\"\u001aaG!4\u0002\u0013)\u001cxN\u001c,bYV,WC\u0001Bq!\u0011\u0011\u0019O!>\u000f\t\t\u0015(q\u001e\b\u0005\u0005O\u0014YOD\u0002_\u0005SL\u0011\u0001Q\u0005\u0004\u0005[|\u0014A\u00026t_:$4/\u0003\u0003\u0003r\nM\u0018a\u0002&t_:\f5\u000b\u0016\u0006\u0004\u0005[|\u0014\u0002\u0002B|\u0005s\u0014aA\u0013,bYV,'\u0002\u0002By\u0005gD3a\u0003B\u007f!\u0011\u0011yMa@\n\t\r\u0005!\u0011\u001b\u0002\u0007'R\f'\r\\3\u0015\u00071\u001c)\u0001C\u0004\u0004\b\u0011\u0001\ra!\u0003\u0002\rY\fG.^3t!\u0011951B4\n\u0007\r5\u0001J\u0001\u0006=e\u0016\u0004X-\u0019;fIz\nqA\u001a:p[N+\u0017\u000fF\u0002m\u0007'Aaaa\u0002\u0006\u0001\u0004Y\u0016!\u00034s_6$V\u000f\u001d7f)\ra7\u0011\u0004\u0005\b\u000771\u0001\u0019AB\u000f\u0003\u0015!X\u000f\u001d7f!\r95qD\u0005\u0004\u0007CA%a\u0002)s_\u0012,8\r^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004Y\u000e\u001d\u0002bBB\u0015\u000f\u0001\u000711F\u0001\u0005e><8\u000f\u0005\u0003H\u0007\u0017a\u0007fC\u0004\u00040\rU2qGB\u001e\u0007{\u00012aRB\u0019\u0013\r\u0019\u0019\u0004\u0013\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0003\u0007s\t\u0011\t\u00165jg\u0002jW\r\u001e5pI\u0002J7\u000f\t3faJ,7-\u0019;fI\u0002\ng\u000e\u001a\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007EZ;ukJ,\u0007E^3sg&|gn\u001d\u0018\u0002\u000bMLgnY3\"\u0005\r}\u0012!B\u001a/a9\u0002\u0014!B3naRLX#\u00017\u0002\r\u0015l\u0007\u000f^=!\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019Y\u0005\u0005\u0003\u0004N\rMSBAB(\u0015\r\u0019\t\u0006U\u0001\u0005Y\u0006tw-\u0003\u0003\u0004V\r=#AB(cU\u0016\u001cG\u000fK\u0002\u0002\u0005{D3\u0001\u0001B\u007f\u0001")
public interface Row
extends Serializable {
    public static Row empty() {
        return Row$.MODULE$.empty();
    }

    public static Row merge(scala.collection.immutable.Seq<Row> rows) {
        return Row$.MODULE$.merge(rows);
    }

    public static Row fromTuple(Product tuple) {
        return Row$.MODULE$.fromTuple(tuple);
    }

    public static Row fromSeq(scala.collection.immutable.Seq<Object> values) {
        return Row$.MODULE$.fromSeq(values);
    }

    public static Some<scala.collection.immutable.Seq<Object>> unapplySeq(Row row) {
        return Row$.MODULE$.unapplySeq(row);
    }

    public static /* synthetic */ int size$(Row $this) {
        return $this.size();
    }

    default public int size() {
        return this.length();
    }

    public int length();

    public static /* synthetic */ StructType schema$(Row $this) {
        return $this.schema();
    }

    default public StructType schema() {
        return null;
    }

    public static /* synthetic */ Object apply$(Row $this, int i) {
        return $this.apply(i);
    }

    default public Object apply(int i) {
        return this.get(i);
    }

    public Object get(int var1);

    public static /* synthetic */ boolean isNullAt$(Row $this, int i) {
        return $this.isNullAt(i);
    }

    default public boolean isNullAt(int i) {
        return this.get(i) == null;
    }

    public static /* synthetic */ boolean getBoolean$(Row $this, int i) {
        return $this.getBoolean(i);
    }

    default public boolean getBoolean(int i) {
        return BoxesRunTime.unboxToBoolean(this.getAnyValAs(i));
    }

    public static /* synthetic */ byte getByte$(Row $this, int i) {
        return $this.getByte(i);
    }

    default public byte getByte(int i) {
        return BoxesRunTime.unboxToByte(this.getAnyValAs(i));
    }

    public static /* synthetic */ short getShort$(Row $this, int i) {
        return $this.getShort(i);
    }

    default public short getShort(int i) {
        return BoxesRunTime.unboxToShort(this.getAnyValAs(i));
    }

    public static /* synthetic */ int getInt$(Row $this, int i) {
        return $this.getInt(i);
    }

    default public int getInt(int i) {
        return BoxesRunTime.unboxToInt(this.getAnyValAs(i));
    }

    public static /* synthetic */ long getLong$(Row $this, int i) {
        return $this.getLong(i);
    }

    default public long getLong(int i) {
        return BoxesRunTime.unboxToLong(this.getAnyValAs(i));
    }

    public static /* synthetic */ float getFloat$(Row $this, int i) {
        return $this.getFloat(i);
    }

    default public float getFloat(int i) {
        return BoxesRunTime.unboxToFloat(this.getAnyValAs(i));
    }

    public static /* synthetic */ double getDouble$(Row $this, int i) {
        return $this.getDouble(i);
    }

    default public double getDouble(int i) {
        return BoxesRunTime.unboxToDouble(this.getAnyValAs(i));
    }

    public static /* synthetic */ String getString$(Row $this, int i) {
        return $this.getString(i);
    }

    default public String getString(int i) {
        return (String)this.getAs(i);
    }

    public static /* synthetic */ java.math.BigDecimal getDecimal$(Row $this, int i) {
        return $this.getDecimal(i);
    }

    default public java.math.BigDecimal getDecimal(int i) {
        return (java.math.BigDecimal)this.getAs(i);
    }

    public static /* synthetic */ Geometry getGeometry$(Row $this, int i) {
        return $this.getGeometry(i);
    }

    default public Geometry getGeometry(int i) {
        return (Geometry)this.getAs(i);
    }

    public static /* synthetic */ Geography getGeography$(Row $this, int i) {
        return $this.getGeography(i);
    }

    default public Geography getGeography(int i) {
        return (Geography)this.getAs(i);
    }

    public static /* synthetic */ Date getDate$(Row $this, int i) {
        return $this.getDate(i);
    }

    default public Date getDate(int i) {
        return (Date)this.getAs(i);
    }

    public static /* synthetic */ LocalDate getLocalDate$(Row $this, int i) {
        return $this.getLocalDate(i);
    }

    default public LocalDate getLocalDate(int i) {
        return (LocalDate)this.getAs(i);
    }

    public static /* synthetic */ Timestamp getTimestamp$(Row $this, int i) {
        return $this.getTimestamp(i);
    }

    default public Timestamp getTimestamp(int i) {
        return (Timestamp)this.getAs(i);
    }

    public static /* synthetic */ Instant getInstant$(Row $this, int i) {
        return $this.getInstant(i);
    }

    default public Instant getInstant(int i) {
        return (Instant)this.getAs(i);
    }

    public static /* synthetic */ scala.collection.immutable.Seq getSeq$(Row $this, int i) {
        return $this.getSeq(i);
    }

    default public <T> scala.collection.immutable.Seq<T> getSeq(int i) {
        Seq seq = (Seq)this.getAs(i);
        if (seq instanceof ArraySeq) {
            ArraySeq arraySeq = (ArraySeq)seq;
            return ArrayImplicits$.MODULE$.SparkArrayOps(arraySeq.array()).toImmutableArraySeq();
        }
        if (seq != null) {
            return seq.toSeq();
        }
        return null;
    }

    public static /* synthetic */ java.util.List getList$(Row $this, int i) {
        return $this.getList(i);
    }

    default public <T> java.util.List<T> getList(int i) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.getSeq(i)).asJava();
    }

    public static /* synthetic */ Map getMap$(Row $this, int i) {
        return $this.getMap(i);
    }

    default public <K, V> Map<K, V> getMap(int i) {
        return (Map)this.getAs(i);
    }

    public static /* synthetic */ java.util.Map getJavaMap$(Row $this, int i) {
        return $this.getJavaMap(i);
    }

    default public <K, V> java.util.Map<K, V> getJavaMap(int i) {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.getMap(i)).asJava();
    }

    public static /* synthetic */ Row getStruct$(Row $this, int i) {
        return $this.getStruct(i);
    }

    default public Row getStruct(int i) {
        return (Row)this.getAs(i);
    }

    public static /* synthetic */ Object getAs$(Row $this, int i) {
        return $this.getAs(i);
    }

    default public <T> T getAs(int i) {
        return (T)this.get(i);
    }

    public static /* synthetic */ Object getAs$(Row $this, String fieldName) {
        return $this.getAs(fieldName);
    }

    default public <T> T getAs(String fieldName) {
        return this.getAs(this.fieldIndex(fieldName));
    }

    public static /* synthetic */ int fieldIndex$(Row $this, String name) {
        return $this.fieldIndex(name);
    }

    default public int fieldIndex(String name) {
        throw DataTypeErrors$.MODULE$.fieldIndexOnRowWithoutSchemaError(name);
    }

    public static /* synthetic */ scala.collection.immutable.Map getValuesMap$(Row $this, scala.collection.immutable.Seq fieldNames) {
        return $this.getValuesMap((scala.collection.immutable.Seq<String>)fieldNames);
    }

    default public <T> scala.collection.immutable.Map<String, T> getValuesMap(scala.collection.immutable.Seq<String> fieldNames) {
        return ((IterableOnceOps)fieldNames.map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.getAs((String)name)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static /* synthetic */ String toString$(Row $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.mkString("[", ",", "]");
    }

    public Row copy();

    public static /* synthetic */ boolean anyNull$(Row $this) {
        return $this.anyNull();
    }

    default public boolean anyNull() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (!this.isNullAt(i)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean equals$(Row $this, Object o) {
        return $this.equals(o);
    }

    default public boolean equals(Object o) {
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (other == null) {
            return false;
        }
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            double d;
            float f;
            if (this.isNullAt(i) != other.isNullAt(i)) {
                return false;
            }
            if (this.isNullAt(i)) continue;
            Object o1 = this.get(i);
            Object o2 = other.get(i);
            Object object = o1;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (o2 instanceof byte[] && Arrays.equals(byArray, (byte[])o2)) continue;
                return false;
            }
            if (object instanceof Float && Float.isNaN(f = BoxesRunTime.unboxToFloat((Object)object))) {
                if (o2 instanceof Float && Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) continue;
                return false;
            }
            if (object instanceof Double && Double.isNaN(d = BoxesRunTime.unboxToDouble((Object)object))) {
                if (o2 instanceof Double && Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) continue;
                return false;
            }
            if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                if (o2 instanceof java.math.BigDecimal) {
                    if (bigDecimal.compareTo((java.math.BigDecimal)o2) == 0) continue;
                    return false;
                }
            }
            if (BoxesRunTime.equals((Object)o1, (Object)o2)) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ int hashCode$(Row $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        int n;
        int h = MurmurHash3$.MODULE$.seqSeed();
        int len = this.length();
        for (n = 0; n < len; ++n) {
            h = MurmurHash3$.MODULE$.mix(h, Statics.anyHash((Object)this.apply(n)));
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, n);
    }

    public static /* synthetic */ scala.collection.immutable.Seq toSeq$(Row $this) {
        return $this.toSeq();
    }

    default public scala.collection.immutable.Seq<Object> toSeq() {
        int n = this.length();
        Object[] values = new Object[n];
        for (int i = 0; i < n; ++i) {
            values[i] = this.get(i);
        }
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq();
    }

    public static /* synthetic */ String mkString$(Row $this) {
        return $this.mkString();
    }

    default public String mkString() {
        return this.mkString("");
    }

    public static /* synthetic */ String mkString$(Row $this, String sep) {
        return $this.mkString(sep);
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public static /* synthetic */ String mkString$(Row $this, String start, String sep, String end) {
        return $this.mkString(start, sep, end);
    }

    default public String mkString(String start, String sep, String end) {
        int n = this.length();
        StringBuilder builder = new StringBuilder();
        builder.append(start);
        if (n > 0) {
            builder.append(this.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append(sep);
                builder.append(this.get(i));
            }
        }
        builder.append(end);
        return builder.toString();
    }

    private <T> T getAnyValAs(int i) {
        if (this.isNullAt(i)) {
            throw DataTypeErrors$.MODULE$.valueIsNullError(i);
        }
        return this.getAs(i);
    }

    public static /* synthetic */ String json$(Row $this) {
        return $this.json();
    }

    @Unstable
    default public String json() {
        return JsonMethods$.MODULE$.compact(this.jsonValue());
    }

    public static /* synthetic */ String prettyJson$(Row $this) {
        return $this.prettyJson();
    }

    @Unstable
    default public String prettyJson() {
        return JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(this.jsonValue(), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
    }

    public static /* synthetic */ JValue jsonValue$(Row $this) {
        return $this.jsonValue();
    }

    default public JValue jsonValue() {
        LazyRef zoneId$lzy = new LazyRef();
        LazyRef dateFormatter$lzy = new LazyRef();
        LazyRef timestampFormatter$lzy = new LazyRef();
        LazyRef timeFormatter$lzy = new LazyRef();
        Predef$.MODULE$.require(this.schema() != null, (Function0 & Serializable)() -> "JSON serialization requires a non-null schema.");
        return this.toJson$1(this, this.schema(), timeFormatter$lzy, dateFormatter$lzy, timestampFormatter$lzy, zoneId$lzy);
    }

    private static /* synthetic */ ZoneId zoneId$lzycompute$1(LazyRef zoneId$lzy$1) {
        ZoneId zoneId;
        LazyRef lazyRef = zoneId$lzy$1;
        synchronized (lazyRef) {
            zoneId = zoneId$lzy$1.initialized() ? (ZoneId)zoneId$lzy$1.value() : (ZoneId)zoneId$lzy$1.initialize((Object)SparkDateTimeUtils$.MODULE$.getZoneId(SqlApiConf$.MODULE$.get().sessionLocalTimeZone()));
        }
        return zoneId;
    }

    private static ZoneId zoneId$1(LazyRef zoneId$lzy$1) {
        if (zoneId$lzy$1.initialized()) {
            return (ZoneId)zoneId$lzy$1.value();
        }
        return Row.zoneId$lzycompute$1(zoneId$lzy$1);
    }

    private static /* synthetic */ DateFormatter dateFormatter$lzycompute$1(LazyRef dateFormatter$lzy$1) {
        DateFormatter dateFormatter;
        LazyRef lazyRef = dateFormatter$lzy$1;
        synchronized (lazyRef) {
            dateFormatter = dateFormatter$lzy$1.initialized() ? (DateFormatter)dateFormatter$lzy$1.value() : (DateFormatter)dateFormatter$lzy$1.initialize((Object)DateFormatter$.MODULE$.apply());
        }
        return dateFormatter;
    }

    private static DateFormatter dateFormatter$1(LazyRef dateFormatter$lzy$1) {
        if (dateFormatter$lzy$1.initialized()) {
            return (DateFormatter)dateFormatter$lzy$1.value();
        }
        return Row.dateFormatter$lzycompute$1(dateFormatter$lzy$1);
    }

    private static /* synthetic */ TimestampFormatter timestampFormatter$lzycompute$1(LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        TimestampFormatter timestampFormatter;
        LazyRef lazyRef = timestampFormatter$lzy$1;
        synchronized (lazyRef) {
            timestampFormatter = timestampFormatter$lzy$1.initialized() ? (TimestampFormatter)timestampFormatter$lzy$1.value() : (TimestampFormatter)timestampFormatter$lzy$1.initialize((Object)TimestampFormatter$.MODULE$.apply(Row.zoneId$1(zoneId$lzy$1)));
        }
        return timestampFormatter;
    }

    private static TimestampFormatter timestampFormatter$1(LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        if (timestampFormatter$lzy$1.initialized()) {
            return (TimestampFormatter)timestampFormatter$lzy$1.value();
        }
        return Row.timestampFormatter$lzycompute$1(timestampFormatter$lzy$1, zoneId$lzy$1);
    }

    private static /* synthetic */ TimeFormatter timeFormatter$lzycompute$1(LazyRef timeFormatter$lzy$1) {
        TimeFormatter timeFormatter;
        LazyRef lazyRef = timeFormatter$lzy$1;
        synchronized (lazyRef) {
            timeFormatter = timeFormatter$lzy$1.initialized() ? (TimeFormatter)timeFormatter$lzy$1.value() : (TimeFormatter)timeFormatter$lzy$1.initialize((Object)TimeFormatter$.MODULE$.getFractionFormatter());
        }
        return timeFormatter;
    }

    private static TimeFormatter timeFormatter$1(LazyRef timeFormatter$lzy$1) {
        if (timeFormatter$lzy$1.initialized()) {
            return (TimeFormatter)timeFormatter$lzy$1.value();
        }
        return Row.timeFormatter$lzycompute$1(timeFormatter$lzy$1);
    }

    private JArray iteratorToJsonArray$1(Iterator iterator, DataType elementType, LazyRef timeFormatter$lzy$1, LazyRef dateFormatter$lzy$1, LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        return new JArray(iterator.map((Function1 & Serializable)x$2 -> this.toJson$1(x$2, elementType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1)).toList());
    }

    private JValue toJson$1(Object value, DataType dataType, LazyRef timeFormatter$lzy$1, LazyRef dateFormatter$lzy$1, LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        while (true) {
            Object i;
            Object d;
            Object t;
            Object i2;
            Object d2;
            Object d3;
            Object s;
            Object d4;
            Object d5;
            Object d6;
            Object d7;
            Object f;
            Object l;
            Object nanos;
            Object i3;
            Object s2;
            Object b;
            Object b2;
            Object object;
            Tuple2 tuple2;
            if ((tuple2 = new Tuple2(value, (Object)dataType)) != null && (object = tuple2._1()) == null) {
                return JNull$.MODULE$;
            }
            if (tuple2 != null && (b2 = tuple2._1()) instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)b2);
                return JBool$.MODULE$.apply(bl);
            }
            if (tuple2 != null && (b = tuple2._1()) instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)b);
                return new JLong((long)by);
            }
            if (tuple2 != null && (s2 = tuple2._1()) instanceof Short) {
                short s3 = BoxesRunTime.unboxToShort((Object)s2);
                return new JLong((long)s3);
            }
            if (tuple2 != null && (i3 = tuple2._1()) instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i3);
                return new JLong((long)n);
            }
            if (tuple2 != null && (nanos = tuple2._1()) instanceof Long) {
                long l2 = BoxesRunTime.unboxToLong((Object)nanos);
                if (tuple2._2() instanceof TimeType) {
                    return new JString(Row.timeFormatter$1(timeFormatter$lzy$1).format(l2));
                }
            }
            if (tuple2 != null && (l = tuple2._1()) instanceof Long) {
                long l3 = BoxesRunTime.unboxToLong((Object)l);
                return new JLong(l3);
            }
            if (tuple2 != null && (f = tuple2._1()) instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)f);
                return new JDouble((double)f2);
            }
            if (tuple2 != null && (d7 = tuple2._1()) instanceof Double) {
                double d8 = BoxesRunTime.unboxToDouble((Object)d7);
                return new JDouble(d8);
            }
            if (tuple2 != null && (d6 = tuple2._1()) instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)d6;
                return new JDecimal(bigDecimal);
            }
            if (tuple2 != null && (d5 = tuple2._1()) instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)d5;
                return new JDecimal(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
            }
            if (tuple2 != null && (d4 = tuple2._1()) instanceof Decimal) {
                Decimal decimal = (Decimal)d4;
                return new JDecimal(decimal.toBigDecimal());
            }
            if (tuple2 != null && (s = tuple2._1()) instanceof String) {
                String string = (String)s;
                return new JString(string);
            }
            if (tuple2 != null) {
                Object b3 = tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (b3 instanceof byte[]) {
                    byte[] byArray = (byte[])b3;
                    if (BinaryType$.MODULE$.equals(dataType2)) {
                        return new JString(Base64.getEncoder().encodeToString(byArray));
                    }
                }
            }
            if (tuple2 != null && (d3 = tuple2._1()) instanceof LocalDate) {
                LocalDate localDate = (LocalDate)d3;
                return new JString(Row.dateFormatter$1(dateFormatter$lzy$1).format(localDate));
            }
            if (tuple2 != null && (d2 = tuple2._1()) instanceof Date) {
                Date date = (Date)d2;
                return new JString(Row.dateFormatter$1(dateFormatter$lzy$1).format(date));
            }
            if (tuple2 != null && (i2 = tuple2._1()) instanceof Instant) {
                Instant instant = (Instant)i2;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(instant));
            }
            if (tuple2 != null && (t = tuple2._1()) instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(timestamp));
            }
            if (tuple2 != null && (d = tuple2._1()) instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)d;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(localDateTime));
            }
            if (tuple2 != null && (i = tuple2._1()) instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)i;
                return new JString(calendarInterval.toString());
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (ScalaRunTime$.MODULE$.isArray(a, 1)) {
                    Object object2 = a;
                    if (dataType3 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType3;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(object2)), elementType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                DataType dataType4 = (DataType)tuple2._2();
                if (a instanceof ArraySeq) {
                    ArraySeq arraySeq = (ArraySeq)a;
                    if (dataType4 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType4;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(arraySeq.iterator(), elementType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object s4 = tuple2._1();
                DataType dataType5 = (DataType)tuple2._2();
                if (s4 instanceof scala.collection.immutable.Seq) {
                    scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)s4;
                    if (dataType5 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType5;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(seq.iterator(), elementType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object m = tuple2._1();
                DataType dataType6 = (DataType)tuple2._2();
                if (m instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                    if (dataType6 instanceof MapType) {
                        MapType mapType = (MapType)dataType6;
                        DataType dataType7 = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        if (((Object)StringType$.MODULE$).equals(dataType7)) {
                            return new JObject(((List)map.toList().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    Object v = tuple2._2();
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.toJson$1(v, valueType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                }
                                throw new MatchError((Object)tuple2);
                            }));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Object m = tuple2._1();
                DataType dataType8 = (DataType)tuple2._2();
                if (m instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                    if (dataType8 instanceof MapType) {
                        MapType mapType = (MapType)dataType8;
                        DataType keyType = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        return new JArray(map.iterator().map((Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toJson$1(k, keyType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toJson$1(v, valueType, timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                return new JObject(Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22));
                            }
                            throw new MatchError((Object)tuple2);
                        }).toList());
                    }
                }
            }
            if (tuple2 != null) {
                Object row = tuple2._1();
                DataType schema = (DataType)tuple2._2();
                if (row instanceof Row) {
                    Row row2 = (Row)row;
                    if (schema instanceof StructType) {
                        StructType structType = (StructType)schema;
                        ListBuffer elements = new ListBuffer();
                        int len = row2.length();
                        for (int n = 0; n < len; ++n) {
                            StructField field = structType.apply(n);
                            elements.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)this.toJson$1(row2.apply(n), field.dataType(), timeFormatter$lzy$1, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1)));
                        }
                        return new JObject(elements.toList());
                    }
                }
            }
            if (tuple2 == null) break;
            Object v = tuple2._1();
            DataType udt = (DataType)tuple2._2();
            if (!(v instanceof Object)) break;
            Object object3 = v;
            if (!(udt instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)udt;
            dataType = userDefinedType.sqlType();
            value = UDTUtils$.MODULE$.toRow(object3, userDefinedType);
        }
        throw new SparkIllegalArgumentException("FAILED_ROW_TO_JSON", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)DataTypeErrors$.MODULE$.toSQLValue(value.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)value.getClass().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)DataTypeErrors$.MODULE$.toSQLType(dataType.toString()))})));
    }

    public static void $init$(Row $this) {
    }
}

