/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Stable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$ClientType$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@DeveloperApi
public final class SparkKubernetesClientFactory$
implements Logging {
    public static final SparkKubernetesClientFactory$ MODULE$ = new SparkKubernetesClientFactory$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KubernetesClient createKubernetesClient(String master, Option<String> namespace, String kubernetesAuthConfPrefix, Enumeration.Value clientType, SparkConf sparkConf, Option<File> defaultServiceAccountCaCert) {
        String oauthTokenFileConf = kubernetesAuthConfPrefix + "." + Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX();
        String oauthTokenConf = kubernetesAuthConfPrefix + "." + Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX();
        Option oauthTokenFile = sparkConf.getOption(oauthTokenFileConf).map((Function1 & Serializable)x$1 -> new File((String)x$1));
        Option oauthTokenValue = sparkConf.getOption(oauthTokenConf);
        KubernetesUtils$.MODULE$.requireNandDefined(oauthTokenFile, oauthTokenValue, "Cannot specify OAuth token through both a file " + oauthTokenFileConf + " and a value " + oauthTokenConf + ".");
        Option caCertFile = sparkConf.getOption(kubernetesAuthConfPrefix + "." + Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).orElse((Function0 & Serializable)() -> defaultServiceAccountCaCert.map((Function1 & Serializable)x$2 -> x$2.getAbsolutePath()));
        Option clientKeyFile = sparkConf.getOption(kubernetesAuthConfPrefix + "." + Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX());
        Option clientCertFile = sparkConf.getOption(kubernetesAuthConfPrefix + "." + Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX());
        Option kubeContext = ((Option)sparkConf.get(Config$.MODULE$.KUBERNETES_CONTEXT())).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3))));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Auto-configuring K8S client using "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.K8S_CONTEXT, kubeContext.map((Function1 & Serializable)x$4 -> "context " + x$4).getOrElse((Function0 & Serializable)() -> "current context"))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" from users K8S config file"}))).log((Seq)Nil$.MODULE$))));
        Object object = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.request.retry.backoffLimit") == null ? System.setProperty("kubernetes.request.retry.backoffLimit", "3") : BoxedUnit.UNIT;
        Config config = SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)((ConfigFluent)new ConfigBuilder(Config.autoConfigure((String)((String)kubeContext.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).withApiVersion("v1").withMasterUrl(master)).withRequestTimeout(SparkKubernetesClientFactory$ClientType$.MODULE$.convert(clientType).requestTimeout(sparkConf)).withConnectionTimeout(SparkKubernetesClientFactory$ClientType$.MODULE$.convert(clientType).connectionTimeout(sparkConf)).withTrustCerts(BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Config$.MODULE$.KUBERNETES_TRUST_CERTIFICATES())))), oauthTokenValue, (Function2 & Serializable)(token, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(token))), oauthTokenFile, (Function2 & Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(Files.readString(file.toPath())))), caCertFile, (Function2 & Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withCaCertFile(file))), clientKeyFile, (Function2 & Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientKeyFile(file))), clientCertFile, (Function2 & Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientCertFile(file))), namespace, (Function2 & Serializable)(ns, configBuilder) -> (ConfigBuilder)configBuilder.withNamespace(ns)).build();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Kubernetes client config: " + new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)config));
        return new KubernetesClientBuilder().withConfig(config).build();
    }

    private ConfigBuilder OptionConfigurableConfigBuilder(ConfigBuilder configBuilder) {
        return configBuilder;
    }

    private SparkKubernetesClientFactory$() {
    }
}

