/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\n\u0014\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AQ\b\u0001B\u0001B\u0003%!\u0006\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015y\u0004\u0001\"\u0001H\u0011\u0015y\u0004\u0001\"\u0001N\u0011\u00151\u0006\u0001\"\u0001X\u0011\u00159\u0007\u0001\"\u0001i\u0011\u00159\u0007\u0001\"\u0003t\u000f!y8#!A\t\u0002\u0005\u0005a\u0001\u0003\n\u0014\u0003\u0003E\t!a\u0001\t\r}bA\u0011AA\u0003\u0011%\t9\u0001DI\u0001\n\u0003\tI\u0001C\u0005\u0002 1\t\n\u0011\"\u0001\u0002\"!I\u0011Q\u0005\u0007\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003Oa\u0011\u0013!C\u0001\u0003\u0013\u0011Qd\u00159be.$v\u000eU1scV,GoU2iK6\f7i\u001c8wKJ$XM\u001d\u0006\u0003)U\tq\u0001]1scV,GO\u0003\u0002\u0017/\u0005YA-\u0019;bg>,(oY3t\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u00021]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fG\u000f\u0005\u0002%W%\u0011A&\n\u0002\b\u0005>|G.Z1o\u0003MyW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f!\ty\u0013H\u0004\u00021m9\u0011\u0011\u0007N\u0007\u0002e)\u00111'G\u0001\tS:$XM\u001d8bY&\u0011QGM\u0001\b'Fc5i\u001c8g\u0013\t9\u0004(\u0001\u000eQCJ\fX/\u001a;PkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004XM\u0003\u00026e%\u0011!h\u000f\u0002\u0006-\u0006dW/Z\u0005\u0003y\u0015\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006QQo]3GS\u0016dG-\u00133\u00025\u0005tgn\u001c;bi\u00164\u0016M]5b]RdunZ5dC2$\u0016\u0010]3\u0002\rqJg.\u001b;?)\u0015\t5\tR#G!\t\u0011\u0005!D\u0001\u0014\u0011\u001dIS\u0001%AA\u0002)Bq!L\u0003\u0011\u0002\u0003\u0007a\u0006C\u0004>\u000bA\u0005\t\u0019\u0001\u0016\t\u000fy*\u0001\u0013!a\u0001UQ\u0011\u0011\t\u0013\u0005\u0006\u0013\u001a\u0001\rAS\u0001\u0005G>tg\r\u0005\u00022\u0017&\u0011AJ\r\u0002\b'Fc5i\u001c8g)\t\te\nC\u0003J\u000f\u0001\u0007q\n\u0005\u0002Q)6\t\u0011K\u0003\u0002J%*\u00111+H\u0001\u0007Q\u0006$wn\u001c9\n\u0005U\u000b&!D\"p]\u001aLw-\u001e:bi&|g.A\u0004d_:4XM\u001d;\u0015\u0005a{\u0006CA-^\u001b\u0005Q&BA.]\u0003\u0019\u00198\r[3nC*\u0011A#H\u0005\u0003=j\u00131\"T3tg\u0006<W\rV=qK\")\u0001\r\u0003a\u0001C\u0006q1-\u0019;bYf\u001cHoU2iK6\f\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u001a\u0003\u0015!\u0018\u0010]3t\u0013\t17M\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbY8om\u0016\u0014HOR5fY\u0012$2!\u001b7r!\tI&.\u0003\u0002l5\n!A+\u001f9f\u0011\u0015i\u0017\u00021\u0001o\u0003\u00151\u0017.\u001a7e!\t\u0011w.\u0003\u0002qG\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0011\u0015\u0011\u0018\u00021\u0001+\u0003)Ign\u00155sK\u0012$W\r\u001a\u000b\u0005SR,h\u0010C\u0003n\u0015\u0001\u0007a\u000eC\u0003w\u0015\u0001\u0007q/\u0001\u0006sKB,G/\u001b;j_:\u0004\"\u0001_>\u000f\u0005eK\u0018B\u0001>[\u0003\u0011!\u0016\u0010]3\n\u0005ql(A\u0003*fa\u0016$\u0018\u000e^5p]*\u0011!P\u0017\u0005\u0006e*\u0001\rAK\u0001\u001e'B\f'o\u001b+p!\u0006\u0014\u0018/^3u'\u000eDW-\\1D_:4XM\u001d;feB\u0011!\tD\n\u0003\u0019\r\"\"!!\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tYAK\u0002+\u0003\u001bY#!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033)\u0013AC1o]>$\u0018\r^5p]&!\u0011QDA\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"f\u0001\u0018\u0002\u000e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;
    private final boolean useFieldId;
    private final boolean annotateVariantLogicalType;

    public static boolean $lessinit$greater$default$4() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((IterableOnceOps)catalystSchema.map((Function1 & Serializable)f -> this.convertField((StructField)f, false))).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type convertField(StructField field, boolean inShredded) {
        Type converted = this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, inShredded);
        if (this.useFieldId && ParquetUtils$.MODULE$.hasFieldId(field)) {
            return converted.withId(ParquetUtils$.MODULE$.getFieldId(field));
        }
        return converted;
    }

    private Type convertField(StructField field2, Type.Repetition repetition, boolean inShredded) {
        Option option;
        Option option2;
        Option option3;
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        boolean bl4 = false;
        StructType structType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof StringType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()).named(field2.name());
        }
        if (dataType instanceof TimeType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            if (inShredded) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
            }
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)).named(field2.name());
            }
            throw new MatchError((Object)value);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()), inShredded)).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl6 = arrayType.containsNull();
            if (!bl6 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED, inShredded)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()), inShredded), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()), inShredded));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()), inShredded)).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()), inShredded)).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()), inShredded)).named("key_value")).named(field2.name());
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return (Type)((Types.BaseGroupBuilder)(this.annotateVariantLogicalType ? Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)1)) : Types.buildGroup((Type.Repetition)repetition))).addField(this.convertField(new StructField("value", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), inShredded)).addField(this.convertField(new StructField("metadata", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), inShredded)).named(field2.name());
        }
        if (dataType instanceof StructType) {
            bl4 = true;
            structType = (StructType)dataType;
            if (SparkShreddingUtils$.MODULE$.isVariantShreddingStruct(structType)) {
                Types.GroupBuilder group = this.annotateVariantLogicalType ? (Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)1)) : Types.buildGroup((Type.Repetition)repetition);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> (Types.GroupBuilder)group.addField(this.convertField((StructField)f, true)));
                return (Type)group.named(field2.name());
            }
        }
        if (bl4) {
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field, inShredded)))).named(field2.name());
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            DataType x$1 = userDefinedType.sqlType();
            String x$2 = field2.copy$default$1();
            boolean x$3 = field2.copy$default$3();
            Metadata x$4 = field2.copy$default$4();
            return this.convertField(field2.copy(x$2, x$1, x$3, x$4), inShredded);
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return ((PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name())).withLogicalTypeAnnotation((LogicalTypeAnnotation)LogicalTypeAnnotation.unknownType());
        }
        throw QueryCompilationErrors$.MODULE$.cannotConvertDataTypeToParquetTypeError(field2);
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType, boolean useFieldId, boolean annotateVariantLogicalType) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        this.useFieldId = useFieldId;
        this.annotateVariantLogicalType = annotateVariantLogicalType;
    }

    public SparkToParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType(), conf.parquetFieldIdWriteEnabled(), SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$4());
    }

    public SparkToParquetSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_ANNOTATE_VARIANT_LOGICAL_TYPE().key()))));
    }
}

