/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hive.service.cli.operation.TableTypeMapping;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

public class ClassicTableTypeMapping
implements TableTypeMapping {
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(ClassicTableTypeMapping.class);
    private final Map<String, String> hiveToClientMap = new HashMap<String, String>();
    private final Map<String, List<String>> clientToHiveMap = new HashMap<String, List<String>>();

    public ClassicTableTypeMapping() {
        this.hiveToClientMap.put(TableType.MANAGED_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.EXTERNAL_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.VIRTUAL_VIEW.name(), ClassicTableTypes.VIEW.name());
        this.hiveToClientMap.put(TableType.MATERIALIZED_VIEW.toString(), ClassicTableTypes.MATERIALIZED_VIEW.toString());
        this.clientToHiveMap.put(ClassicTableTypes.TABLE.name(), List.of(TableType.MANAGED_TABLE.name(), TableType.EXTERNAL_TABLE.name()));
        this.clientToHiveMap.put(ClassicTableTypes.VIEW.name(), List.of(TableType.VIRTUAL_VIEW.name()));
        this.clientToHiveMap.put(ClassicTableTypes.MATERIALIZED_VIEW.toString(), List.of(TableType.MATERIALIZED_VIEW.toString()));
    }

    @Override
    public String[] mapToHiveType(String clientTypeName) {
        List<String> hiveTableType = this.clientToHiveMap.get(clientTypeName.toUpperCase());
        if (hiveTableType == null) {
            LOG.warn("Not supported client table type {}", new MDC[]{MDC.of((LogKey)LogKeys.TABLE_TYPE, (Object)clientTypeName)});
            return new String[]{clientTypeName};
        }
        return hiveTableType.toArray(new String[0]);
    }

    @Override
    public String mapToClientType(String hiveTypeName) {
        String clientTypeName = this.hiveToClientMap.get(hiveTypeName);
        if (clientTypeName == null) {
            LOG.warn("Invalid hive table type {}", new MDC[]{MDC.of((LogKey)LogKeys.TABLE_TYPE, (Object)hiveTypeName)});
            return hiveTypeName;
        }
        return clientTypeName;
    }

    @Override
    public Set<String> getTableTypeNames() {
        HashSet<String> typeNameSet = new HashSet<String>();
        for (ClassicTableTypes typeNames : ClassicTableTypes.values()) {
            typeNameSet.add(typeNames.name());
        }
        return typeNameSet;
    }

    public static enum ClassicTableTypes {
        TABLE,
        VIEW,
        MATERIALIZED_VIEW;

    }
}

