/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming.clickstream;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.examples.streaming.clickstream.PageView;
import org.apache.spark.examples.streaming.clickstream.PageView$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class PageViewStream$ {
    public static final PageViewStream$ MODULE$ = new PageViewStream$();

    public void main(String[] args) {
        StreamingContext ssc;
        block8: {
            if (args.length != 3) {
                System.err.println("Usage: PageViewStream <metric> <host> <port>");
                System.err.println("<metric> must be one of pageCounts, slidingPageCounts, errorRatePerZipCode, activeUserCount, popularUsersSeen");
                System.exit(1);
            }
            StreamingExamples$.MODULE$.setStreamingLogLevels();
            String metric = args[0];
            String host = args[1];
            int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2]));
            ssc = new StreamingContext("local[2]", "PageViewStream", Seconds$.MODULE$.apply(1L), System.getenv("SPARK_HOME"), Option$.MODULE$.option2Iterable(StreamingContext$.MODULE$.jarOfClass(this.getClass())).toSeq(), StreamingContext$.MODULE$.$lessinit$greater$default$6());
            DStream pageViews = ssc.socketTextStream(host, port, ssc.socketTextStream$default$3()).flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split("\n")), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable)x$2 -> PageView$.MODULE$.fromString((String)x$2), ClassTag$.MODULE$.apply(PageView.class));
            DStream qual$1 = pageViews.map((Function1 & Serializable)view -> view.url(), ClassTag$.MODULE$.apply(String.class));
            int x$12 = qual$1.countByValue$default$1();
            DStream pageCounts = qual$1.countByValue(x$12, (Ordering)Ordering.String$.MODULE$);
            DStream qual$2 = pageViews.map((Function1 & Serializable)view -> view.url(), ClassTag$.MODULE$.apply(String.class));
            Duration x$22 = Seconds$.MODULE$.apply(10L);
            Duration x$3 = Seconds$.MODULE$.apply(2L);
            int x$42 = qual$2.countByValueAndWindow$default$3();
            DStream slidingPageCounts = qual$2.countByValueAndWindow(x$22, x$3, x$42, (Ordering)Ordering.String$.MODULE$);
            DStream statusesPerZipCode = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(30L), Seconds$.MODULE$.apply(2L)).map((Function1 & Serializable)view -> new Tuple2.mcII.sp(view.zipCode(), view.status()), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey();
            DStream errorRatePerZipCode = statusesPerZipCode.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int zip = tuple2._1$mcI$sp();
                    Iterable statuses = (Iterable)tuple2._2();
                    int normalCount = statuses.count((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 == 200);
                    int errorCount = statuses.size() - normalCount;
                    float errorRatio = (float)errorCount / (float)statuses.size();
                    if ((double)errorRatio > 0.05) {
                        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s: **%s**"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)}));
                    }
                    return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)}));
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class));
            DStream activeUserCount = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(15L), Seconds$.MODULE$.apply(2L)).map((Function1 & Serializable)view -> new Tuple2.mcII.sp(view.userID(), 1), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey().count().map((Function1 & Serializable)x$4 -> PageViewStream$.$anonfun$main$9(BoxesRunTime.unboxToLong((Object)x$4)), ClassTag$.MODULE$.apply(String.class));
            SparkContext qual$3 = ssc.sparkContext();
            .colon.colon x$5 = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"Patrick Wendell"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"Reynold Xin"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"Matei Zaharia"), (List)Nil$.MODULE$)));
            int x$6 = qual$3.parallelize$default$2();
            RDD userList = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
            String string = metric;
            switch (string == null ? 0 : string.hashCode()) {
                case -925671943: {
                    if (!"errorRatePerZipCode".equals(string)) break;
                    errorRatePerZipCode.print();
                    break block8;
                }
                case 749355934: {
                    if (!"activeUserCount".equals(string)) break;
                    activeUserCount.print();
                    break block8;
                }
                case 763880833: {
                    if (!"slidingPageCounts".equals(string)) break;
                    slidingPageCounts.print();
                    break block8;
                }
                case 824555699: {
                    if (!"pageCounts".equals(string)) break;
                    pageCounts.print();
                    break block8;
                }
                case 2011553226: {
                    if (!"popularUsersSeen".equals(string)) break;
                    pageViews.map((Function1 & Serializable)view -> new Tuple2.mcII.sp(view.userID(), 1), ClassTag$.MODULE$.apply(Tuple2.class)).foreachRDD((Function2 & Serializable)(rdd, time) -> {
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(rdd, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).join(userList).map((Function1 & Serializable)x$5 -> (String)((Tuple2)x$5._2())._2(), ClassTag$.MODULE$.apply(String.class)).take(10)), (Function1 & Serializable)u -> {
                            Predef$.MODULE$.println((Object)("Saw user " + u + " at time " + time));
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    break block8;
                }
            }
            Predef$.MODULE$.println((Object)("Invalid metric entered: " + metric));
        }
        ssc.start();
        ssc.awaitTermination();
    }

    public static final /* synthetic */ String $anonfun$main$9(long x$4) {
        return "Unique active users: " + x$4;
    }

    private PageViewStream$() {
    }
}

