/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;

public class JavaLogisticRegressionSummaryExample {
    public static void main(String[] args) {
        double[] objectiveHistory;
        SparkSession spark = SparkSession.builder().appName("JavaLogisticRegressionSummaryExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        BinaryLogisticRegressionTrainingSummary trainingSummary = lrModel.binarySummary();
        for (double lossPerIteration : objectiveHistory = trainingSummary.objectiveHistory()) {
            System.out.println(lossPerIteration);
        }
        Dataset roc = trainingSummary.roc();
        roc.show();
        roc.select("FPR", new String[0]).show();
        System.out.println(trainingSummary.areaUnderROC());
        Dataset fMeasure = trainingSummary.fMeasureByThreshold();
        double maxFMeasure = ((Row)fMeasure.select(new Column[]{functions.max((String)"F-Measure")}).head()).getDouble(0);
        double bestThreshold = ((Row)fMeasure.where(fMeasure.col("F-Measure").equalTo((Object)maxFMeasure)).select("threshold", new String[0]).head()).getDouble(0);
        lrModel.setThreshold(bestThreshold);
        spark.stop();
    }
}

