/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ThreadFactory;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.network.util.TransportFrameDecoder;

public class NettyUtils {
    private static int MAX_DEFAULT_NETTY_THREADS = 8;
    private static final PooledByteBufAllocator[] _sharedPooledByteBufAllocator = new PooledByteBufAllocator[2];

    public static long freeDirectMemory() {
        return PlatformDependent.maxDirectMemory() - PlatformDependent.usedDirectMemory();
    }

    public static ThreadFactory createThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = NettyUtils.createThreadFactory(threadPrefix);
        IoHandlerFactory handlerFactory = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case IOMode.NIO -> NioIoHandler.newFactory();
            case IOMode.EPOLL -> EpollIoHandler.newFactory();
            case IOMode.KQUEUE -> KQueueIoHandler.newFactory();
            case IOMode.AUTO -> JavaUtils.isLinux && Epoll.isAvailable() ? EpollIoHandler.newFactory() : (JavaUtils.isMac && KQueue.isAvailable() ? KQueueIoHandler.newFactory() : NioIoHandler.newFactory());
        };
        return new MultiThreadIoEventLoopGroup(numThreads, threadFactory, handlerFactory);
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case IOMode.NIO -> NioSocketChannel.class;
            case IOMode.EPOLL -> EpollSocketChannel.class;
            case IOMode.KQUEUE -> KQueueSocketChannel.class;
            case IOMode.AUTO -> JavaUtils.isLinux && Epoll.isAvailable() ? EpollSocketChannel.class : (JavaUtils.isMac && KQueue.isAvailable() ? KQueueSocketChannel.class : NioSocketChannel.class);
        };
    }

    public static Class<? extends ServerChannel> getServerChannelClass(IOMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case IOMode.NIO -> NioServerSocketChannel.class;
            case IOMode.EPOLL -> EpollServerSocketChannel.class;
            case IOMode.KQUEUE -> KQueueServerSocketChannel.class;
            case IOMode.AUTO -> JavaUtils.isLinux && Epoll.isAvailable() ? EpollServerSocketChannel.class : (JavaUtils.isMac && KQueue.isAvailable() ? KQueueServerSocketChannel.class : NioServerSocketChannel.class);
        };
    }

    public static TransportFrameDecoder createFrameDecoder() {
        return new TransportFrameDecoder();
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return Math.min(availableCores, MAX_DEFAULT_NETTY_THREADS);
    }

    public static synchronized PooledByteBufAllocator getSharedPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache) {
        int index;
        int n = index = allowCache ? 0 : 1;
        if (_sharedPooledByteBufAllocator[index] == null) {
            NettyUtils._sharedPooledByteBufAllocator[index] = NettyUtils.createPooledByteBufAllocator(allowDirectBufs, allowCache, NettyUtils.defaultNumThreads(0));
        }
        return _sharedPooledByteBufAllocator[index];
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultUseCacheForAllThreads() : false);
    }

    public static boolean preferDirectBufs(TransportConf conf) {
        boolean allowDirectBufs = conf.sharedByteBufAllocators() ? conf.preferDirectBufsForSharedByteBufAllocators() : conf.preferDirectBufs();
        return allowDirectBufs && PlatformDependent.directBufferPreferred();
    }
}

