/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.AsOfTimestamp;
import org.apache.spark.sql.catalyst.analysis.AsOfVersion;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.optimizer.ComputeCurrentTime$;
import org.apache.spark.sql.catalyst.optimizer.ReplaceExpressions$;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TimeTravelSpec$ {
    public static final TimeTravelSpec$ MODULE$ = new TimeTravelSpec$();

    public Option<TimeTravelSpec> create(Option<Expression> timestamp, Option<String> version, String sessionLocalTimeZone) {
        if (timestamp.nonEmpty() && version.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidTimeTravelSpecError();
        }
        if (timestamp.nonEmpty()) {
            Expression ts = (Expression)timestamp.get();
            Predef$.MODULE$.assert(ts.resolved() && ts.references().isEmpty() && !SubqueryExpression$.MODULE$.hasSubquery(ts));
            if (!Cast$.MODULE$.canAnsiCast(ts.dataType(), (DataType)TimestampType$.MODULE$)) {
                throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel("INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT", ts);
            }
            Expression x$1 = ts;
            String x$2 = "ts";
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, "ts");
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, "ts");
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, "ts");
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, "ts");
            Project fakeProject = new Project((Seq<NamedExpression>)new .colon.colon((Object)new Alias(x$1, "ts", x$3, x$4, x$5, x$6), (List)Nil$.MODULE$), new OneRowRelation());
            Expression tsToEval = ((Alias)((Project)ComputeCurrentTime$.MODULE$.apply(ReplaceExpressions$.MODULE$.apply(fakeProject))).expressions().head()).child();
            tsToEval.foreach((Function1 & Serializable)x0$1 -> {
                TimeTravelSpec$.$anonfun$create$1(ts, x0$1);
                return BoxedUnit.UNIT;
            });
            Some tz = new Some((Object)sessionLocalTimeZone);
            Cast qual$1 = Cast$.MODULE$.apply(tsToEval, (DataType)TimestampType$.MODULE$, (Option<String>)tz, false);
            InternalRow x$7 = qual$1.eval$default$1();
            Object value = qual$1.eval(x$7);
            if (value == null) {
                throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel("INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT", ts);
            }
            return new Some((Object)new AsOfTimestamp(BoxesRunTime.unboxToLong((Object)value)));
        }
        if (version.nonEmpty()) {
            return new Some((Object)new AsOfVersion((String)version.get()));
        }
        return None$.MODULE$;
    }

    public Option<TimeTravelSpec> fromOptions(CaseInsensitiveStringMap options, String timestampKey, String versionKey, String sessionLocalTimeZone) {
        Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)options.get(timestampKey)), (Object)Option$.MODULE$.apply((Object)options.get(versionKey)));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && option2 instanceof Some) {
                throw QueryCompilationErrors$.MODULE$.invalidTimeTravelSpecError();
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String timestampStr = (String)some.value();
                if (None$.MODULE$.equals(option3)) {
                    InternalRow x$1;
                    Cast qual$1 = Cast$.MODULE$.apply((Expression)Literal$.MODULE$.apply(timestampStr), (DataType)TimestampType$.MODULE$, (Option<String>)new Some((Object)sessionLocalTimeZone), false);
                    Object timestampValue = qual$1.eval(x$1 = qual$1.eval$default$1());
                    if (timestampValue == null) {
                        throw new AnalysisException("INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.OPTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)("'" + timestampStr + "'"))})));
                    }
                    return new Some((Object)new AsOfTimestamp(BoxesRunTime.unboxToLong((Object)timestampValue)));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                String versionStr = (String)some.value();
                return new Some((Object)new AsOfVersion(versionStr));
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$create$1(Expression ts$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Unevaluable) {
            throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel("INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.UNEVALUABLE", ts$1);
        }
        if (!expression.deterministic()) {
            throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel("INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.NON_DETERMINISTIC", ts$1);
        }
    }

    private TimeTravelSpec$() {
    }
}

