/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantShortObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

class MaskTransformer
extends AbstractTransformer {
    static final int MASKED_UPPERCASE = 88;
    static final int MASKED_LOWERCASE = 120;
    static final int MASKED_DIGIT = 110;
    static final int MASKED_OTHER_CHAR = -1;
    static final int MASKED_NUMBER = 1;
    static final int MASKED_DAY_COMPONENT_VAL = 1;
    static final int MASKED_MONTH_COMPONENT_VAL = 0;
    static final int MASKED_YEAR_COMPONENT_VAL = 0;
    static final int UNMASKED_VAL = -1;
    int maskedUpperChar = 88;
    int maskedLowerChar = 120;
    int maskedDigitChar = 110;
    int maskedOtherChar = -1;
    int maskedNumber = 1;
    int maskedDayValue = 1;
    int maskedMonthValue = 0;
    int maskedYearValue = 0;

    @Override
    public void init(ObjectInspector[] arguments, int startIdx) {
        int idx = startIdx;
        this.maskedUpperChar = this.getCharArg(arguments, idx++, 88);
        this.maskedLowerChar = this.getCharArg(arguments, idx++, 120);
        this.maskedDigitChar = this.getCharArg(arguments, idx++, 110);
        this.maskedOtherChar = this.getCharArg(arguments, idx++, -1);
        this.maskedNumber = this.getIntArg(arguments, idx++, 1);
        this.maskedDayValue = this.getIntArg(arguments, idx++, 1);
        this.maskedMonthValue = this.getIntArg(arguments, idx++, 0);
        this.maskedYearValue = this.getIntArg(arguments, idx++, 0);
        if (this.maskedNumber < 0 || this.maskedNumber > 9) {
            this.maskedNumber = 1;
        }
        if (this.maskedDayValue != -1 && (this.maskedDayValue < 1 || this.maskedDayValue > 31)) {
            this.maskedDayValue = 1;
        }
        if (this.maskedMonthValue != -1 && (this.maskedMonthValue < 0 || this.maskedMonthValue > 11)) {
            this.maskedMonthValue = 0;
        }
    }

    @Override
    String transform(String val) {
        StringBuilder ret = new StringBuilder(val.length());
        for (int i = 0; i < val.length(); ++i) {
            ret.appendCodePoint(this.transformChar(val.charAt(i)));
        }
        return ret.toString();
    }

    @Override
    Byte transform(Byte value) {
        byte val = value;
        if (value < 0) {
            val = (byte)(val * -1);
        }
        byte ret = 0;
        int pos = 1;
        while (val != 0) {
            ret = (byte)(ret + this.maskedNumber * pos);
            val = (byte)(val / 10);
            pos *= 10;
        }
        if (value < 0) {
            ret = (byte)(ret * -1);
        }
        return ret;
    }

    @Override
    Short transform(Short value) {
        short val = value;
        if (value < 0) {
            val = (short)(val * -1);
        }
        short ret = 0;
        int pos = 1;
        while (val != 0) {
            ret = (short)(ret + this.maskedNumber * pos);
            val = (short)(val / 10);
            pos *= 10;
        }
        if (value < 0) {
            ret = (short)(ret * -1);
        }
        return ret;
    }

    @Override
    Integer transform(Integer value) {
        int val = value;
        if (value < 0) {
            val *= -1;
        }
        int ret = 0;
        int pos = 1;
        while (val != 0) {
            ret += this.maskedNumber * pos;
            val /= 10;
            pos *= 10;
        }
        if (value < 0) {
            ret *= -1;
        }
        return ret;
    }

    @Override
    Long transform(Long value) {
        long val = value;
        if (value < 0L) {
            val *= -1L;
        }
        long ret = 0L;
        long pos = 1L;
        int i = 0;
        while (val != 0L) {
            ret += (long)this.maskedNumber * pos;
            val /= 10L;
            pos *= 10L;
            ++i;
        }
        if (value < 0L) {
            ret *= -1L;
        }
        return ret;
    }

    @Override
    Date transform(Date value) {
        int year = this.maskedYearValue == -1 ? value.getYear() : this.maskedYearValue;
        int month = this.maskedMonthValue == -1 ? value.getMonth() : this.maskedMonthValue;
        int day = this.maskedDayValue == -1 ? value.getDate() : this.maskedDayValue;
        return new Date(year, month, day);
    }

    protected int transformChar(int c) {
        switch (Character.getType(c)) {
            case 1: {
                if (this.maskedUpperChar == -1) break;
                return this.maskedUpperChar;
            }
            case 2: {
                if (this.maskedLowerChar == -1) break;
                return this.maskedLowerChar;
            }
            case 9: {
                if (this.maskedDigitChar == -1) break;
                return this.maskedDigitChar;
            }
            default: {
                if (this.maskedOtherChar == -1) break;
                return this.maskedOtherChar;
            }
        }
        return c;
    }

    int getCharArg(ObjectInspector[] arguments, int index, int defaultValue) {
        ObjectInspector arg;
        int ret = defaultValue;
        ObjectInspector objectInspector = arg = arguments != null && arguments.length > index ? arguments[index] : null;
        if (arg != null) {
            String strValue;
            Object value;
            if (arg instanceof WritableConstantIntObjectInspector) {
                IntWritable value2 = ((WritableConstantIntObjectInspector)arg).getWritableConstantValue();
                if (value2 != null) {
                    ret = value2.get();
                }
            } else if (arg instanceof WritableConstantLongObjectInspector) {
                LongWritable value3 = ((WritableConstantLongObjectInspector)arg).getWritableConstantValue();
                if (value3 != null) {
                    ret = (int)value3.get();
                }
            } else if (arg instanceof WritableConstantShortObjectInspector) {
                ShortWritable value4 = ((WritableConstantShortObjectInspector)arg).getWritableConstantValue();
                if (value4 != null) {
                    ret = value4.get();
                }
            } else if (arg instanceof ConstantObjectInspector && (value = ((ConstantObjectInspector)arg).getWritableConstantValue()) != null && (strValue = value.toString()) != null && strValue.length() > 0) {
                ret = strValue.charAt(0);
            }
        }
        return ret;
    }

    int getIntArg(ObjectInspector[] arguments, int index, int defaultValue) {
        ObjectInspector arg;
        int ret = defaultValue;
        ObjectInspector objectInspector = arg = arguments != null && arguments.length > index ? arguments[index] : null;
        if (arg != null) {
            String strValue;
            Object value;
            if (arg instanceof WritableConstantIntObjectInspector) {
                IntWritable value2 = ((WritableConstantIntObjectInspector)arg).getWritableConstantValue();
                if (value2 != null) {
                    ret = value2.get();
                }
            } else if (arg instanceof WritableConstantLongObjectInspector) {
                LongWritable value3 = ((WritableConstantLongObjectInspector)arg).getWritableConstantValue();
                if (value3 != null) {
                    ret = (int)value3.get();
                }
            } else if (arg instanceof WritableConstantShortObjectInspector) {
                ShortWritable value4 = ((WritableConstantShortObjectInspector)arg).getWritableConstantValue();
                if (value4 != null) {
                    ret = value4.get();
                }
            } else if (arg instanceof ConstantObjectInspector && (value = ((ConstantObjectInspector)arg).getWritableConstantValue()) != null && (strValue = value.toString()) != null && strValue.length() > 0) {
                ret = Integer.parseInt(value.toString());
            }
        }
        return ret;
    }
}

