/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRand;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRandNoSeed;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="rand", value="_FUNC_([seed]) - Returns a pseudorandom number between 0 and 1")
@UDFType(deterministic=false)
@VectorizedExpressions(value={FuncRandNoSeed.class, FuncRand.class})
public class UDFRand
extends UDF {
    private Random random;
    private final DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate() {
        if (this.random == null) {
            this.random = new Random();
        }
        this.result.set(this.random.nextDouble());
        return this.result;
    }

    public DoubleWritable evaluate(LongWritable seed) {
        if (this.random == null) {
            long seedValue = 0L;
            if (seed != null) {
                seedValue = seed.get();
            }
            this.random = new Random(seedValue);
        }
        this.result.set(this.random.nextDouble());
        return this.result;
    }
}

