/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;

public final class ColumnarMap
extends MapData {
    private final ColumnarArray keys;
    private final ColumnarArray values;
    private final int length;

    public ColumnarMap(ColumnVector keys, ColumnVector values, int offset, int length) {
        this.length = length;
        this.keys = new ColumnarArray(keys, offset, length);
        this.values = new ColumnarArray(values, offset, length);
    }

    @Override
    public int numElements() {
        return this.length;
    }

    @Override
    public ColumnarArray keyArray() {
        return this.keys;
    }

    @Override
    public ColumnarArray valueArray() {
        return this.values;
    }

    @Override
    public MapData copy() {
        return new ArrayBasedMapData(this.keys.copy(), this.values.copy());
    }
}

