/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.UnifiedMemoryManager;
import org.apache.spark.memory.UnmanagedMemoryConsumer;
import org.apache.spark.memory.UnmanagedMemoryConsumerId;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class UnifiedMemoryManager$
implements Logging {
    public static final UnifiedMemoryManager$ MODULE$ = new UnifiedMemoryManager$();
    private static final int RESERVED_SYSTEM_MEMORY_BYTES;
    private static final ConcurrentHashMap<UnmanagedMemoryConsumerId, UnmanagedMemoryConsumer> unmanagedMemoryConsumers;
    private static final AtomicLong org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed;
    private static final AtomicLong org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed;
    private static final AtomicBoolean pollingStarted;
    private static volatile ScheduledExecutorService unmanagedMemoryPoller;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        RESERVED_SYSTEM_MEMORY_BYTES = 314572800;
        unmanagedMemoryConsumers = new ConcurrentHashMap();
        org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed = new AtomicLong(0L);
        org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed = new AtomicLong(0L);
        pollingStarted = new AtomicBoolean(false);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return RESERVED_SYSTEM_MEMORY_BYTES;
    }

    private ConcurrentHashMap<UnmanagedMemoryConsumerId, UnmanagedMemoryConsumer> unmanagedMemoryConsumers() {
        return unmanagedMemoryConsumers;
    }

    public AtomicLong org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed() {
        return org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed;
    }

    public AtomicLong org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed() {
        return org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed;
    }

    private AtomicBoolean pollingStarted() {
        return pollingStarted;
    }

    public long getUnmanagedMemoryUsed() {
        return this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed().get() + this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed().get();
    }

    public void registerUnmanagedMemoryConsumer(UnmanagedMemoryConsumer unmanagedMemoryConsumer) {
        UnmanagedMemoryConsumerId id = unmanagedMemoryConsumer.unmanagedMemoryConsumerId();
        this.unmanagedMemoryConsumers().put(id, unmanagedMemoryConsumer);
    }

    public void unregisterUnmanagedMemoryConsumer(UnmanagedMemoryConsumer unmanagedMemoryConsumer) {
        UnmanagedMemoryConsumerId id = unmanagedMemoryConsumer.unmanagedMemoryConsumerId();
        this.unmanagedMemoryConsumers().remove(id);
    }

    public long getMemoryByComponentType(String componentType) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.unmanagedMemoryConsumers()).asScala().values().toSeq().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UnifiedMemoryManager$.$anonfun$getMemoryByComponentType$1(componentType, x$3)))).map((Function1 & Serializable)memoryUser -> BoxesRunTime.boxToLong((long)UnifiedMemoryManager$.$anonfun$getMemoryByComponentType$2(memoryUser)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void clearUnmanagedMemoryUsers() {
        this.unmanagedMemoryConsumers().clear();
        this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed().set(0L);
        this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed().set(0L);
    }

    private ScheduledExecutorService unmanagedMemoryPoller() {
        return unmanagedMemoryPoller;
    }

    private void unmanagedMemoryPoller_$eq(ScheduledExecutorService x$1) {
        unmanagedMemoryPoller = x$1;
    }

    public void startPollingIfNeeded(long pollingIntervalMs) {
        if (this.pollingStarted().compareAndSet(false, true)) {
            this.unmanagedMemoryPoller_$eq(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("unmanaged-memory-poller"));
            Runnable pollingTask = new Runnable(){

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$pollUnmanagedMemoryUsers());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
                }
            };
            this.unmanagedMemoryPoller().scheduleAtFixedRate(pollingTask, 0L, pollingIntervalMs, TimeUnit.MILLISECONDS);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unmanaged memory polling started with interval "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME, BoxesRunTime.boxToLong((long)pollingIntervalMs))})))));
            return;
        }
    }

    public void org$apache$spark$memory$UnifiedMemoryManager$$pollUnmanagedMemoryUsers() {
        scala.collection.immutable.Map consumers = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.unmanagedMemoryConsumers()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable memoryUsages = (Iterable)consumers.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple3 tuple3;
                UnmanagedMemoryConsumerId userId = (UnmanagedMemoryConsumerId)tuple2._1();
                UnmanagedMemoryConsumer memoryUser = (UnmanagedMemoryConsumer)tuple2._2();
                try {
                    long memoryUsed = memoryUser.getMemBytesUsed();
                    if (memoryUsed == -1L) {
                        MODULE$.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unmanaged memory consumer ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.OBJECT_ID, userId.toString())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"is no longer active, marking for removal"}))).log((Seq)Nil$.MODULE$))));
                        tuple3 = new Tuple3((Object)userId, (Object)memoryUser, (Object)None$.MODULE$);
                    } else if (memoryUsed < 0L) {
                        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid memory usage value ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)memoryUsed))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from unmanaged memory user ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.OBJECT_ID, userId.toString())})))));
                        tuple3 = new Tuple3((Object)userId, (Object)memoryUser, (Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
                    } else {
                        tuple3 = new Tuple3((Object)userId, (Object)memoryUser, (Object)new Some((Object)BoxesRunTime.boxToLong((long)memoryUsed)));
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get memory usage for unmanaged memory user "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.OBJECT_ID, userId.toString()), MODULE$.MDC((LogKey)LogKeys.EXCEPTION, throwable2)})))));
                        tuple3 = new Tuple3((Object)userId, (Object)memoryUser, (Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
                    }
                    throw throwable;
                }
                return tuple3;
            }
            throw new MatchError((Object)tuple2);
        });
        ((IterableOnceOps)memoryUsages.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$5(x$5)))).foreach((Function1 & Serializable)x0$2 -> {
            UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$6(x0$2);
            return BoxedUnit.UNIT;
        });
        Iterable activeUsages = (Iterable)memoryUsages.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$8(x$6)));
        long onHeapTotal = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)activeUsages.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$9(x$7)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$10(x$8)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long offHeapTotal = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)activeUsages.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$11(x$9)))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)UnifiedMemoryManager$.$anonfun$pollUnmanagedMemoryUsers$12(x$10)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed().set(onHeapTotal);
        this.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed().set(offHeapTotal);
        long totalMemoryUsed = onHeapTotal + offHeapTotal;
        int numConsumers = activeUsages.size();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Unmanaged memory polling completed: " + numConsumers + " consumers, total memory used: " + totalMemoryUsed + " bytes (on-heap: " + onHeapTotal + ", off-heap: " + offHeapTotal + ")");
    }

    public synchronized void shutdownUnmanagedMemoryPoller() {
        if (this.unmanagedMemoryPoller() != null) {
            Object object;
            this.unmanagedMemoryPoller().shutdown();
            try {
                object = !this.unmanagedMemoryPoller().awaitTermination(5L, TimeUnit.SECONDS) ? this.unmanagedMemoryPoller().shutdownNow() : BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                object = BoxedUnit.UNIT;
            }
            this.unmanagedMemoryPoller_$eq(null);
            this.pollingStarted().set(false);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unmanaged memory poller shutdown complete"}))).log((Seq)Nil$.MODULE$)));
            return;
        }
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_STORAGE_FRACTION()))), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long executorMemory;
        long reservedMemory;
        long minSystemMemory;
        long systemMemory = BoxesRunTime.unboxToLong((Object)conf.get(Tests$.MODULE$.TEST_MEMORY()));
        if (systemMemory < (minSystemMemory = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(reservedMemory = conf.getLong(Tests$.MODULE$.TEST_RESERVED_MEMORY().key(), conf.contains((ConfigEntry<?>)Tests$.MODULE$.IS_TESTING()) ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)))) {
            throw new SparkIllegalArgumentException("INVALID_DRIVER_MEMORY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"systemMemory"), (Object)Long.toString(systemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minSystemMemory"), (Object)Long.toString(minSystemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)package$.MODULE$.DRIVER_MEMORY().key())})));
        }
        if (conf.contains(package$.MODULE$.EXECUTOR_MEMORY()) && (executorMemory = conf.getSizeAsBytes(package$.MODULE$.EXECUTOR_MEMORY().key())) < minSystemMemory) {
            throw new SparkIllegalArgumentException("INVALID_EXECUTOR_MEMORY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorMemory"), (Object)Long.toString(executorMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minSystemMemory"), (Object)Long.toString(minSystemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)package$.MODULE$.EXECUTOR_MEMORY().key())})));
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_FRACTION()));
        return (long)((double)usableMemory * memoryFraction);
    }

    public static final /* synthetic */ boolean $anonfun$getMemoryByComponentType$1(String componentType$1, UnmanagedMemoryConsumer x$3) {
        String string = x$3.unmanagedMemoryConsumerId().componentType();
        String string2 = componentType$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$getMemoryByComponentType$2(UnmanagedMemoryConsumer memoryUser) {
        long l;
        try {
            l = memoryUser.getMemBytesUsed();
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$pollUnmanagedMemoryUsers$5(Tuple3 x$5) {
        return ((Option)x$5._3()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$pollUnmanagedMemoryUsers$6(Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            UnmanagedMemoryConsumerId userId = (UnmanagedMemoryConsumerId)tuple3._1();
            MODULE$.unmanagedMemoryConsumers().remove(userId);
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed inactive unmanaged memory consumer "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.OBJECT_ID, userId.toString())})))));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$pollUnmanagedMemoryUsers$8(Tuple3 x$6) {
        return ((Option)x$6._3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$pollUnmanagedMemoryUsers$9(Tuple3 x$7) {
        MemoryMode memoryMode = ((UnmanagedMemoryConsumer)x$7._2()).memoryMode();
        MemoryMode memoryMode2 = MemoryMode.ON_HEAP;
        return !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null);
    }

    public static final /* synthetic */ long $anonfun$pollUnmanagedMemoryUsers$10(Tuple3 x$8) {
        return BoxesRunTime.unboxToLong((Object)((Option)x$8._3()).get());
    }

    public static final /* synthetic */ boolean $anonfun$pollUnmanagedMemoryUsers$11(Tuple3 x$9) {
        MemoryMode memoryMode = ((UnmanagedMemoryConsumer)x$9._2()).memoryMode();
        MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
        return !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null);
    }

    public static final /* synthetic */ long $anonfun$pollUnmanagedMemoryUsers$12(Tuple3 x$10) {
        return BoxesRunTime.unboxToLong((Object)((Option)x$10._3()).get());
    }

    private UnifiedMemoryManager$() {
    }
}

