/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class UploadBlockStream
extends BlockTransferMessage {
    public final String blockId;
    public final byte[] metadata;

    public UploadBlockStream(String blockId, byte[] metadata) {
        this.blockId = blockId;
        this.metadata = metadata;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.UPLOAD_BLOCK_STREAM;
    }

    public int hashCode() {
        int objectsHashCode = Objects.hashCode(this.blockId);
        return objectsHashCode * 41 + Arrays.hashCode(this.metadata);
    }

    public String toString() {
        return "UploadBlockStream[blockId=" + this.blockId + ",metadata size=" + this.metadata.length + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof UploadBlockStream) {
            UploadBlockStream o = (UploadBlockStream)other;
            return Objects.equals(this.blockId, o.blockId) && Arrays.equals(this.metadata, o.metadata);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.blockId) + Encoders.ByteArrays.encodedLength((byte[])this.metadata);
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.blockId);
        Encoders.ByteArrays.encode((ByteBuf)buf, (byte[])this.metadata);
    }

    public static UploadBlockStream decode(ByteBuf buf) {
        String blockId = Encoders.Strings.decode((ByteBuf)buf);
        byte[] metadata = Encoders.ByteArrays.decode((ByteBuf)buf);
        return new UploadBlockStream(blockId, metadata);
    }
}

