/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex.impl;

import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.vector.ViewVarCharVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import org.sparkproject.org.apache.arrow.vector.holders.NullableViewVarCharHolder;
import org.sparkproject.org.apache.arrow.vector.holders.ViewVarCharHolder;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.util.Text;

public class ViewVarCharWriterImpl
extends AbstractFieldWriter {
    final ViewVarCharVector vector;
    private final Text textBuffer = new Text();

    public ViewVarCharWriterImpl(ViewVarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(ViewVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableViewVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeViewVarChar(int start, int end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeViewVarChar(Text value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeViewVarChar(String value) {
        this.textBuffer.set(value);
        this.vector.setSafe(this.idx(), this.textBuffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

