/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector;

import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.memory.util.Float16;
import org.sparkproject.org.apache.arrow.vector.BaseFixedWidthVector;
import org.sparkproject.org.apache.arrow.vector.BitVectorHelper;
import org.sparkproject.org.apache.arrow.vector.FloatingPointVector;
import org.sparkproject.org.apache.arrow.vector.NullCheckingForGet;
import org.sparkproject.org.apache.arrow.vector.ValueIterableVector;
import org.sparkproject.org.apache.arrow.vector.ValueVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.Float2ReaderImpl;
import org.sparkproject.org.apache.arrow.vector.complex.reader.FieldReader;
import org.sparkproject.org.apache.arrow.vector.holders.Float2Holder;
import org.sparkproject.org.apache.arrow.vector.holders.NullableFloat2Holder;
import org.sparkproject.org.apache.arrow.vector.types.Types;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.types.pojo.FieldType;
import org.sparkproject.org.apache.arrow.vector.util.TransferPair;

public final class Float2Vector
extends BaseFixedWidthVector
implements FloatingPointVector,
ValueIterableVector<Short> {
    public static final byte TYPE_WIDTH = 2;

    public Float2Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.FLOAT2.getType()), allocator);
    }

    public Float2Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public Float2Vector(Field field, BufferAllocator allocator) {
        super(field, allocator, 2);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new Float2ReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FLOAT2;
    }

    public short get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getShort((long)index * 2L);
    }

    public void get(int index, NullableFloat2Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getShort((long)index * 2L);
    }

    @Override
    public Short getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getShort((long)index * 2L);
    }

    static short get(ArrowBuf buffer, int index) {
        return buffer.getShort((long)index * 2L);
    }

    @Override
    public double getValueAsDouble(int index) {
        return this.getValueAsFloat(index);
    }

    public float getValueAsFloat(int index) {
        return Float16.toFloat(this.get(index));
    }

    private void setValue(int index, short value) {
        this.valueBuffer.setShort((long)index * 2L, value);
    }

    private void setValue(int index, float value) {
        this.valueBuffer.setShort((long)index * 2L, Float16.toFloat16(value));
    }

    public void set(int index, short value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void setWithPossibleTruncate(int index, float value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableFloat2Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, Float2Holder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, short value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafeWithPossibleTruncate(int index, float value) {
        this.handleSafe(index);
        this.setWithPossibleTruncate(index, value);
    }

    public void setSafe(int index, NullableFloat2Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, Float2Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, short value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setWithPossibleTruncate(int index, int isSet, float value) {
        if (isSet > 0) {
            this.setWithPossibleTruncate(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, short value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public void setSafeWithPossibleTruncate(int index, int isSet, float value) {
        this.handleSafe(index);
        this.setWithPossibleTruncate(index, isSet, value);
    }

    @Override
    public void setWithPossibleTruncate(int index, double value) {
        throw new UnsupportedOperationException("The operation for double data types is not supported.");
    }

    @Override
    public void setSafeWithPossibleTruncate(int index, double value) {
        throw new UnsupportedOperationException("The operation for double data types is not supported.");
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Float2Vector)to);
    }

    private class TransferImpl
    implements TransferPair {
        Float2Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new Float2Vector(ref, Float2Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new Float2Vector(field, allocator);
        }

        public TransferImpl(Float2Vector to) {
            this.to = to;
        }

        @Override
        public Float2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Float2Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Float2Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Float2Vector.this);
        }
    }
}

