/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExpressionEvalUtils$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalGeographyType;
import org.apache.spark.sql.catalyst.types.PhysicalGeometryType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.GeographyVal;
import org.apache.spark.unsafe.types.GeometryVal;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Literal$
implements Serializable {
    public static final Literal$ MODULE$ = new Literal$();
    private static final Literal TrueLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
    private static final Literal FalseLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$);

    public Literal TrueLiteral() {
        return TrueLiteral;
    }

    public Literal FalseLiteral() {
        return FalseLiteral;
    }

    public Literal apply(Object v) {
        Object object;
        while (true) {
            if ((object = v) instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return new Literal(BoxesRunTime.boxToInteger((int)n), (DataType)IntegerType$.MODULE$);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return new Literal(BoxesRunTime.boxToLong((long)l), (DataType)LongType$.MODULE$);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return new Literal(BoxesRunTime.boxToDouble((double)d), (DataType)DoubleType$.MODULE$);
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return new Literal(BoxesRunTime.boxToFloat((float)f), (DataType)FloatType$.MODULE$);
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                return new Literal(BoxesRunTime.boxToByte((byte)by), (DataType)ByteType$.MODULE$);
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                return new Literal(BoxesRunTime.boxToShort((short)s), (DataType)ShortType$.MODULE$);
            }
            if (object instanceof String) {
                String string = (String)object;
                return new Literal(UTF8String.fromString((String)string), (DataType)StringType$.MODULE$);
            }
            if (object instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)object;
                return new Literal(uTF8String, (DataType)StringType$.MODULE$);
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                return new Literal(UTF8String.fromString((String)Character.toString(c)), (DataType)StringType$.MODULE$);
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return new Literal(UTF8String.fromString((String)String.valueOf(cArray)), (DataType)StringType$.MODULE$);
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return new Literal(BoxesRunTime.boxToBoolean((boolean)bl), (DataType)BooleanType$.MODULE$);
            }
            if (object instanceof scala.math.BigDecimal) {
                scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
                Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                return new Literal(decimal, (DataType)DecimalType$.MODULE$.fromDecimal(decimal));
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                return new Literal(decimal, (DataType)DecimalType$.MODULE$.fromDecimal(decimal));
            }
            if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                return new Literal(decimal, (DataType)new DecimalType(Math.max(decimal.precision(), decimal.scale()), decimal.scale()));
            }
            if (object instanceof Instant) {
                Instant instant = (Instant)object;
                return new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), (DataType)TimestampType$.MODULE$);
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                return new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp)), (DataType)TimestampType$.MODULE$);
            }
            if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                return new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime)), (DataType)TimestampNTZType$.MODULE$);
            }
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                return new Literal(BoxesRunTime.boxToInteger((int)((int)localDate.toEpochDay())), (DataType)DateType$.MODULE$);
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                return new Literal(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)), (DataType)DateType$.MODULE$);
            }
            if (object instanceof LocalTime) {
                LocalTime localTime = (LocalTime)object;
                return new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localTimeToNanos(localTime)), (DataType)TimeType$.MODULE$.apply());
            }
            if (object instanceof Duration) {
                Duration duration = (Duration)object;
                return new Literal(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(duration)), (DataType)DayTimeIntervalType$.MODULE$.apply());
            }
            if (object instanceof Period) {
                Period period = (Period)object;
                return new Literal(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(period)), (DataType)YearMonthIntervalType$.MODULE$.apply());
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return new Literal(byArray, (DataType)BinaryType$.MODULE$);
            }
            if (object instanceof scala.collection.mutable.ArraySeq) {
                scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)object;
                v = arraySeq.array();
                continue;
            }
            if (!(object instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)object;
            v = arraySeq.unsafeArray();
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            DataType elementType = this.componentTypeToDataType(object2.getClass().getComponentType());
            ArrayType dataType = ArrayType$.MODULE$.apply(elementType);
            Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)dataType);
            return new Literal(convert.apply(object2), (DataType)dataType);
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return new Literal(calendarInterval, (DataType)CalendarIntervalType$.MODULE$);
        }
        if (object instanceof VariantVal) {
            VariantVal variantVal = (VariantVal)object;
            return new Literal(variantVal, (DataType)VariantType$.MODULE$);
        }
        if (object == null) {
            return new Literal(null, (DataType)NullType$.MODULE$);
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return literal;
        }
        throw QueryExecutionErrors$.MODULE$.literalTypeUnsupportedError(v);
    }

    private DataType componentTypeToDataType(Class<?> clz) {
        Class<?> clazz = clz;
        Class<Short> clazz2 = Short.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return ShortType$.MODULE$;
        }
        Class<Integer> clazz4 = Integer.TYPE;
        Class<?> clazz5 = clazz;
        if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
            return IntegerType$.MODULE$;
        }
        Class<Long> clazz6 = Long.TYPE;
        Class<?> clazz7 = clazz;
        if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
            return LongType$.MODULE$;
        }
        Class<Double> clazz8 = Double.TYPE;
        Class<?> clazz9 = clazz;
        if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
            return DoubleType$.MODULE$;
        }
        Class<Byte> clazz10 = Byte.TYPE;
        Class<?> clazz11 = clazz;
        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
            return ByteType$.MODULE$;
        }
        Class<Float> clazz12 = Float.TYPE;
        Class<?> clazz13 = clazz;
        if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
            return FloatType$.MODULE$;
        }
        Class<Boolean> clazz14 = Boolean.TYPE;
        Class<?> clazz15 = clazz;
        if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
            return BooleanType$.MODULE$;
        }
        Class<Character> clazz16 = Character.TYPE;
        Class<?> clazz17 = clazz;
        if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz18 = clz;
        Class<LocalDate> clazz19 = LocalDate.class;
        if (!(clazz18 != null ? !clazz18.equals(clazz19) : clazz19 != null)) {
            return DateType$.MODULE$;
        }
        Class<?> clazz20 = clz;
        Class<Date> clazz21 = Date.class;
        if (!(clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null)) {
            return DateType$.MODULE$;
        }
        Class<?> clazz22 = clz;
        Class<LocalTime> clazz23 = LocalTime.class;
        if (!(clazz22 != null ? !clazz22.equals(clazz23) : clazz23 != null)) {
            return TimeType$.MODULE$.apply();
        }
        Class<?> clazz24 = clz;
        Class<Instant> clazz25 = Instant.class;
        if (!(clazz24 != null ? !clazz24.equals(clazz25) : clazz25 != null)) {
            return TimestampType$.MODULE$;
        }
        Class<?> clazz26 = clz;
        Class<Timestamp> clazz27 = Timestamp.class;
        if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null)) {
            return TimestampType$.MODULE$;
        }
        Class<?> clazz28 = clz;
        Class<LocalDateTime> clazz29 = LocalDateTime.class;
        if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
            return TimestampNTZType$.MODULE$;
        }
        Class<?> clazz30 = clz;
        Class<Duration> clazz31 = Duration.class;
        if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
            return DayTimeIntervalType$.MODULE$.apply();
        }
        Class<?> clazz32 = clz;
        Class<Period> clazz33 = Period.class;
        if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
            return YearMonthIntervalType$.MODULE$.apply();
        }
        Class<?> clazz34 = clz;
        Class<BigDecimal> clazz35 = BigDecimal.class;
        if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz36 = clz;
        Class<byte[]> clazz37 = byte[].class;
        if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
            return BinaryType$.MODULE$;
        }
        Class<?> clazz38 = clz;
        Class<char[]> clazz39 = char[].class;
        if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz40 = clz;
        Class<Short> clazz41 = Short.class;
        if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
            return ShortType$.MODULE$;
        }
        Class<?> clazz42 = clz;
        Class<Integer> clazz43 = Integer.class;
        if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
            return IntegerType$.MODULE$;
        }
        Class<?> clazz44 = clz;
        Class<Long> clazz45 = Long.class;
        if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
            return LongType$.MODULE$;
        }
        Class<?> clazz46 = clz;
        Class<Double> clazz47 = Double.class;
        if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
            return DoubleType$.MODULE$;
        }
        Class<?> clazz48 = clz;
        Class<Byte> clazz49 = Byte.class;
        if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
            return ByteType$.MODULE$;
        }
        Class<?> clazz50 = clz;
        Class<Float> clazz51 = Float.class;
        if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
            return FloatType$.MODULE$;
        }
        Class<?> clazz52 = clz;
        Class<Boolean> clazz53 = Boolean.class;
        if (!(clazz52 != null ? !clazz52.equals(clazz53) : clazz53 != null)) {
            return BooleanType$.MODULE$;
        }
        Class<?> clazz54 = clz;
        Class<String> clazz55 = String.class;
        if (!(clazz54 != null ? !clazz54.equals(clazz55) : clazz55 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz56 = clz;
        Class<BigInt> clazz57 = BigInt.class;
        if (!(clazz56 != null ? !clazz56.equals(clazz57) : clazz57 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz58 = clz;
        Class<scala.math.BigDecimal> clazz59 = scala.math.BigDecimal.class;
        if (!(clazz58 != null ? !clazz58.equals(clazz59) : clazz59 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz60 = clz;
        Class<CalendarInterval> clazz61 = CalendarInterval.class;
        if (!(clazz60 != null ? !clazz60.equals(clazz61) : clazz61 != null)) {
            return CalendarIntervalType$.MODULE$;
        }
        Class<?> clazz62 = clz;
        Class<VariantVal> clazz63 = VariantVal.class;
        if (!(clazz62 != null ? !clazz62.equals(clazz63) : clazz63 != null)) {
            return VariantType$.MODULE$;
        }
        if (clz.isArray()) {
            return ArrayType$.MODULE$.apply(this.componentTypeToDataType(clz.getComponentType()));
        }
        throw QueryCompilationErrors$.MODULE$.arrayComponentTypeUnsupportedError(clz);
    }

    public Literal fromObject(Object obj, DataType objType) {
        return new Literal(obj, objType);
    }

    public Literal fromObject(Object obj) {
        return new Literal(obj, (DataType)new ObjectType(obj.getClass()));
    }

    public Literal create(Object v, DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof YearMonthIntervalType && v instanceof Period) {
            return new Literal(CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType).apply(v), dataType);
        }
        if (dataType2 instanceof DayTimeIntervalType && v instanceof Duration) {
            return new Literal(CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType).apply(v), dataType);
        }
        if (dataType2 instanceof ObjectType) {
            return new Literal(v, dataType);
        }
        if ((dataType2 instanceof CharType ? true : dataType2 instanceof VarcharType) && SQLConf$.MODULE$.get().preserveCharVarcharTypeInfo()) {
            return new Literal(CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType).apply(v), dataType);
        }
        return new Literal(CatalystTypeConverters$.MODULE$.convertToCatalyst(v), dataType);
    }

    public <T> Literal create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Literal)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            DataType dataType = schema.dataType();
            DataType dataType2 = dataType;
            Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType2);
            return new Literal(convert.apply(v), dataType2);
        }).getOrElse((Function0 & Serializable)() -> MODULE$.apply(v));
    }

    public Literal default(DataType dataType) {
        DataType dataType2 = dataType;
        if (NullType$.MODULE$.equals(dataType2)) {
            return this.create(null, (DataType)NullType$.MODULE$);
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToByte((byte)((byte)0)));
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToShort((short)((short)0)));
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToInteger((int)0));
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToLong((long)0L));
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToFloat((float)0.0f));
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return this.apply(BoxesRunTime.boxToDouble((double)0.0));
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return this.apply(Decimal$.MODULE$.apply(0L, decimalType.precision(), decimalType.scale()));
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return this.create(BoxesRunTime.boxToInteger((int)0), (DataType)DateType$.MODULE$);
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return this.create(BoxesRunTime.boxToLong((long)0L), (DataType)TimestampType$.MODULE$);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            return this.create(BoxesRunTime.boxToLong((long)0L), (DataType)TimestampNTZType$.MODULE$);
        }
        if (dataType2 instanceof TimeType) {
            TimeType timeType = (TimeType)dataType2;
            return this.create(BoxesRunTime.boxToLong((long)0L), (DataType)timeType);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            return this.create(BoxesRunTime.boxToLong((long)0L), (DataType)dayTimeIntervalType);
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            return this.create(BoxesRunTime.boxToInteger((int)0), (DataType)yearMonthIntervalType);
        }
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            int length = charType.length();
            return this.create(CharVarcharCodegenUtils.charTypeWriteSideCheck(UTF8String.fromString((String)""), length), dataType);
        }
        if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            int length = varcharType.length();
            return this.create(CharVarcharCodegenUtils.varcharTypeWriteSideCheck(UTF8String.fromString((String)""), length), dataType);
        }
        if (dataType2 instanceof StringType) {
            StringType stringType = (StringType)dataType2;
            return new Literal(UTF8String.fromString((String)""), (DataType)stringType);
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return this.apply("".getBytes(StandardCharsets.UTF_8));
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            return this.apply(new CalendarInterval(0, 0, 0L));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            return this.create(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()), (DataType)arrayType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            return this.create(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (DataType)mapType);
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return this.create(new GenericInternalRow((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> MODULE$.default(f.dataType()).value(), ClassTag$.MODULE$.Any())), (DataType)structType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return new Literal(this.default(userDefinedType.sqlType()).value(), (DataType)userDefinedType);
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            return this.create(VariantExpressionEvalUtils$.MODULE$.castToVariant(BoxesRunTime.boxToInteger((int)0), (DataType)IntegerType$.MODULE$), (DataType)VariantType$.MODULE$);
        }
        throw QueryExecutionErrors$.MODULE$.noDefaultForDataTypeError(dataType);
    }

    public void validateLiteralValue(Object value, DataType dataType) {
        Predef$.MODULE$.require(this.doValidate$1(value, dataType), (Function0 & Serializable)() -> "Literal must have a corresponding value to " + dataType.catalogString() + ", but class " + Utils$.MODULE$.getSimpleName(value.getClass()) + " found.");
    }

    public Expression fromSQL(String sql2) {
        return (Expression)CatalystSqlParser$.MODULE$.parseExpression(sql2).transformUp(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnresolvedFunction) {
                    UnresolvedFunction unresolvedFunction = (UnresolvedFunction)A1;
                    Predef$.MODULE$.assert(unresolvedFunction.nameParts().length() == 1);
                    Predef$.MODULE$.assert(!unresolvedFunction.isDistinct());
                    Predef$.MODULE$.assert(unresolvedFunction.filter().isEmpty());
                    Predef$.MODULE$.assert(!unresolvedFunction.ignoreNulls());
                    Predef$.MODULE$.assert(unresolvedFunction.orderingWithinGroup().isEmpty());
                    Predef$.MODULE$.assert(!unresolvedFunction.isInternal());
                    return (B1)FunctionRegistry$.MODULE$.builtin().lookupFunction(FunctionIdentifier$.MODULE$.apply((String)unresolvedFunction.nameParts().head()), (Seq)unresolvedFunction.arguments());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof UnresolvedFunction;
            }
        });
    }

    public Literal apply(Object value, DataType dataType) {
        return new Literal(value, dataType);
    }

    public Option<Tuple2<Object, DataType>> unapply(Literal x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.value(), (Object)x$0.dataType()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Literal$.class);
    }

    public static final /* synthetic */ boolean $anonfun$validateLiteralValue$2(Literal$ $this, InternalRow row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DataType fieldDataType = (DataType)tuple2._1();
            int i = tuple2._2$mcI$sp();
            return row$1.isNullAt(i) || $this.doValidate$1(row$1.get(i, fieldDataType), fieldDataType);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doValidate$1(Object v, DataType dataType) {
        PhysicalDataType physicalDataType;
        while (true) {
            DataType dataType2 = dataType;
            if (v == null) {
                return true;
            }
            if (dataType2 instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType2;
                Class cls = objectType.cls();
                return cls.isInstance(v);
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
                continue;
            }
            physicalDataType = PhysicalDataType$.MODULE$.apply(dataType);
            if (physicalDataType instanceof PhysicalArrayType) {
                PhysicalArrayType physicalArrayType = (PhysicalArrayType)physicalDataType;
                DataType et = physicalArrayType.elementType();
                if (!(v instanceof ArrayData)) return false;
                ArrayData ar = (ArrayData)v;
                if (ar.numElements() == 0) return true;
                dataType = et;
                v = ar.get(0, et);
                continue;
            }
            if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
                return v instanceof byte[];
            }
            if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Boolean;
            }
            if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Byte;
            }
            if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
                return v instanceof CalendarInterval;
            }
            if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Integer;
            }
            if (physicalDataType instanceof PhysicalDecimalType) {
                return v instanceof Decimal;
            }
            if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Double;
            }
            if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Float;
            }
            if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
                return v instanceof Long;
            }
            if (!(physicalDataType instanceof PhysicalMapType)) break;
            PhysicalMapType physicalMapType = (PhysicalMapType)physicalDataType;
            DataType kt = physicalMapType.keyType();
            DataType vt = physicalMapType.valueType();
            if (!(v instanceof MapData)) return false;
            MapData map = (MapData)v;
            if (!this.doValidate$1(map.keyArray(), (DataType)ArrayType$.MODULE$.apply(kt))) return false;
            dataType = ArrayType$.MODULE$.apply(vt);
            v = map.valueArray();
        }
        if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
            return true;
        }
        if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            return v instanceof Short;
        }
        if (physicalDataType instanceof PhysicalStringType) {
            return v instanceof UTF8String;
        }
        if (physicalDataType instanceof PhysicalGeographyType) {
            return v instanceof GeographyVal;
        }
        if (physicalDataType instanceof PhysicalGeometryType) {
            return v instanceof GeometryVal;
        }
        if (PhysicalVariantType$.MODULE$.equals(physicalDataType)) {
            return v instanceof VariantVal;
        }
        if (!(physicalDataType instanceof PhysicalStructType)) return false;
        PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
        if (!(v instanceof InternalRow)) return false;
        InternalRow row = (InternalRow)v;
        if (!ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])physicalStructType.fields()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(DataType.class))))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Literal$.$anonfun$validateLiteralValue$2(this, row, x0$1)))) return false;
        return true;
    }

    private Literal$() {
    }
}

