/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.encoders.HashableWeakReference;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.util.SparkClassUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.matching.Regex;

public final class OuterScopes$ {
    public static final OuterScopes$ MODULE$ = new OuterScopes$();
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final ConcurrentHashMap<HashableWeakReference, ConcurrentHashMap<String, WeakReference<Object>>> outerScopes = new ConcurrentHashMap();
    private static final Regex REPLClass = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\$line(?:\\d+)\\.\\$read)(?:\\$\\$iw)+$"));
    private static final Regex AmmoniteREPLClass = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(ammonite\\.\\$sess\\.cmd(?:\\d+)\\$).*"));

    private HashableWeakReference classLoaderRef(Class<?> c) {
        return new HashableWeakReference(c.getClassLoader(), queue);
    }

    private void cleanOuterScopes() {
        Reference<Object> entry = queue.poll();
        while (entry != null) {
            outerScopes.remove(entry);
            entry = queue.poll();
        }
    }

    public void addOuterScope(Object outer) {
        this.cleanOuterScopes();
        Class<?> clz = outer.getClass();
        outerScopes.computeIfAbsent(this.classLoaderRef(clz), x$1 -> new ConcurrentHashMap()).putIfAbsent(clz.getName(), new WeakReference<Object>(outer));
    }

    public Function0<Object> getOuterScope(Class<?> innerCls) {
        if (!innerCls.isMemberClass()) {
            return null;
        }
        Class<?> outerClass = innerCls.getDeclaringClass();
        String outerClassName = outerClass.getName();
        Object outer = Option$.MODULE$.apply(outerScopes.get(this.classLoaderRef(outerClass))).flatMap((Function1 & Serializable)map -> Option$.MODULE$.apply(map.get(outerClassName))).map((Function1 & Serializable)x$2 -> x$2.get()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (outer == null) {
            Option option;
            Option option2;
            String string = outerClassName;
            if (string != null && !(option2 = AmmoniteREPLClass.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                String cellClassName = (String)((LinearSeqOps)option2.get()).apply(0);
                Class objClass = SparkClassUtils$.MODULE$.classForName(cellClassName, SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
                Object objInstance = objClass.getField("MODULE$").get(null);
                Object obj = objClass.getMethod("instance", new Class[0]).invoke(objInstance, new Object[0]);
                this.addOuterScope(obj);
                return (Function0 & Serializable)() -> obj;
            }
            if (string != null && !(option = REPLClass.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String baseClassName = (String)((LinearSeqOps)option.get()).apply(0);
                return (Function0 & Serializable)() -> {
                    Class objClass = SparkClassUtils$.MODULE$.classForName(baseClassName + "$", SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
                    Object objInstance = objClass.getField("MODULE$").get(null);
                    Object baseInstance = objClass.getMethod("INSTANCE", new Class[0]).invoke(objInstance, new Object[0]);
                    Class baseClass = SparkClassUtils$.MODULE$.classForName(baseClassName, SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
                    Method getter = MODULE$.iwGetter(baseClass);
                    Object obj = baseInstance;
                    while (getter != null) {
                        obj = getter.invoke(obj, new Object[0]);
                        getter = MODULE$.iwGetter(getter.getReturnType());
                    }
                    if (obj == null) {
                        throw ExecutionErrors$.MODULE$.cannotGetOuterPointerForInnerClassError(innerCls);
                    }
                    MODULE$.addOuterScope(obj);
                    return obj;
                };
            }
            return null;
        }
        return (Function0 & Serializable)() -> outer;
    }

    private Method iwGetter(Class<?> cls) {
        Method method;
        try {
            method = cls.getMethod("$iw", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        return method;
    }

    private OuterScopes$() {
    }
}

