/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.compressors.xz;

import coursierapi.shaded.commonscompress.MemoryLimitException;
import coursierapi.shaded.commonscompress.compressors.CompressorInputStream;
import coursierapi.shaded.commonsio.IOUtils;
import coursierapi.shaded.commonsio.input.CountingInputStream;
import coursierapi.shaded.xz.SingleXZInputStream;
import coursierapi.shaded.xz.XZInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XZCompressorInputStream
extends CompressorInputStream {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated) throws IOException {
        this(inputStream, decompressConcatenated, -1);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated, int memoryLimitInKb) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = decompressConcatenated ? new XZInputStream(this.countingStream, memoryLimitInKb) : new SingleXZInputStream(this.countingStream, memoryLimitInKb);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        try {
            int ret = this.in.read();
            this.count(ret == -1 ? -1 : 1);
            return ret;
        }
        catch (coursierapi.shaded.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        try {
            int ret = this.in.read(buf, off, len);
            this.count(ret);
            return ret;
        }
        catch (coursierapi.shaded.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return IOUtils.skip(this.in, n);
        }
        catch (coursierapi.shaded.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }
}

