/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.crypto.OsInfo;
import org.apache.commons.crypto.utils.Utils;

final class NativeCodeLoader {
    private static final int EOF = -1;
    private static final Throwable loadingError = NativeCodeLoader.loadLibrary();
    private static final boolean nativeCodeLoaded = loadingError == null;

    private static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    private static boolean contentsEquals(InputStream input1, InputStream input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedInputStream bufferedInput1 = NativeCodeLoader.buffer(input1);
        BufferedInputStream bufferedInput2 = NativeCodeLoader.buffer(input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    private static void debug(String format, Object ... args) {
        if (NativeCodeLoader.isDebug()) {
            System.out.println(String.format(format, args));
            if (args != null && args.length > 0 && args[0] instanceof Throwable) {
                ((Throwable)args[0]).printStackTrace(System.out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        UUID uuid = UUID.randomUUID();
        String extractedLibFileName = String.format("commons-crypto-%s-%s", uuid, libraryFileName);
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        NativeCodeLoader.debug("Extracting '%s' to '%s'...", nativeLibraryFilePath, extractedLibFile);
        try (InputStream inputStream = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);){
            block47: {
                if (inputStream == null) {
                    NativeCodeLoader.debug("Resource not found: %s", nativeLibraryFilePath);
                    File file2 = null;
                    return file2;
                }
                try {
                    Path path = extractedLibFile.toPath();
                    long byteCount = Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    if (!NativeCodeLoader.isDebug()) break block47;
                    NativeCodeLoader.debug("Extracted '%s' to '%s': %,d bytes [%s]", nativeLibraryFilePath, extractedLibFile, byteCount, Files.isExecutable(path) ? "X+" : "X-");
                    PosixFileAttributes attributes = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
                    if (attributes != null) {
                        NativeCodeLoader.debug("Attributes '%s': %s %s %s", extractedLibFile, attributes.permissions(), attributes.owner(), attributes.group());
                    }
                }
                catch (Throwable throwable3) {
                    NativeCodeLoader.debug("Delete on exit: %s", extractedLibFile);
                    extractedLibFile.deleteOnExit();
                    throw throwable3;
                }
            }
            NativeCodeLoader.debug("Delete on exit: %s", extractedLibFile);
            extractedLibFile.deleteOnExit();
            if (!extractedLibFile.setReadable(true)) throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
            if (!extractedLibFile.setExecutable(true)) throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
            if (!extractedLibFile.setWritable(true, true)) {
                throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
            }
            try (InputStream nativeInputStream = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);
                 FileInputStream extractedLibIn = new FileInputStream(extractedLibFile);){
                NativeCodeLoader.debug("Validating '%s'...", extractedLibFile);
                if (!NativeCodeLoader.contentsEquals(nativeInputStream, extractedLibIn)) {
                    throw new IllegalStateException(String.format("Failed to write a native library file %s to %s", nativeLibraryFilePath, extractedLibFile));
                }
            }
            File file = extractedLibFile;
            return file;
        }
        catch (IOException e) {
            NativeCodeLoader.debug("Ignoring %s", e);
            return null;
        }
    }

    private static File findNativeLibrary() {
        File nativeLib;
        Properties props = Utils.getDefaultProperties();
        String nativeLibraryPath = props.getProperty("commons.crypto.lib.path");
        String nativeLibraryName = props.getProperty("commons.crypto.lib.name");
        if (nativeLibraryName == null) {
            nativeLibraryName = System.mapLibraryName("commons-crypto");
        }
        if (nativeLibraryPath != null && (nativeLib = new File(nativeLibraryPath, nativeLibraryName)).exists()) {
            return nativeLib;
        }
        nativeLibraryPath = "/org/apache/commons/crypto/native/" + OsInfo.getNativeLibFolderPathForCurrentOS();
        boolean hasNativeLib = NativeCodeLoader.hasResource(nativeLibraryPath + "/" + nativeLibraryName);
        if (!hasNativeLib) {
            String altName = "libcommons-crypto.jnilib";
            if (OsInfo.getOSName().equals("Mac") && NativeCodeLoader.hasResource(nativeLibraryPath + "/" + "libcommons-crypto.jnilib")) {
                nativeLibraryName = "libcommons-crypto.jnilib";
                hasNativeLib = true;
            }
        }
        if (!hasNativeLib) {
            String errorMessage = String.format("No native library is found for os.name=%s and os.arch=%s", OsInfo.getOSName(), OsInfo.getArchName());
            throw new IllegalStateException(errorMessage);
        }
        String tempFolder = new File(props.getProperty("commons.crypto.lib.tempdir", System.getProperty("java.io.tmpdir"))).getAbsolutePath();
        return NativeCodeLoader.extractLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder);
    }

    static Throwable getLoadingError() {
        return loadingError;
    }

    private static boolean hasResource(String path) {
        return NativeCodeLoader.class.getResource(path) != null;
    }

    private static boolean isDebug() {
        return Boolean.getBoolean("commons.crypto.debug");
    }

    static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    static Throwable loadLibrary() {
        try {
            File nativeLibFile = NativeCodeLoader.findNativeLibrary();
            if (nativeLibFile != null) {
                String absolutePath = nativeLibFile.getAbsolutePath();
                NativeCodeLoader.debug("System.load('%s')", absolutePath);
                System.load(absolutePath);
            } else {
                String libname = "commons-crypto";
                NativeCodeLoader.debug("System.loadLibrary('%s')", "commons-crypto");
                System.loadLibrary("commons-crypto");
            }
            return null;
        }
        catch (Exception t) {
            return t;
        }
        catch (UnsatisfiedLinkError t) {
            return t;
        }
    }

    private NativeCodeLoader() {
    }
}

