/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class ExprNodeDynamicValueDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected DynamicValue dynamicValue;

    public ExprNodeDynamicValueDesc() {
    }

    public ExprNodeDynamicValueDesc(DynamicValue value) {
        super(value.getTypeInfo());
        this.dynamicValue = value;
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeDynamicValueDesc(this.dynamicValue);
    }

    @Override
    public boolean isSame(Object o) {
        if (o instanceof ExprNodeDynamicValueDesc) {
            DynamicValue otherValue = ((ExprNodeDynamicValueDesc)o).getDynamicValue();
            if (this.dynamicValue == null) {
                return otherValue == null;
            }
            return this.dynamicValue.equals(otherValue);
        }
        return false;
    }

    public DynamicValue getDynamicValue() {
        return this.dynamicValue;
    }

    public void setValue(DynamicValue value) {
        this.dynamicValue = value;
    }

    @Override
    public String getExprString() {
        return this.dynamicValue != null ? this.dynamicValue.toString() : "null dynamic literal";
    }

    public String toString() {
        return this.dynamicValue != null ? this.dynamicValue.toString() : "null dynamic literal";
    }
}

