/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.window;

import java.util.ArrayDeque;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.window.AggregateProcessor;
import org.apache.spark.sql.execution.window.BoundOrdering;
import org.apache.spark.sql.execution.window.WindowFunctionFrame;
import org.apache.spark.sql.execution.window.WindowFunctionFrame$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q4A\u0001E\t\u0003=!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!q\u0003A!A!\u0002\u0013y\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bM\u0002A\u0011\u0001\u001b\t\ri\u0002\u0001\u0015)\u0003<\u0011%y\u0004\u00011A\u0001B\u0003&\u0001\t\u0003\u0004U\u0001\u0001\u0006K\u0001\n\u0005\u0007+\u0002\u0001\u000b\u0011\u0002,\t\ry\u0003\u0001\u0015)\u0003`\u0011\u0019\u0019\u0007\u0001)Q\u0005?\")A\r\u0001C!K\")1\u000e\u0001C!Y\")\u0011\u000f\u0001C!e\")1\u000f\u0001C!e\nQ2\u000b\\5eS:<w+\u001b8e_^4UO\\2uS>tgI]1nK*\u0011!cE\u0001\u0007o&tGm\\<\u000b\u0005Q)\u0012!C3yK\u000e,H/[8o\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!C5\t\u0011#\u0003\u0002##\t\u0019r+\u001b8e_^4UO\\2uS>tgI]1nK\u00061A/\u0019:hKR\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\u000b\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\naJ|7-Z:t_J\u0004\"\u0001\t\u0017\n\u00055\n\"AE!hOJ,w-\u0019;f!J|7-Z:t_J\fa\u0001\u001c2pk:$\u0007C\u0001\u00111\u0013\t\t\u0014CA\u0007C_VtGm\u0014:eKJLgnZ\u0001\u0007k\n|WO\u001c3\u0002\rqJg.\u001b;?)\u0015)dg\u000e\u001d:!\t\u0001\u0003\u0001C\u0003$\u000b\u0001\u0007A\u0005C\u0003+\u000b\u0001\u00071\u0006C\u0003/\u000b\u0001\u0007q\u0006C\u00033\u000b\u0001\u0007q&A\u0003j]B,H\u000f\u0005\u0002={5\t1#\u0003\u0002?'\t\u0001S\t\u001f;fe:\fG.\u00119qK:$wJ\u001c7z+:\u001c\u0018MZ3S_^\f%O]1z\u00035Ig\u000e];u\u0013R,'/\u0019;peB\u0019\u0011i\u0013(\u000f\u0005\tCeBA\"G\u001b\u0005!%BA#\u001e\u0003\u0019a$o\\8u}%\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\u0015\u00069\u0001/Y2lC\u001e,'\"A$\n\u00051k%\u0001C%uKJ\fGo\u001c:\u000b\u0005%S\u0005CA(S\u001b\u0005\u0001&BA)'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005M\u0003&!C+og\u00064WMU8x\u0003\u001dqW\r\u001f;S_^\faAY;gM\u0016\u0014\bcA,]I5\t\u0001L\u0003\u0002Z5\u0006!Q\u000f^5m\u0015\u0005Y\u0016\u0001\u00026bm\u0006L!!\u0018-\u0003\u0015\u0005\u0013(/Y=EKF,X-\u0001\u0006m_^,'OQ8v]\u0012\u0004\"\u0001Y1\u000e\u0003)K!A\u0019&\u0003\u0007%sG/\u0001\u0006vaB,'OQ8v]\u0012\fq\u0001\u001d:fa\u0006\u0014X\r\u0006\u0002gSB\u0011\u0001mZ\u0005\u0003Q*\u0013A!\u00168ji\")!\u000e\u0004a\u0001w\u0005!!o\\<t\u0003\u00159(/\u001b;f)\r1Wn\u001c\u0005\u0006]6\u0001\raX\u0001\u0006S:$W\r\u001f\u0005\u0006a6\u0001\r\u0001J\u0001\bGV\u0014(/\u001a8u\u0003E\u0019WO\u001d:f]Rdun^3s\u0005>,h\u000e\u001a\u000b\u0002?\u0006\t2-\u001e:sK:$X\u000b\u001d9fe\n{WO\u001c3")
public final class SlidingWindowFunctionFrame
extends WindowFunctionFrame {
    private final InternalRow target;
    private final AggregateProcessor processor;
    private final BoundOrdering lbound;
    private final BoundOrdering ubound;
    private ExternalAppendOnlyUnsafeRowArray input;
    private Iterator<UnsafeRow> inputIterator;
    private InternalRow nextRow;
    private final ArrayDeque<InternalRow> buffer;
    private int lowerBound;
    private int upperBound;

    @Override
    public void prepare(ExternalAppendOnlyUnsafeRowArray rows) {
        this.input = rows;
        this.inputIterator = this.input.generateIterator();
        this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
        this.lowerBound = 0;
        this.upperBound = 0;
        this.buffer.clear();
    }

    @Override
    public void write(int index, InternalRow current) {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (!this.buffer.isEmpty() && this.lbound.compare(this.buffer.peek(), this.lowerBound, current, index) < 0) {
            this.buffer.remove();
            ++this.lowerBound;
            bufferUpdated = true;
        }
        while (this.nextRow != null && this.ubound.compare(this.nextRow, this.upperBound, current, index) <= 0) {
            if (this.lbound.compare(this.nextRow, this.lowerBound, current, index) < 0) {
                ++this.lowerBound;
            } else {
                this.buffer.add(this.nextRow.copy());
                bufferUpdated = true;
            }
            this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
            ++this.upperBound;
        }
        if (this.processor != null && bufferUpdated) {
            this.processor.initialize(this.input.length());
            java.util.Iterator<InternalRow> iter = this.buffer.iterator();
            while (iter.hasNext()) {
                this.processor.update(iter.next());
            }
            this.processor.evaluate(this.target);
            return;
        }
    }

    @Override
    public int currentLowerBound() {
        return this.lowerBound;
    }

    @Override
    public int currentUpperBound() {
        return this.upperBound;
    }

    public SlidingWindowFunctionFrame(InternalRow target, AggregateProcessor processor, BoundOrdering lbound, BoundOrdering ubound) {
        this.target = target;
        this.processor = processor;
        this.lbound = lbound;
        this.ubound = ubound;
        this.input = null;
        this.nextRow = null;
        this.buffer = new ArrayDeque();
        this.lowerBound = 0;
        this.upperBound = 0;
    }
}

