/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.List;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.SparkClassUtils$;
import org.sparkproject.connect.protobuf.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.ArraySeq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class LiteralValueProtoConverter$ {
    public static final LiteralValueProtoConverter$ MODULE$ = new LiteralValueProtoConverter$();

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal) {
        Object object;
        Expression.Literal.Builder builder;
        while (true) {
            builder = Expression.Literal.newBuilder();
            object = literal;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return builder.setBoolean(bl);
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                return builder.setByte(by);
            }
            if (object instanceof Short) {
                short s2 = BoxesRunTime.unboxToShort((Object)object);
                return builder.setShort(s2);
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return builder.setInteger(n);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return builder.setLong(l);
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return builder.setFloat(f);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return builder.setDouble(d);
            }
            if (object instanceof scala.math.BigDecimal) {
                scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof String) {
                String string = (String)object;
                return builder.setString(string);
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                return builder.setString(Character.toString(c));
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return builder.setString(String.valueOf(cArray));
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return builder.setBinary(ByteString.copyFrom(byArray));
            }
            if (object instanceof scala.collection.mutable.ArraySeq) {
                scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)object;
                literal = arraySeq.array();
                continue;
            }
            if (!(object instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)object;
            literal = arraySeq.unsafeArray();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return builder.setDate((int)localDate.toEpochDay());
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(Math.max(decimal.precision(), decimal.scale()), decimal.scale(), decimal.toString(), builder));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return builder.setTimestamp(SparkDateTimeUtils$.MODULE$.instantToMicros(instant));
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return builder.setTimestamp(SparkDateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return builder.setTimestampNtz(SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return builder.setDate(SparkDateTimeUtils$.MODULE$.fromJavaDate(date));
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return builder.setDayTimeInterval(SparkIntervalUtils$.MODULE$.durationToMicros(duration));
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return builder.setYearMonthInterval(SparkIntervalUtils$.MODULE$.periodToMonths(period));
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return builder.setArray(this.arrayBuilder$1(object2, builder));
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return builder.setCalendarInterval(LiteralValueProtoConverter$.calendarIntervalBuilder$1(calendarInterval.months, calendarInterval.days, calendarInterval.microseconds, builder));
        }
        if (object == null) {
            return builder.setNull(ProtoDataTypes$.MODULE$.NullType());
        }
        throw new UnsupportedOperationException("literal " + literal + " not supported (yet).");
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal, org.apache.spark.sql.types.DataType dataType) {
        Tuple2 tuple2;
        Expression.Literal.Builder builder;
        while (true) {
            Object object;
            Object v;
            builder = Expression.Literal.newBuilder();
            tuple2 = new Tuple2(literal, (Object)dataType);
            if (tuple2 != null && (v = tuple2._1()) instanceof Option) {
                Option option = (Option)v;
                if (tuple2._2() != null) {
                    if (option.isDefined()) {
                        return this.toLiteralProtoBuilder(option.get());
                    }
                    return builder.setNull(DataTypeProtoConverter$.MODULE$.toConnectProtoType(dataType));
                }
            }
            if (tuple2 != null && (object = tuple2._1()) == null) {
                return builder.setNull(DataTypeProtoConverter$.MODULE$.toConnectProtoType(dataType));
            }
            if (tuple2 != null) {
                Object v2 = tuple2._1();
                org.apache.spark.sql.types.DataType dataType2 = (org.apache.spark.sql.types.DataType)tuple2._2();
                if (v2 instanceof scala.collection.mutable.ArraySeq) {
                    scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)v2;
                    if (dataType2 instanceof ArrayType) {
                        literal = arraySeq.array();
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            Object v3 = tuple2._1();
            org.apache.spark.sql.types.DataType dataType3 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (!(v3 instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)v3;
            if (!(dataType3 instanceof ArrayType)) break;
            literal = arraySeq.unsafeArray();
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType4 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (v instanceof byte[]) {
                byte[] byArray = (byte[])v;
                if (dataType4 instanceof ArrayType) {
                    return this.toLiteralProtoBuilder(byArray);
                }
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType5 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType5 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType5;
                org.apache.spark.sql.types.DataType elementType = arrayType.elementType();
                return builder.setArray(LiteralValueProtoConverter$.arrayBuilder$2(v, elementType, builder));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType6 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType6 instanceof MapType) {
                MapType mapType = (MapType)dataType6;
                org.apache.spark.sql.types.DataType keyType = mapType.keyType();
                org.apache.spark.sql.types.DataType valueType = mapType.valueType();
                return builder.setMap(LiteralValueProtoConverter$.mapBuilder$1(v, keyType, valueType, builder));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType structType = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (structType instanceof StructType) {
                StructType structType2 = (StructType)structType;
                return builder.setStruct(this.structBuilder$1(v, structType2, builder));
            }
        }
        return this.toLiteralProtoBuilder(literal);
    }

    public <T> Expression.Literal.Builder create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Expression.Literal.Builder)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            org.apache.spark.sql.types.DataType dataType = schema.dataType();
            org.apache.spark.sql.types.DataType dataType2 = dataType;
            return MODULE$.toLiteralProtoBuilder(v, dataType2);
        }).getOrElse((Function0 & Serializable)() -> MODULE$.toLiteralProtoBuilder(v));
    }

    public Expression.Literal toLiteralProto(Object literal) {
        return this.toLiteralProtoBuilder(literal).build();
    }

    public Expression.Literal toLiteralProto(Object literal, org.apache.spark.sql.types.DataType dataType) {
        return this.toLiteralProtoBuilder(literal, dataType).build();
    }

    public org.apache.spark.sql.types.DataType toDataType(Class<?> clz) {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                Class<?> clazz = clz;
                                Class<Short> clazz2 = Short.TYPE;
                                Class<?> clazz3 = clazz;
                                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                                    return ShortType$.MODULE$;
                                }
                                Class<Integer> clazz4 = Integer.TYPE;
                                Class<?> clazz5 = clazz;
                                if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                                    return IntegerType$.MODULE$;
                                }
                                Class<Long> clazz6 = Long.TYPE;
                                Class<?> clazz7 = clazz;
                                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                                    return LongType$.MODULE$;
                                }
                                Class<Double> clazz8 = Double.TYPE;
                                Class<?> clazz9 = clazz;
                                if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                                    return DoubleType$.MODULE$;
                                }
                                Class<Byte> clazz10 = Byte.TYPE;
                                Class<?> clazz11 = clazz;
                                if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                    return ByteType$.MODULE$;
                                }
                                Class<Float> clazz12 = Float.TYPE;
                                Class<?> clazz13 = clazz;
                                if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                    return FloatType$.MODULE$;
                                }
                                Class<Boolean> clazz14 = Boolean.TYPE;
                                Class<?> clazz15 = clazz;
                                if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                    return BooleanType$.MODULE$;
                                }
                                Class<Character> clazz16 = Character.TYPE;
                                Class<?> clazz17 = clazz;
                                if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                                    return StringType$.MODULE$;
                                }
                                Class<?> clazz18 = clz;
                                Class<LocalDate> clazz19 = LocalDate.class;
                                if (!(clazz18 == null ? clazz19 != null : !clazz18.equals(clazz19))) break block33;
                                Class<?> clazz20 = clz;
                                Class<Date> clazz21 = Date.class;
                                if (clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null) break block34;
                            }
                            return DateType$.MODULE$;
                        }
                        Class<?> clazz = clz;
                        Class<Instant> clazz22 = Instant.class;
                        if (!(clazz == null ? clazz22 != null : !clazz.equals(clazz22))) break block35;
                        Class<?> clazz23 = clz;
                        Class<Timestamp> clazz24 = Timestamp.class;
                        if (clazz23 != null ? !clazz23.equals(clazz24) : clazz24 != null) break block36;
                    }
                    return TimestampType$.MODULE$;
                }
                Class<?> clazz = clz;
                Class<LocalDateTime> clazz25 = LocalDateTime.class;
                if (!(clazz != null ? !clazz.equals(clazz25) : clazz25 != null)) {
                    return TimestampNTZType$.MODULE$;
                }
                Class<?> clazz26 = clz;
                Class<Duration> clazz27 = Duration.class;
                if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null)) {
                    return DayTimeIntervalType$.MODULE$.DEFAULT();
                }
                Class<?> clazz28 = clz;
                Class<Period> clazz29 = Period.class;
                if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
                    return YearMonthIntervalType$.MODULE$.DEFAULT();
                }
                Class<?> clazz30 = clz;
                Class<BigDecimal> clazz31 = BigDecimal.class;
                if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
                    return DecimalType$.MODULE$.SYSTEM_DEFAULT();
                }
                Class<?> clazz32 = clz;
                Class<byte[]> clazz33 = byte[].class;
                if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
                    return BinaryType$.MODULE$;
                }
                Class<?> clazz34 = clz;
                Class<char[]> clazz35 = char[].class;
                if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
                    return StringType$.MODULE$;
                }
                Class<?> clazz36 = clz;
                Class<Short> clazz37 = Short.class;
                if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
                    return ShortType$.MODULE$;
                }
                Class<?> clazz38 = clz;
                Class<Integer> clazz39 = Integer.class;
                if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
                    return IntegerType$.MODULE$;
                }
                Class<?> clazz40 = clz;
                Class<Long> clazz41 = Long.class;
                if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
                    return LongType$.MODULE$;
                }
                Class<?> clazz42 = clz;
                Class<Double> clazz43 = Double.class;
                if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
                    return DoubleType$.MODULE$;
                }
                Class<?> clazz44 = clz;
                Class<Byte> clazz45 = Byte.class;
                if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
                    return ByteType$.MODULE$;
                }
                Class<?> clazz46 = clz;
                Class<Float> clazz47 = Float.class;
                if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
                    return FloatType$.MODULE$;
                }
                Class<?> clazz48 = clz;
                Class<Boolean> clazz49 = Boolean.class;
                if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
                    return BooleanType$.MODULE$;
                }
                Class<?> clazz50 = clz;
                Class<String> clazz51 = String.class;
                if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
                    return StringType$.MODULE$;
                }
                Class<?> clazz52 = clz;
                Class<BigInt> clazz53 = BigInt.class;
                if (!(clazz52 == null ? clazz53 != null : !clazz52.equals(clazz53))) break block37;
                Class<?> clazz54 = clz;
                Class<scala.math.BigDecimal> clazz55 = scala.math.BigDecimal.class;
                if (clazz54 != null ? !clazz54.equals(clazz55) : clazz55 != null) break block38;
            }
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz = clz;
        Class<CalendarInterval> clazz56 = CalendarInterval.class;
        if (!(clazz != null ? !clazz.equals(clazz56) : clazz56 != null)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (clz.isArray()) {
            return ArrayType$.MODULE$.apply(this.toDataType(clz.getComponentType()));
        }
        throw new UnsupportedOperationException("Unsupported component type " + clz + " in arrays.");
    }

    public Object toCatalystValue(Expression.Literal literal) {
        Expression.Literal.LiteralTypeCase literalTypeCase = literal.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            return null;
        }
        if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            return literal.getBinary().toByteArray();
        }
        if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            return BoxesRunTime.boxToBoolean((boolean)literal.getBoolean());
        }
        if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            return BoxesRunTime.boxToByte((byte)((byte)literal.getByte()));
        }
        if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            return BoxesRunTime.boxToShort((short)((short)literal.getShort()));
        }
        if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            return BoxesRunTime.boxToInteger((int)literal.getInteger());
        }
        if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            return BoxesRunTime.boxToLong((long)literal.getLong());
        }
        if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            return BoxesRunTime.boxToFloat((float)literal.getFloat());
        }
        if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            return BoxesRunTime.boxToDouble((double)literal.getDouble());
        }
        if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            return Decimal$.MODULE$.apply(literal.getDecimal().getValue());
        }
        if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            return literal.getString();
        }
        if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            return SparkDateTimeUtils$.MODULE$.toJavaDate(literal.getDate());
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            return SparkDateTimeUtils$.MODULE$.toJavaTimestamp(literal.getTimestamp());
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            return SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(literal.getTimestampNtz());
        }
        if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            return new CalendarInterval(literal.getCalendarInterval().getMonths(), literal.getCalendarInterval().getDays(), literal.getCalendarInterval().getMicroseconds());
        }
        if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            return SparkIntervalUtils$.MODULE$.monthsToPeriod(literal.getYearMonthInterval());
        }
        if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            return SparkIntervalUtils$.MODULE$.microsToDuration(literal.getDayTimeInterval());
        }
        if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            return this.toCatalystArray(literal.getArray());
        }
        throw new UnsupportedOperationException("Unsupported Literal Type: " + literalTypeCase.getNumber() + " (" + literalTypeCase.name() + ")");
    }

    private Function1<Expression.Literal, Object> getScalaConverter(DataType dataType) {
        Function1 & Serializable intersect;
        if (dataType.hasShort()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToShort((short)LiteralValueProtoConverter$.$anonfun$getScalaConverter$1(v));
        } else if (dataType.hasInteger()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)v.getInteger());
        } else if (dataType.hasLong()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToLong((long)v.getLong());
        } else if (dataType.hasDouble()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)v.getDouble());
        } else if (dataType.hasByte()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToByte((byte)LiteralValueProtoConverter$.$anonfun$getScalaConverter$5(v));
        } else if (dataType.hasFloat()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToFloat((float)v.getFloat());
        } else if (dataType.hasBoolean()) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.getBoolean());
        } else if (dataType.hasString()) {
            intersect = (Function1 & Serializable)v -> v.getString();
        } else if (dataType.hasBinary()) {
            intersect = (Function1 & Serializable)v -> v.getBinary().toByteArray();
        } else if (dataType.hasDate()) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.toJavaDate(v.getDate());
        } else if (dataType.hasTimestamp()) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.toJavaTimestamp(v.getTimestamp());
        } else if (dataType.hasTimestampNtz()) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(v.getTimestampNtz());
        } else if (dataType.hasDayTimeInterval()) {
            intersect = (Function1 & Serializable)v -> SparkIntervalUtils$.MODULE$.microsToDuration(v.getDayTimeInterval());
        } else if (dataType.hasYearMonthInterval()) {
            intersect = (Function1 & Serializable)v -> SparkIntervalUtils$.MODULE$.monthsToPeriod(v.getYearMonthInterval());
        } else if (dataType.hasDecimal()) {
            intersect = (Function1 & Serializable)v -> Decimal$.MODULE$.apply(v.getDecimal().getValue());
        } else if (dataType.hasCalendarInterval()) {
            intersect = (Function1 & Serializable)v -> {
                Expression.Literal.CalendarInterval interval = v.getCalendarInterval();
                return new CalendarInterval(interval.getMonths(), interval.getDays(), interval.getMicroseconds());
            };
        } else if (dataType.hasArray()) {
            intersect = (Function1 & Serializable)v -> MODULE$.toCatalystArray(v.getArray());
        } else if (dataType.hasMap()) {
            intersect = (Function1 & Serializable)v -> MODULE$.toCatalystMap(v.getMap());
        } else if (dataType.hasStruct()) {
            intersect = (Function1 & Serializable)v -> MODULE$.toCatalystStruct(v.getStruct());
        } else {
            throw new InvalidPlanInput("Unsupported Literal Type: " + dataType + ")", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        Function1 & Serializable converter = intersect;
        return (Function1 & Serializable)v -> {
            if (v.hasNull()) {
                return null;
            }
            return converter.apply(v);
        };
    }

    public Object toCatalystArray(Expression.Literal.Array array) {
        return LiteralValueProtoConverter$.makeArrayData$1(this.getScalaConverter(array.getElementType()), ClassTag$.MODULE$.Any(), array);
    }

    public scala.collection.mutable.Map<?, ?> toCatalystMap(Expression.Literal.Map map) {
        return LiteralValueProtoConverter$.makeMapData$1(this.getScalaConverter(map.getKeyType()), this.getScalaConverter(map.getValueType()), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.Any(), map);
    }

    public Object toCatalystStruct(Expression.Literal.Struct struct) {
        Buffer elements = CollectionConverters$.MODULE$.ListHasAsScala(struct.getElementsList()).asScala();
        Buffer dataTypes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(struct.getStructType().getStruct().getFieldsList()).asScala().map((Function1 & Serializable)x$2 -> x$2.getDataType());
        scala.collection.immutable.Seq structData = ((Seq)((IterableOps)elements.zip((IterableOnce)dataTypes)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression.Literal element = (Expression.Literal)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                return MODULE$.getScalaConverter(dataType).apply((Object)element);
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
        return LiteralValueProtoConverter$.toTuple$1(structData);
    }

    private static final Expression.Literal.Decimal.Builder decimalBuilder$1(int precision, int scale, String value, Expression.Literal.Builder builder$1) {
        return builder$1.getDecimalBuilder().setPrecision(precision).setScale(scale).setValue(value);
    }

    private static final Expression.Literal.CalendarInterval.Builder calendarIntervalBuilder$1(int months, int days, long microseconds, Expression.Literal.Builder builder$1) {
        return builder$1.getCalendarIntervalBuilder().setMonths(months).setDays(days).setMicroseconds(microseconds);
    }

    private final Expression.Literal.Array.Builder arrayBuilder$1(Object array, Expression.Literal.Builder builder$1) {
        Expression.Literal.Array.Builder ab = builder$1.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(this.toDataType(array.getClass().getComponentType())));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x -> ab.addElements(MODULE$.toLiteralProto(x)));
        return ab;
    }

    private static final Expression.Literal.Array.Builder arrayBuilder$2(Object scalaValue, org.apache.spark.sql.types.DataType elementType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Array.Builder ab = builder$2.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(elementType));
        Object object = scalaValue;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(object2), (Function1 & Serializable)item -> ab.addElements(MODULE$.toLiteralProto(item, elementType)));
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            seq.foreach((Function1 & Serializable)item -> ab.addElements(MODULE$.toLiteralProto(item, elementType)));
        } else {
            throw new IllegalArgumentException("literal " + object + " not supported (yet).");
        }
        return ab;
    }

    private static final Expression.Literal.Map.Builder mapBuilder$1(Object scalaValue, org.apache.spark.sql.types.DataType keyType, org.apache.spark.sql.types.DataType valueType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Map.Builder mb = builder$2.getMapBuilder().setKeyType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(keyType)).setValueType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(valueType));
        Object object = scalaValue;
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("literal " + object + " not supported (yet).");
        }
        Map map = (Map)object;
        map.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                mb.addKeys(MODULE$.toLiteralProto(k, keyType));
                return mb.addValues(MODULE$.toLiteralProto(v, valueType));
            }
            throw new MatchError((Object)tuple2);
        });
        return mb;
    }

    private final Expression.Literal.Struct.Builder structBuilder$1(Object scalaValue, StructType structType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Struct.Builder sb = builder$2.getStructBuilder().setStructType(DataTypeProtoConverter$.MODULE$.toConnectProtoType((org.apache.spark.sql.types.DataType)structType));
        org.apache.spark.sql.types.DataType[] dataTypes = (org.apache.spark.sql.types.DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(org.apache.spark.sql.types.DataType.class));
        Object object = scalaValue;
        if (object instanceof Product) {
            Product product = (Product)object;
            Iterator iter = product.productIterator();
            for (int idx = 0; idx < structType.size(); ++idx) {
                sb.addElements(this.toLiteralProto(iter.next(), dataTypes[idx]));
            }
        } else {
            throw new IllegalArgumentException("literal " + object + " not supported (yet).");
        }
        return sb;
    }

    public static final /* synthetic */ short $anonfun$getScalaConverter$1(Expression.Literal v) {
        return (short)v.getShort();
    }

    public static final /* synthetic */ byte $anonfun$getScalaConverter$5(Expression.Literal v) {
        return (byte)v.getByte();
    }

    private static final Object makeArrayData$1(Function1 converter, ClassTag tag, Expression.Literal.Array array$1) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        List<Expression.Literal> elementList = array$1.getElementsList();
        builder.sizeHint(elementList.size());
        java.util.Iterator<Expression.Literal> iter = elementList.iterator();
        while (iter.hasNext()) {
            builder.$plus$eq(converter.apply((Object)iter.next()));
        }
        return builder.result();
    }

    private static final scala.collection.mutable.Map makeMapData$1(Function1 keyConverter, Function1 valueConverter, ClassTag tagK, ClassTag tagV, Expression.Literal.Map map$1) {
        HashMap builder = HashMap$.MODULE$.empty();
        Buffer keys = CollectionConverters$.MODULE$.ListHasAsScala(map$1.getKeysList()).asScala();
        Buffer values = CollectionConverters$.MODULE$.ListHasAsScala(map$1.getValuesList()).asScala();
        builder.sizeHint(keys.size());
        ((IterableOnceOps)keys.zip((IterableOnce)values)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression.Literal key = (Expression.Literal)tuple2._1();
                Expression.Literal value = (Expression.Literal)tuple2._2();
                return (HashMap)builder.$plus$eq((Object)new Tuple2(keyConverter.apply((Object)key), valueConverter.apply((Object)value)));
            }
            throw new MatchError((Object)tuple2);
        });
        return builder;
    }

    private static final Product toTuple$1(scala.collection.immutable.Seq data) {
        Product product;
        try {
            Class tupleClass = SparkClassUtils$.MODULE$.classForName("scala.Tuple" + data.length(), SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
            product = (Product)((Constructor)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])tupleClass.getConstructors()))).newInstance((Object[])data.toArray(ClassTag$.MODULE$.Object()));
        }
        catch (Exception exception) {
            throw new InvalidPlanInput("Unsupported Literal: " + data.mkString("Array(", ", ", ")") + ")", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return product;
    }

    private LiteralValueProtoConverter$() {
    }
}

