/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerCollectionResponse;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerData;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerMetaData;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerTaskCommandQuery;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerTaskGrpc;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.cache.AsyncProfilerTaskCache;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.AsyncProfilerTaskLogRecord;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskLogOperationType;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.network.trace.component.command.AsyncProfilerTaskCommand;
import org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.stream.AsyncProfilerByteBufCollectionObserver;
import org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.stream.AsyncProfilerCollectionMetaData;
import org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.stream.AsyncProfilerFileCollectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfilerServiceHandler
extends AsyncProfilerTaskGrpc.AsyncProfilerTaskImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncProfilerServiceHandler.class);
    private final IAsyncProfilerTaskQueryDAO taskDAO;
    private final SourceReceiver sourceReceiver;
    private final CommandService commandService;
    private final AsyncProfilerTaskCache taskCache;
    private final int jfrMaxSize;
    private final boolean memoryParserEnabled;

    public AsyncProfilerServiceHandler(ModuleManager moduleManager, int jfrMaxSize, boolean memoryParserEnabled) {
        this.taskDAO = (IAsyncProfilerTaskQueryDAO)moduleManager.find("storage").provider().getService(IAsyncProfilerTaskQueryDAO.class);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.commandService = (CommandService)moduleManager.find("core").provider().getService(CommandService.class);
        this.taskCache = (AsyncProfilerTaskCache)moduleManager.find("core").provider().getService(AsyncProfilerTaskCache.class);
        this.jfrMaxSize = jfrMaxSize;
        this.memoryParserEnabled = memoryParserEnabled;
    }

    public StreamObserver<AsyncProfilerData> collect(StreamObserver<AsyncProfilerCollectionResponse> responseObserver) {
        return this.memoryParserEnabled ? new AsyncProfilerByteBufCollectionObserver(this.taskDAO, responseObserver, this.sourceReceiver, this.jfrMaxSize) : new AsyncProfilerFileCollectionObserver(this.taskDAO, responseObserver, this.sourceReceiver, this.jfrMaxSize);
    }

    public void getAsyncProfilerTaskCommands(AsyncProfilerTaskCommandQuery request, StreamObserver<Commands> responseObserver) {
        String serviceId = IDManager.ServiceID.buildId((String)request.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)request.getServiceInstance());
        AsyncProfilerTask task = this.taskCache.getAsyncProfilerTask(serviceId);
        if (Objects.isNull(task) || task.getCreateTime() <= request.getLastCommandTime() || !CollectionUtils.isEmpty((List)task.getServiceInstanceIds()) && !task.getServiceInstanceIds().contains(serviceInstanceId)) {
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
        AsyncProfilerTaskCommand asyncProfilerTaskCommand = this.commandService.newAsyncProfileTaskCommand(task);
        Commands commands = Commands.newBuilder().addCommands(asyncProfilerTaskCommand.serialize()).build();
        responseObserver.onNext((Object)commands);
        responseObserver.onCompleted();
        AsyncProfilerServiceHandler.recordAsyncProfilerTaskLog(task, serviceInstanceId, AsyncProfilerTaskLogOperationType.NOTIFIED);
    }

    public static void recordAsyncProfilerTaskLog(AsyncProfilerTask task, String instanceId, AsyncProfilerTaskLogOperationType operationType) {
        AsyncProfilerTaskLogRecord logRecord = new AsyncProfilerTaskLogRecord();
        logRecord.setTaskId(task.getId());
        logRecord.setInstanceId(instanceId);
        logRecord.setOperationType(operationType.getCode());
        logRecord.setOperationTime(System.currentTimeMillis());
        long timestamp = task.getCreateTime() + TimeUnit.SECONDS.toMillis(task.getDuration());
        logRecord.setTimestamp(timestamp);
        logRecord.setTimeBucket(TimeBucket.getRecordTimeBucket((long)timestamp));
        RecordStreamProcessor.getInstance().in((Record)logRecord);
    }

    public static AsyncProfilerCollectionMetaData parseMetaData(AsyncProfilerMetaData metaData, IAsyncProfilerTaskQueryDAO taskDAO) throws IOException {
        String taskId = metaData.getTaskId();
        AsyncProfilerTask task = taskDAO.getById(taskId);
        String serviceId = IDManager.ServiceID.buildId((String)metaData.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)metaData.getServiceInstance());
        return AsyncProfilerCollectionMetaData.builder().task(task).serviceId(serviceId).instanceId(serviceInstanceId).type(metaData.getType()).contentSize(metaData.getContentSize()).uploadTime(System.currentTimeMillis()).build();
    }
}

