/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.AssociationValue;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.XPath;
import org.apache.sis.filter.base.XPathSource;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

abstract class PropertyValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
XPathSource,
Optimization.OnExpression<AbstractFeature, V> {
    private static final long serialVersionUID = 3756361632664536269L;
    protected final String name;
    protected final boolean isVirtual;
    private static final String VIRTUAL_PREFIX = "/*/";

    protected PropertyValue(String name, boolean isVirtual) {
        this.name = name;
        this.isVirtual = isVirtual;
    }

    static <V> ValueReference<AbstractFeature, V> create(String xpath, Class<V> type) {
        XPath parsed = new XPath(xpath);
        List<String> path = parsed.path;
        boolean isVirtual = false;
        if (parsed.isAbsolute) {
            boolean bl = isVirtual = path != null && path.get(0).equals("*");
            if (!isVirtual) {
                throw new IllegalArgumentException(Errors.format((short)201, (Object)xpath));
            }
            path.remove(0);
            if (path.isEmpty()) {
                path = null;
            }
        }
        PropertyValue tip = type != Object.class ? new Converted<V>(type, parsed.tip, isVirtual) : new AsObject(parsed.tip, isVirtual);
        return path != null ? new AssociationValue<Object>(path, tip) : tip;
    }

    @Override
    public final Class<AbstractFeature> getResourceClass() {
        return AbstractFeature.class;
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.isVirtual ? List.of(this.name, Boolean.valueOf(this.isVirtual)) : List.of(this.name);
    }

    @Override
    public final String getXPath() {
        return this.getXPath(null);
    }

    final String getXPath(String[] path) {
        return XPath.toString(this.isVirtual ? VIRTUAL_PREFIX : null, path, this.name);
    }

    protected Class<?> getSourceClass() {
        return Object.class;
    }

    final FeatureProjectionBuilder.Item defaultType(FeatureProjectionBuilder addTo) {
        return addTo.addComputedProperty(((AttributeTypeBuilder)addTo.addAttribute(this.getResultClass()).setMinimumOccurs(0)).setName((CharSequence)this.name), true);
    }

    public final <N> PropertyValue<N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.getResultClass())) {
            return this;
        }
        if (target == Object.class) {
            return new AsObject(this.name, this.isVirtual);
        }
        Class<?> source = this.getSourceClass();
        if (source == Object.class) {
            return new Converted<N>(target, this.name, this.isVirtual);
        }
        if (target.isAssignableFrom(source)) {
            return new Unsafe(source, target, this.name, this.isVirtual);
        }
        return new CastedAndConverted(source, target, this.name, this.isVirtual);
    }

    @Override
    public abstract Expression<AbstractFeature, V> optimize(Optimization var1);

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        AbstractIdentifiedType type;
        try {
            type = addTo.source().getProperty(this.name);
        }
        catch (IllegalArgumentException e) {
            if (this.isVirtual) {
                return this.defaultType(addTo);
            }
            throw e;
        }
        return addTo.addSourceProperty(type, true);
    }

    private static class Converted<V>
    extends PropertyValue<V> {
        private static final long serialVersionUID = -1436865010478207066L;
        protected final Class<V> type;

        protected Converted(Class<V> type, String xpath, boolean isVirtual) {
            super(xpath, isVirtual);
            this.type = type;
        }

        @Override
        public final Class<V> getResultClass() {
            return this.type;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return (V)ObjectConverters.convert((Object)instance.getPropertyValue(this.name), this.type);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e);
                }
            }
            return null;
        }

        @Override
        public final Expression<AbstractFeature, V> optimize(Optimization optimization) {
            String preferredName;
            HashSet<String> found = new HashSet<String>();
            try {
                preferredName = optimization.getPreferredPropertyName(this.name, found);
            }
            catch (IllegalArgumentException e) {
                boolean resolved = found.isEmpty();
                optimization.warning(e, !resolved);
                return resolved ? Converted.NULL() : this;
            }
            HashMap actualTypes = new HashMap();
            ObjectConverter converter = optimization.constantResultForAllTypes(featureType -> {
                AbstractIdentifiedType property = featureType.getProperty(preferredName);
                Optional<String> target = Features.getLinkTarget(property);
                if (target.isPresent()) {
                    property = featureType.getProperty(target.get());
                }
                Class<Object> source = property instanceof DefaultAttributeType ? ((DefaultAttributeType)property).getValueClass() : this.getSourceClass();
                return actualTypes.computeIfAbsent(source, s -> ObjectConverters.find((Class)s, this.type));
            });
            Class source = (Class)Containers.peekIfSingleton(actualTypes.keySet());
            if (converter == null || preferredName.equals(this.name) && (source == null || source == this.getSourceClass())) {
                return this;
            }
            if (source == null) {
                source = converter.getSourceClass();
            }
            if (source == Object.class) {
                return new Converted<V>(this.type, preferredName, this.isVirtual);
            }
            if (this.type.isAssignableFrom(source)) {
                return new Unsafe(source, this.type, preferredName, this.isVirtual);
            }
            return new CastedAndConverted(source, this.type, preferredName, this.isVirtual);
        }

        @Override
        public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
            FeatureProjectionBuilder.Item item = super.expectedType(addTo);
            item.replaceValueClass(c -> this.type.isAssignableFrom((Class<?>)c) ? c : this.type);
            return item;
        }
    }

    private static final class AsObject
    extends PropertyValue<Object> {
        private static final long serialVersionUID = 2854731969723006038L;

        AsObject(String name, boolean isVirtual) {
            super(name, isVirtual);
        }

        @Override
        public Class<Object> getResultClass() {
            return Object.class;
        }

        @Override
        public Object apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return instance.getPropertyValue(this.name);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e);
                }
            }
            return null;
        }

        @Override
        public Expression<AbstractFeature, Object> optimize(Optimization optimization) {
            block3: {
                HashSet<String> found = new HashSet<String>();
                try {
                    String preferredName = optimization.getPreferredPropertyName(this.name, found);
                    if (!preferredName.equals(this.name)) {
                        return new AsObject(preferredName, this.isVirtual);
                    }
                }
                catch (IllegalArgumentException e) {
                    boolean resolved = found.isEmpty();
                    optimization.warning(e, !resolved);
                    if (!resolved) break block3;
                    return AsObject.NULL();
                }
            }
            return this;
        }
    }

    private static final class Unsafe<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -223028669950189532L;
        private final Class<S> source;

        Unsafe(Class<S> source, Class<V> type, String xpath, boolean isVirtual) {
            super(type, xpath, isVirtual);
            this.source = source;
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return (V)instance.getPropertyValue(this.name);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e);
                }
            }
            return null;
        }
    }

    private static final class CastedAndConverted<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -58453954752151703L;
        private final Class<S> source;
        private final ObjectConverter<? super S, ? extends V> converter;

        CastedAndConverted(Class<S> source, Class<V> type, String xpath, boolean isVirtual) {
            super(type, xpath, isVirtual);
            this.source = source;
            this.converter = ObjectConverters.find(source, type);
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return (V)this.converter.apply(this.source.cast(instance.getPropertyValue(this.name)));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    this.warning(e);
                }
            }
            return null;
        }
    }
}

