/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataRefresh
extends AbstractDataRefresh<MetaData> {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataRefresh.class);
    private final List<MetaDataSubscriber> metaDataSubscribers;

    public MetaDataRefresh(List<MetaDataSubscriber> metaDataSubscribers) {
        this.metaDataSubscribers = metaDataSubscribers;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.META_DATA.name());
    }

    @Override
    protected ConfigData<MetaData> fromJson(JsonObject data) {
        return (ConfigData)GsonUtils.getGson().fromJson((JsonElement)data, new TypeToken<ConfigData<MetaData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<MetaData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.META_DATA);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.META_DATA);
    }

    @Override
    protected void refresh(List<MetaData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all metaData cache");
            this.metaDataSubscribers.forEach(MetaDataSubscriber::refresh);
        } else {
            data.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> subscriber.onSubscribe(metaData)));
        }
    }
}

