/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.PropertyListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

public class ExpandedConfigurationListenerAdapter
implements ConfigurationListener {
    private PropertyListener expandedListener;
    static volatile boolean pauseListener;

    public static boolean isListenerPaused() {
        return pauseListener;
    }

    public static void setPauseListener(boolean bl) {
        pauseListener = bl;
    }

    public ExpandedConfigurationListenerAdapter(PropertyListener propertyListener) {
        if (propertyListener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this.expandedListener = propertyListener;
    }

    public PropertyListener getListener() {
        return this.expandedListener;
    }

    public void configurationChanged(ConfigurationEvent configurationEvent) {
        if (pauseListener) {
            return;
        }
        Object object = configurationEvent.getSource();
        String string = configurationEvent.getPropertyName();
        Object object2 = configurationEvent.getPropertyValue();
        boolean bl = configurationEvent.isBeforeUpdate();
        switch (configurationEvent.getType()) {
            case 11: 
            case 10001: {
                this.expandedListener.configSourceLoaded(object);
                break;
            }
            case 1: {
                this.expandedListener.addProperty(object, string, object2, bl);
                break;
            }
            case 4: {
                this.expandedListener.clear(object, bl);
                break;
            }
            case 2: {
                this.expandedListener.clearProperty(object, string, object2, bl);
                break;
            }
            case 10: {
                break;
            }
            case 40: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                this.expandedListener.setProperty(object, string, object2, bl);
                break;
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ExpandedConfigurationListenerAdapter) {
            ExpandedConfigurationListenerAdapter expandedConfigurationListenerAdapter = (ExpandedConfigurationListenerAdapter)object;
            return this.expandedListener.equals(expandedConfigurationListenerAdapter.expandedListener);
        }
        return false;
    }

    public int hashCode() {
        return this.expandedListener.hashCode();
    }
}

