/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.SchemaNameAdjuster;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectTableChangeSerializer
implements TableChanges.TableChangesSerializer<List<Struct>>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConnectTableChangeSerializer.class);
    private static final String ENUM_VALUES_KEY = "enumValues";
    private static final SchemaNameAdjuster SCHEMA_NAME_ADJUSTER = SchemaNameAdjuster.create();
    private static final Schema COLUMN_SCHEMA = SchemaBuilder.struct().name(SCHEMA_NAME_ADJUSTER.adjust("io.debezium.connector.schema.Column")).field("name", Schema.STRING_SCHEMA).field("jdbcType", Schema.INT32_SCHEMA).field("nativeType", Schema.OPTIONAL_INT32_SCHEMA).field("typeName", Schema.STRING_SCHEMA).field("typeExpression", Schema.OPTIONAL_STRING_SCHEMA).field("charsetName", Schema.OPTIONAL_STRING_SCHEMA).field("length", Schema.OPTIONAL_INT32_SCHEMA).field("scale", Schema.OPTIONAL_INT32_SCHEMA).field("position", Schema.INT32_SCHEMA).field("optional", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("autoIncremented", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("generated", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("comment", Schema.OPTIONAL_STRING_SCHEMA).field("enumValues", SchemaBuilder.array(Schema.STRING_SCHEMA).optional().build()).build();
    public static final Schema TABLE_SCHEMA = SchemaBuilder.struct().name(SCHEMA_NAME_ADJUSTER.adjust("io.debezium.connector.schema.Table")).field("defaultCharsetName", Schema.OPTIONAL_STRING_SCHEMA).field("primaryKeyColumnNames", SchemaBuilder.array(Schema.STRING_SCHEMA).optional().build()).field("columns", SchemaBuilder.array(COLUMN_SCHEMA).build()).field("comment", Schema.OPTIONAL_STRING_SCHEMA).build();
    public static final Schema CHANGE_SCHEMA = SchemaBuilder.struct().name(SCHEMA_NAME_ADJUSTER.adjust("io.debezium.connector.schema.Change")).field("type", Schema.STRING_SCHEMA).field("id", Schema.STRING_SCHEMA).field("table", TABLE_SCHEMA).build();

    @Override
    public List<Struct> serialize(TableChanges tableChanges) {
        return StreamSupport.stream(tableChanges.spliterator(), false).map(this::toStruct).collect(Collectors.toList());
    }

    @Override
    public TableChanges deserialize(List<Struct> data, boolean useCatalogBeforeSchema) {
        TableChanges tableChanges = new TableChanges();
        block5: for (Struct struct : data) {
            String tableId = struct.getString("id");
            TableChanges.TableChangeType changeType = TableChanges.TableChangeType.valueOf(struct.getString("type"));
            Table table = this.toTable(struct.getStruct("table"), TableId.parse(tableId));
            switch (changeType) {
                case CREATE: {
                    tableChanges.create(table);
                    continue block5;
                }
                case DROP: {
                    tableChanges.drop(table);
                    continue block5;
                }
                case ALTER: {
                    tableChanges.alter(table);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown table change type: " + (Object)((Object)changeType));
        }
        return tableChanges;
    }

    public Table toTable(Struct struct, TableId tableId) {
        return Table.editor().tableId(tableId).setDefaultCharsetName(struct.getString("defaultCharsetName")).setPrimaryKeyNames(struct.getArray("primaryKeyColumnNames")).setColumns(struct.getArray("columns").stream().map(Struct.class::cast).map(this::toColumn).collect(Collectors.toList())).create();
    }

    private Column toColumn(Struct struct) {
        ColumnEditor editor = Column.editor().name(struct.getString("name")).jdbcType(struct.getInt32("jdbcType")).type(struct.getString("typeName"), struct.getString("typeExpression")).charsetName(struct.getString("charsetName")).position(struct.getInt32("position")).optional(struct.getBoolean("optional")).autoIncremented(struct.getBoolean("autoIncremented")).generated(struct.getBoolean("generated"));
        if (struct.get("nativeType") != null) {
            editor.nativeType(struct.getInt32("nativeType"));
        }
        if (struct.get("length") != null) {
            editor.length(struct.getInt32("length"));
        }
        if (struct.get("scale") != null) {
            editor.scale(struct.getInt32("scale"));
        }
        if (struct.get("comment") != null) {
            editor.comment(struct.getString("comment"));
        }
        if (struct.schema().field(ENUM_VALUES_KEY) != null) {
            editor.enumValues(struct.getArray(ENUM_VALUES_KEY));
        }
        return editor.create();
    }

    public Struct toStruct(TableChanges.TableChange tableChange) {
        Struct struct = new Struct(CHANGE_SCHEMA);
        struct.put("type", (Object)tableChange.getType().name());
        struct.put("id", (Object)tableChange.getId().toDoubleQuotedString());
        struct.put("table", (Object)this.toStruct(tableChange.getTable()));
        return struct;
    }

    private Struct toStruct(Table table) {
        Struct struct = new Struct(TABLE_SCHEMA);
        struct.put("defaultCharsetName", (Object)table.defaultCharsetName());
        struct.put("primaryKeyColumnNames", table.primaryKeyColumnNames());
        List columns = table.columns().stream().map(this::toStruct).collect(Collectors.toList());
        struct.put("columns", columns);
        return struct;
    }

    private Struct toStruct(Column column) {
        Struct struct = new Struct(COLUMN_SCHEMA);
        struct.put("name", (Object)column.name());
        struct.put("jdbcType", (Object)column.jdbcType());
        if (column.nativeType() != -1) {
            struct.put("nativeType", (Object)column.nativeType());
        }
        struct.put("typeName", (Object)column.typeName());
        struct.put("typeExpression", (Object)column.typeExpression());
        struct.put("charsetName", (Object)column.charsetName());
        if (column.length() != -1) {
            struct.put("length", (Object)column.length());
        }
        column.scale().ifPresent(s2 -> struct.put("scale", s2));
        struct.put("position", (Object)column.position());
        struct.put("optional", (Object)column.isOptional());
        struct.put("autoIncremented", (Object)column.isAutoIncremented());
        struct.put("generated", (Object)column.isGenerated());
        struct.put("comment", (Object)column.comment());
        struct.put(ENUM_VALUES_KEY, column.enumValues());
        return struct;
    }
}

