/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.reader;

import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.event.MessageDelayedEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.connectors.cdc.base.source.event.CompletedSnapshotPhaseEvent;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceRecords;
import org.apache.seatunnel.connectors.cdc.base.source.split.state.IncrementalSplitState;
import org.apache.seatunnel.connectors.cdc.base.source.split.state.SourceSplitStateBase;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkEvent;
import org.apache.seatunnel.connectors.cdc.base.utils.MessageDelayedEventLimiter;
import org.apache.seatunnel.connectors.cdc.base.utils.SourceRecordUtils;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.RecordEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceRecordEmitter<T>
implements RecordEmitter<SourceRecords, T, SourceSplitStateBase> {
    private static final Logger log = LoggerFactory.getLogger(IncrementalSourceRecordEmitter.class);
    private static final String CDC_RECORD_FETCH_DELAY = "CDCRecordFetchDelay";
    private static final String CDC_RECORD_EMIT_DELAY = "CDCRecordEmitDelay";
    protected final DebeziumDeserializationSchema<T> debeziumDeserializationSchema;
    protected final OutputCollector<T> outputCollector;
    protected final OffsetFactory offsetFactory;
    protected final SourceReader.Context context;
    protected final Counter recordFetchDelay;
    protected final Counter recordEmitDelay;
    protected final EventListener eventListener;
    protected final MessageDelayedEventLimiter delayedEventLimiter = new MessageDelayedEventLimiter(Duration.ofSeconds(1L), 0.5);

    public IncrementalSourceRecordEmitter(DebeziumDeserializationSchema<T> debeziumDeserializationSchema, OffsetFactory offsetFactory, SourceReader.Context context) {
        this.debeziumDeserializationSchema = debeziumDeserializationSchema;
        this.outputCollector = new OutputCollector();
        this.offsetFactory = offsetFactory;
        this.context = context;
        this.recordFetchDelay = context.getMetricsContext().counter(CDC_RECORD_FETCH_DELAY);
        this.recordEmitDelay = context.getMetricsContext().counter(CDC_RECORD_EMIT_DELAY);
        this.eventListener = context.getEventListener();
    }

    @Override
    public void emitRecord(SourceRecords sourceRecords, Collector<T> collector, SourceSplitStateBase splitState) throws Exception {
        Iterator<SourceRecord> elementIterator = sourceRecords.iterator();
        while (elementIterator.hasNext()) {
            SourceRecord next = elementIterator.next();
            this.reportMetrics(next);
            this.processElement(next, collector, splitState);
            this.markEnterPureIncrementPhase(next, splitState);
        }
    }

    protected void reportMetrics(SourceRecord element) {
        long now = System.currentTimeMillis();
        Long messageTimestamp = SourceRecordUtils.getMessageTimestamp(element);
        if (messageTimestamp != null && messageTimestamp > 0L) {
            long emitDelay;
            Long fetchTimestamp = SourceRecordUtils.getFetchTimestamp(element);
            if (fetchTimestamp != null) {
                long fetchDelay = fetchTimestamp - messageTimestamp;
                this.recordFetchDelay.set(fetchDelay > 0L ? fetchDelay : 0L);
            }
            this.recordEmitDelay.set((emitDelay = now - messageTimestamp) > 0L ? emitDelay : 0L);
            if (this.delayedEventLimiter.acquire(messageTimestamp)) {
                this.eventListener.onEvent((Event)new MessageDelayedEvent(emitDelay, element.toString()));
            }
        }
    }

    protected void processElement(SourceRecord element, Collector<T> output, SourceSplitStateBase splitState) throws Exception {
        if (WatermarkEvent.isWatermarkEvent(element)) {
            Offset watermark = this.getWatermark(element);
            if (WatermarkEvent.isLowWatermarkEvent(element) && splitState.isSnapshotSplitState()) {
                splitState.asSnapshotSplitState().setLowWatermark(watermark);
            } else if (WatermarkEvent.isHighWatermarkEvent(element) && splitState.isSnapshotSplitState()) {
                splitState.asSnapshotSplitState().setHighWatermark(watermark);
            } else if ((WatermarkEvent.isSchemaChangeBeforeWatermarkEvent(element) || WatermarkEvent.isSchemaChangeAfterWatermarkEvent(element)) && splitState.isIncrementalSplitState()) {
                this.emitElement(element, output);
            }
        } else if (SourceRecordUtils.isSchemaChangeEvent(element) && splitState.isIncrementalSplitState()) {
            Offset position = this.getOffsetPosition(element);
            splitState.asIncrementalSplitState().setStartupOffset(position);
            this.emitElement(element, output);
        } else if (SourceRecordUtils.isDataChangeRecord(element) || SourceRecordUtils.isHeartbeatRecord(element)) {
            if (splitState.isIncrementalSplitState()) {
                Offset position = this.getOffsetPosition(element);
                splitState.asIncrementalSplitState().setStartupOffset(position);
            }
            this.emitElement(element, output);
        } else {
            this.emitElement(element, output);
        }
    }

    private void markEnterPureIncrementPhase(SourceRecord element, SourceSplitStateBase splitState) {
        if (splitState.isIncrementalSplitState()) {
            IncrementalSplitState incrementalSplitState = splitState.asIncrementalSplitState();
            if (incrementalSplitState.isEnterPureIncrementPhase()) {
                return;
            }
            Offset position = this.getOffsetPosition(element);
            if (incrementalSplitState.markEnterPureIncrementPhaseIfNeed(position)) {
                log.info("The current record position {} is after the maxSnapshotSplitsHighWatermark {}, mark enter pure increment phase.", (Object)position, (Object)incrementalSplitState.getMaxSnapshotSplitsHighWatermark());
                log.info("Clean the IncrementalSplit#completedSnapshotSplitInfos to empty.");
                CompletedSnapshotPhaseEvent completedSnapshotPhaseEvent = new CompletedSnapshotPhaseEvent(incrementalSplitState.getTableIds());
                this.context.sendSourceEventToEnumerator((SourceEvent)completedSnapshotPhaseEvent);
            }
        }
    }

    private Offset getWatermark(SourceRecord watermarkEvent) {
        return this.getOffsetPosition(watermarkEvent.sourceOffset());
    }

    public Offset getOffsetPosition(SourceRecord dataRecord) {
        return this.getOffsetPosition(dataRecord.sourceOffset());
    }

    public Offset getOffsetPosition(Map<String, ?> offset) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return this.offsetFactory.specific(offsetStrMap);
    }

    protected void emitElement(SourceRecord element, Collector<T> output) throws Exception {
        ((OutputCollector)this.outputCollector).output = output;
        this.debeziumDeserializationSchema.deserialize(element, this.outputCollector);
    }

    private class OutputCollector<T>
    implements Collector<T> {
        private Collector<T> output;

        private OutputCollector() {
        }

        public void collect(T record) {
            this.output.collect(record);
        }

        public void collect(SchemaChangeEvent event) {
            IncrementalSourceRecordEmitter.this.eventListener.onEvent((Event)event);
            this.output.collect(event);
        }

        public void markSchemaChangeBeforeCheckpoint() {
            this.output.markSchemaChangeBeforeCheckpoint();
        }

        public void markSchemaChangeAfterCheckpoint() {
            this.output.markSchemaChangeAfterCheckpoint();
        }

        public Object getCheckpointLock() {
            return this.output.getCheckpointLock();
        }
    }
}

