/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.enumerator;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.HybridSplitAssigner;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.SplitAssigner;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.state.PendingSplitsState;
import org.apache.seatunnel.connectors.cdc.base.source.event.CompletedSnapshotPhaseEvent;
import org.apache.seatunnel.connectors.cdc.base.source.event.CompletedSnapshotSplitsAckEvent;
import org.apache.seatunnel.connectors.cdc.base.source.event.CompletedSnapshotSplitsReportEvent;
import org.apache.seatunnel.connectors.cdc.base.source.event.SnapshotSplitWatermark;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceEnumerator
implements SourceSplitEnumerator<SourceSplitBase, PendingSplitsState> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceEnumerator.class);
    private final SourceSplitEnumerator.Context<SourceSplitBase> context;
    private final SplitAssigner splitAssigner;
    private final TreeSet<Integer> readersAwaitingSplit;
    private volatile boolean running;

    public IncrementalSourceEnumerator(SourceSplitEnumerator.Context<SourceSplitBase> context, SplitAssigner splitAssigner) {
        this.context = context;
        this.splitAssigner = splitAssigner;
        this.readersAwaitingSplit = new TreeSet();
        this.running = false;
    }

    public void open() {
        this.splitAssigner.open();
    }

    public synchronized void run() throws Exception {
        this.running = true;
        this.assignSplits();
    }

    public synchronized void handleSplitRequest(int subtaskId) {
        if (!this.context.registeredReaders().contains(subtaskId)) {
            return;
        }
        this.readersAwaitingSplit.add(subtaskId);
        if (this.running) {
            this.assignSplits();
        }
    }

    public void addSplitsBack(List<SourceSplitBase> splits, int subtaskId) {
        LOG.debug("Incremental Source Enumerator adds splits back: {}", splits);
        this.splitAssigner.addSplits(splits);
    }

    public int currentUnassignedSplitSize() {
        return 0;
    }

    public void registerReader(int subtaskId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof CompletedSnapshotSplitsReportEvent) {
            LOG.debug("The enumerator receives completed split watermarks(log offset) {} from subtask {}.", (Object)sourceEvent, (Object)subtaskId);
            CompletedSnapshotSplitsReportEvent reportEvent = (CompletedSnapshotSplitsReportEvent)sourceEvent;
            List<SnapshotSplitWatermark> completedSplitWatermarks = reportEvent.getCompletedSnapshotSplitWatermarks();
            SourceSplitEnumerator.Context<SourceSplitBase> context = this.context;
            synchronized (context) {
                this.splitAssigner.onCompletedSplits(completedSplitWatermarks);
            }
            CompletedSnapshotSplitsAckEvent ackEvent = new CompletedSnapshotSplitsAckEvent(completedSplitWatermarks.stream().map(SnapshotSplitWatermark::getSplitId).collect(Collectors.toList()));
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)ackEvent);
        } else if (sourceEvent instanceof CompletedSnapshotPhaseEvent) {
            LOG.debug("The enumerator receives completed snapshot phase event {} from subtask {}.", (Object)sourceEvent, (Object)subtaskId);
            CompletedSnapshotPhaseEvent event = (CompletedSnapshotPhaseEvent)sourceEvent;
            if (this.splitAssigner instanceof HybridSplitAssigner) {
                ((HybridSplitAssigner)this.splitAssigner).completedSnapshotPhase(event.getTableIds());
                LOG.info("Clean the SnapshotSplitAssigner#assignedSplits/splitCompletedOffsets to empty.");
            }
        }
    }

    public PendingSplitsState snapshotState(long checkpointId) {
        return this.splitAssigner.snapshotState(checkpointId);
    }

    public synchronized void notifyCheckpointComplete(long checkpointId) {
        this.splitAssigner.notifyCheckpointComplete(checkpointId);
        this.assignSplits();
    }

    public void close() {
        LOG.info("Closing enumerator...");
        this.splitAssigner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignSplits() {
        Iterator<Integer> awaitingReader = this.readersAwaitingSplit.iterator();
        while (awaitingReader.hasNext()) {
            Optional<SourceSplitBase> split;
            int nextAwaiting = awaitingReader.next();
            if (!this.context.registeredReaders().contains(nextAwaiting)) {
                awaitingReader.remove();
                continue;
            }
            SourceSplitEnumerator.Context<SourceSplitBase> context = this.context;
            synchronized (context) {
                split = this.splitAssigner.getNext();
            }
            if (split.isPresent()) {
                SourceSplitBase sourceSplit = split.get();
                this.context.assignSplit(nextAwaiting, (SourceSplit)sourceSplit);
                awaitingReader.remove();
                LOG.debug("Assign split {} to subtask {}", (Object)sourceSplit, (Object)nextAwaiting);
                continue;
            }
            if (this.splitAssigner.waitingForCompletedSplits()) break;
            LOG.info("No more splits available, signal no more splits to subtask {}", (Object)nextAwaiting);
            this.context.signalNoMoreSplits(nextAwaiting);
            awaitingReader.remove();
        }
    }
}

