/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.model;

import com.alibaba.fastjson2.annotation.JSONField;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.enums.SubjectType;
import org.apache.rocketmq.auth.authentication.model.User;

public interface Subject {
    @JSONField(serialize=false)
    public String getSubjectKey();

    public SubjectType getSubjectType();

    default public boolean isSubject(SubjectType subjectType) {
        return subjectType == this.getSubjectType();
    }

    public static <T extends Subject> T of(String subjectKey) {
        String type = StringUtils.substringBefore((String)subjectKey, (String)":");
        SubjectType subjectType = SubjectType.getByName(type);
        if (subjectType == null) {
            return null;
        }
        if (subjectType == SubjectType.USER) {
            return (T)User.of(StringUtils.substringAfter((String)subjectKey, (String)":"));
        }
        return null;
    }
}

