/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.LogSearchRuleResourcePatch;
import com.microsoft.azure.management.monitor.implementation.LogSearchRuleResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ScheduledQueryRulesInner
implements InnerSupportsGet<LogSearchRuleResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<LogSearchRuleResourceInner> {
    private ScheduledQueryRulesService service;
    private MonitorManagementClientImpl client;

    public ScheduledQueryRulesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (ScheduledQueryRulesService)retrofit.create(ScheduledQueryRulesService.class);
        this.client = client;
    }

    public LogSearchRuleResourceInner createOrUpdate(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        return (LogSearchRuleResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<LogSearchRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters, ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    public Observable<LogSearchRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>(){

            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return (LogSearchRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogSearchRuleResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-04-16";
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-04-16", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>(){

            public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ScheduledQueryRulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogSearchRuleResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogSearchRuleResourceInner>(){}.getType()).register(201, new TypeToken<LogSearchRuleResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public LogSearchRuleResourceInner getByResourceGroup(String resourceGroupName, String ruleName) {
        return (LogSearchRuleResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body());
    }

    public ServiceFuture<LogSearchRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName, ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<LogSearchRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>(){

            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return (LogSearchRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogSearchRuleResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        return this.service.getByResourceGroup(resourceGroupName, ruleName, this.client.subscriptionId(), "2018-04-16", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>(){

            public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ScheduledQueryRulesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogSearchRuleResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogSearchRuleResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public LogSearchRuleResourceInner update(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        return (LogSearchRuleResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<LogSearchRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters, ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    public Observable<LogSearchRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>(){

            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return (LogSearchRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<LogSearchRuleResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-04-16";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-04-16", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>(){

            public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ScheduledQueryRulesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogSearchRuleResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogSearchRuleResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        return this.service.delete(resourceGroupName, ruleName, this.client.subscriptionId(), "2018-04-16", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ScheduledQueryRulesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<LogSearchRuleResourceInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page){

            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<LogSearchRuleResourceInner>> listAsync(ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<LogSearchRuleResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>(){

            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<LogSearchRuleResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        String filter = null;
        return this.service.list(this.client.subscriptionId(), "2018-04-16", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>(){

            public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ScheduledQueryRulesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<LogSearchRuleResourceInner> list(String filter) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync(filter).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page){

            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<LogSearchRuleResourceInner>> listAsync(String filter, ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(filter), serviceCallback);
    }

    public Observable<Page<LogSearchRuleResourceInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>(){

            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<LogSearchRuleResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listWithServiceResponseAsync(String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        return this.service.list(this.client.subscriptionId(), "2018-04-16", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>(){

            public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ScheduledQueryRulesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<LogSearchRuleResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<LogSearchRuleResourceInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page){

            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>(){

            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<LogSearchRuleResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        String filter = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-04-16", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>(){

            public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ScheduledQueryRulesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<LogSearchRuleResourceInner> listByResourceGroup(String resourceGroupName, String filter) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page){

            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, String filter, ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter), serviceCallback);
    }

    public Observable<Page<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).map((Func1)new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>(){

            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<LogSearchRuleResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-04-16";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-04-16", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>(){

            public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ScheduledQueryRulesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<LogSearchRuleResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ScheduledQueryRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Body LogSearchRuleResourceInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Body LogSearchRuleResourcePatch var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules list"})
        @GET(value="subscriptions/{subscriptionId}/providers/microsoft.insights/scheduledQueryRules")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Query(value="$filter") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Query(value="$filter") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

